/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.networkfirewall.internal.NetworkFirewallServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.networkfirewall.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.AcceptNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.AssociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.CreateVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DeleteVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFirewallResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeFlowOperationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupMetadataResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeRuleGroupSummaryResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationRequest;
import software.amazon.awssdk.services.networkfirewall.model.DescribeVpcEndpointAssociationResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateAvailabilityZonesResponse;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsRequest;
import software.amazon.awssdk.services.networkfirewall.model.DisassociateSubnetsResponse;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.GetAnalysisReportResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.InsufficientCapacityException;
import software.amazon.awssdk.services.networkfirewall.model.InternalServerErrorException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidOperationException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidRequestException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidResourcePolicyException;
import software.amazon.awssdk.services.networkfirewall.model.InvalidTokenException;
import software.amazon.awssdk.services.networkfirewall.model.LimitExceededException;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListAnalysisReportsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallPoliciesResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFirewallsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationResultsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListFlowOperationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListRuleGroupsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.networkfirewall.model.ListVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.networkfirewall.model.LogDestinationPermissionException;
import software.amazon.awssdk.services.networkfirewall.model.NetworkFirewallException;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentRequest;
import software.amazon.awssdk.services.networkfirewall.model.RejectNetworkFirewallTransitGatewayAttachmentResponse;
import software.amazon.awssdk.services.networkfirewall.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkfirewall.model.ResourceOwnerCheckException;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartAnalysisReportResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowCaptureResponse;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushRequest;
import software.amazon.awssdk.services.networkfirewall.model.StartFlowFlushResponse;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.TagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.ThrottlingException;
import software.amazon.awssdk.services.networkfirewall.model.UnsupportedOperationException;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkfirewall.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateAvailabilityZoneChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallAnalysisSettingsResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDeleteProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallDescriptionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallEncryptionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateFirewallPolicyResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateLoggingConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateRuleGroupResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest;
import software.amazon.awssdk.services.networkfirewall.model.UpdateTlsInspectionConfigurationResponse;
import software.amazon.awssdk.services.networkfirewall.transform.AcceptNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.AssociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.CreateVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DeleteVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallMetadataRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFirewallRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeFlowOperationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupMetadataRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeRuleGroupSummaryRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DescribeVpcEndpointAssociationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.DisassociateSubnetsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.GetAnalysisReportResultsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListAnalysisReportsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallPoliciesRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFirewallsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFlowOperationResultsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListFlowOperationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListRuleGroupsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListTlsInspectionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.ListVpcEndpointAssociationsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.RejectNetworkFirewallTransitGatewayAttachmentRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartAnalysisReportRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartFlowCaptureRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.StartFlowFlushRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateAvailabilityZoneChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallAnalysisSettingsRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDeleteProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallDescriptionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallEncryptionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateFirewallPolicyRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateRuleGroupRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateSubnetChangeProtectionRequestMarshaller;
import software.amazon.awssdk.services.networkfirewall.transform.UpdateTlsInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link NetworkFirewallClient}.
 *
 * @see NetworkFirewallClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNetworkFirewallClient implements NetworkFirewallClient {
    private static final Logger log = Logger.loggerFor(DefaultNetworkFirewallClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNetworkFirewallClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Network_Firewall" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a transit gateway attachment request for Network Firewall. When you accept the attachment request,
     * Network Firewall creates the necessary routing components to enable traffic flow between the transit gateway and
     * firewall endpoints.
     * </p>
     * <p>
     * You must accept a transit gateway attachment to complete the creation of a transit gateway-attached firewall,
     * unless auto-accept is enabled on the transit gateway. After acceptance, use <a>DescribeFirewall</a> to verify the
     * firewall status.
     * </p>
     * <p>
     * To reject an attachment instead of accepting it, use <a>RejectNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * It can take several minutes for the attachment acceptance to complete and the firewall to become available.
     * </p>
     * </note>
     *
     * @param acceptNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the AcceptNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AcceptNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AcceptNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptNetworkFirewallTransitGatewayAttachmentResponse acceptNetworkFirewallTransitGatewayAttachment(
            AcceptNetworkFirewallTransitGatewayAttachmentRequest acceptNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AcceptNetworkFirewallTransitGatewayAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptNetworkFirewallTransitGatewayAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptNetworkFirewallTransitGatewayAttachmentRequest, AcceptNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("AcceptNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(acceptNetworkFirewallTransitGatewayAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified Availability Zones with a transit gateway-attached firewall. For each Availability Zone,
     * Network Firewall creates a firewall endpoint to process traffic. You can specify one or more Availability Zones
     * where you want to deploy the firewall.
     * </p>
     * <p>
     * After adding Availability Zones, you must update your transit gateway route tables to direct traffic through the
     * new firewall endpoints. Use <a>DescribeFirewall</a> to monitor the status of the new endpoints.
     * </p>
     *
     * @param associateAvailabilityZonesRequest
     * @return Result of the AssociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateAvailabilityZonesResponse associateAvailabilityZones(
            AssociateAvailabilityZonesRequest associateAvailabilityZonesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, InsufficientCapacityException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateAvailabilityZonesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateAvailabilityZonesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAvailabilityZonesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAvailabilityZonesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAvailabilityZones");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateAvailabilityZonesRequest, AssociateAvailabilityZonesResponse>()
                            .withOperationName("AssociateAvailabilityZones").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateAvailabilityZonesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateAvailabilityZonesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a <a>FirewallPolicy</a> to a <a>Firewall</a>.
     * </p>
     * <p>
     * A firewall policy defines how to monitor and manage your VPC network traffic, using a collection of inspection
     * rule groups and other settings. Each firewall requires one firewall policy association, and you can use the same
     * firewall policy for multiple firewalls.
     * </p>
     *
     * @param associateFirewallPolicyRequest
     * @return Result of the AssociateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateFirewallPolicyResponse associateFirewallPolicy(AssociateFirewallPolicyRequest associateFirewallPolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateFirewallPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFirewallPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateFirewallPolicyRequest, AssociateFirewallPolicyResponse>()
                            .withOperationName("AssociateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateFirewallPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateFirewallPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified subnets in the Amazon VPC to the firewall. You can specify one subnet for each of the
     * Availability Zones that the VPC spans.
     * </p>
     * <p>
     * This request creates an Network Firewall firewall endpoint in each of the subnets. To enable the firewall's
     * protections, you must also modify the VPC's route tables for each subnet's Availability Zone, to redirect the
     * traffic that's coming into and going out of the zone through the firewall endpoint.
     * </p>
     *
     * @param associateSubnetsRequest
     * @return Result of the AssociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.AssociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/AssociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSubnetsResponse associateSubnets(AssociateSubnetsRequest associateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, InsufficientCapacityException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSubnetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateSubnetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSubnetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSubnets");

            return clientHandler.execute(new ClientExecutionParams<AssociateSubnetsRequest, AssociateSubnetsResponse>()
                    .withOperationName("AssociateSubnets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateSubnetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateSubnetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Network Firewall <a>Firewall</a> and accompanying <a>FirewallStatus</a> for a VPC.
     * </p>
     * <p>
     * The firewall defines the configuration settings for an Network Firewall firewall. The settings that you can
     * define at creation include the firewall policy, the subnets in your VPC to use for the firewall endpoints, and
     * any tags that are attached to the firewall Amazon Web Services resource.
     * </p>
     * <p>
     * After you create a firewall, you can provide additional settings, like the logging configuration.
     * </p>
     * <p>
     * To update the settings for a firewall, you use the operations that apply to the settings themselves, for example
     * <a>UpdateLoggingConfiguration</a>, <a>AssociateSubnets</a>, and <a>UpdateFirewallDeleteProtection</a>.
     * </p>
     * <p>
     * To manage a firewall's tags, use the standard Amazon Web Services resource tagging operations,
     * <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about firewalls, use <a>ListFirewalls</a> and <a>DescribeFirewall</a>.
     * </p>
     * <p>
     * To generate a report on the last 30 days of traffic monitored by a firewall, use <a>StartAnalysisReport</a>.
     * </p>
     *
     * @param createFirewallRequest
     * @return Result of the CreateFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFirewallResponse createFirewall(CreateFirewallRequest createFirewallRequest) throws InvalidRequestException,
            LimitExceededException, InternalServerErrorException, ThrottlingException, InsufficientCapacityException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFirewallResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFirewallResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewall");

            return clientHandler.execute(new ClientExecutionParams<CreateFirewallRequest, CreateFirewallResponse>()
                    .withOperationName("CreateFirewall").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFirewallRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFirewallRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the firewall policy for the firewall according to the specifications.
     * </p>
     * <p>
     * An Network Firewall firewall policy defines the behavior of a firewall, in a collection of stateless and stateful
     * rule groups and other settings. You can use one firewall policy for multiple firewalls.
     * </p>
     *
     * @param createFirewallPolicyRequest
     * @return Result of the CreateFirewallPolicy operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFirewallPolicyResponse createFirewallPolicy(CreateFirewallPolicyRequest createFirewallPolicyRequest)
            throws LimitExceededException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InsufficientCapacityException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFirewallPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallPolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateFirewallPolicyRequest, CreateFirewallPolicyResponse>()
                    .withOperationName("CreateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFirewallPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFirewallPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection,
     * a capacity setting, and tags.
     * </p>
     * <p>
     * You provide your rule group specification in your request using either <code>RuleGroup</code> or
     * <code>Rules</code>.
     * </p>
     *
     * @param createRuleGroupRequest
     * @return Result of the CreateRuleGroup operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRuleGroupResponse createRuleGroup(CreateRuleGroupRequest createRuleGroupRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRuleGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateRuleGroupRequest, CreateRuleGroupResponse>()
                    .withOperationName("CreateRuleGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRuleGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Network Firewall TLS inspection configuration. Network Firewall uses TLS inspection configurations to
     * decrypt your firewall's inbound and outbound SSL/TLS traffic. After decryption, Network Firewall inspects the
     * traffic according to your firewall policy's stateful rules, and then re-encrypts it before sending it to its
     * destination. You can enable inspection of your firewall's inbound traffic, outbound traffic, or both. To use TLS
     * inspection with your firewall, you must first import or provision certificates using ACM, create a TLS inspection
     * configuration, add that configuration to a new firewall policy, and then associate that policy with your
     * firewall.
     * </p>
     * <p>
     * To update the settings for a TLS inspection configuration, use <a>UpdateTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * To manage a TLS inspection configuration's tags, use the standard Amazon Web Services resource tagging
     * operations, <a>ListTagsForResource</a>, <a>TagResource</a>, and <a>UntagResource</a>.
     * </p>
     * <p>
     * To retrieve information about TLS inspection configurations, use <a>ListTLSInspectionConfigurations</a> and
     * <a>DescribeTLSInspectionConfiguration</a>.
     * </p>
     * <p>
     * For more information about TLS inspection configurations, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html">Inspecting SSL/TLS
     * traffic with TLS inspection configurations</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     *
     * @param createTlsInspectionConfigurationRequest
     * @return Result of the CreateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTlsInspectionConfigurationResponse createTLSInspectionConfiguration(
            CreateTlsInspectionConfigurationRequest createTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, LimitExceededException, InsufficientCapacityException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTlsInspectionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTlsInspectionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTLSInspectionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTlsInspectionConfigurationRequest, CreateTlsInspectionConfigurationResponse>()
                            .withOperationName("CreateTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTlsInspectionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTlsInspectionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a firewall endpoint for an Network Firewall firewall. This type of firewall endpoint is independent of
     * the firewall endpoints that you specify in the <code>Firewall</code> itself, and you define it in addition to
     * those endpoints after the firewall has been created. You can define a VPC endpoint association using a different
     * VPC than the one you used in the firewall specifications.
     * </p>
     *
     * @param createVpcEndpointAssociationRequest
     * @return Result of the CreateVpcEndpointAssociation operation returned by the service.
     * @throws LimitExceededException
     *         Unable to perform the operation because doing so would violate a limit setting.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InsufficientCapacityException
     *         Amazon Web Services doesn't currently have enough available capacity to fulfill your request. Try your
     *         request later.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.CreateVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/CreateVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcEndpointAssociationResponse createVpcEndpointAssociation(
            CreateVpcEndpointAssociationRequest createVpcEndpointAssociationRequest) throws LimitExceededException,
            InvalidRequestException, ThrottlingException, InternalServerErrorException, InsufficientCapacityException,
            ResourceNotFoundException, InvalidOperationException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVpcEndpointAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointAssociationRequest, CreateVpcEndpointAssociationResponse>()
                            .withOperationName("CreateVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVpcEndpointAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpcEndpointAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>Firewall</a> and its <a>FirewallStatus</a>. This operation requires the firewall's
     * <code>DeleteProtection</code> flag to be <code>FALSE</code>. You can't revert this operation.
     * </p>
     * <p>
     * You can check whether a firewall is in use by reviewing the route tables for the Availability Zones where you
     * have firewall subnet mappings. Retrieve the subnet mappings by calling <a>DescribeFirewall</a>. You define and
     * update the route tables through Amazon VPC. As needed, update the route tables for the zones to remove the
     * firewall endpoints. When the route tables no longer use the firewall endpoints, you can remove the firewall
     * safely.
     * </p>
     * <p>
     * To delete a firewall, remove the delete protection if you need to using <a>UpdateFirewallDeleteProtection</a>,
     * then delete the firewall by calling <a>DeleteFirewall</a>.
     * </p>
     *
     * @param deleteFirewallRequest
     * @return Result of the DeleteFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFirewallResponse deleteFirewall(DeleteFirewallRequest deleteFirewallRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, UnsupportedOperationException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFirewallResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFirewallResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewall");

            return clientHandler.execute(new ClientExecutionParams<DeleteFirewallRequest, DeleteFirewallResponse>()
                    .withOperationName("DeleteFirewall").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFirewallRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFirewallRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>FirewallPolicy</a>.
     * </p>
     *
     * @param deleteFirewallPolicyRequest
     * @return Result of the DeleteFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFirewallPolicyResponse deleteFirewallPolicy(DeleteFirewallPolicyRequest deleteFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            UnsupportedOperationException, InvalidOperationException, AwsServiceException, SdkClientException,
            NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFirewallPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteFirewallPolicyRequest, DeleteFirewallPolicyResponse>()
                    .withOperationName("DeleteFirewallPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFirewallPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFirewallPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a transit gateway attachment from a Network Firewall. Either the firewall owner or the transit gateway
     * owner can delete the attachment.
     * </p>
     * <important>
     * <p>
     * After you delete a transit gateway attachment, traffic will no longer flow through the firewall endpoints.
     * </p>
     * </important>
     * <p>
     * After you initiate the delete operation, use <a>DescribeFirewall</a> to monitor the deletion status.
     * </p>
     *
     * @param deleteNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the DeleteNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkFirewallTransitGatewayAttachmentResponse deleteNetworkFirewallTransitGatewayAttachment(
            DeleteNetworkFirewallTransitGatewayAttachmentRequest deleteNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteNetworkFirewallTransitGatewayAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkFirewallTransitGatewayAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkFirewallTransitGatewayAttachmentRequest, DeleteNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("DeleteNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteNetworkFirewallTransitGatewayAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>RuleGroup</a>.
     * </p>
     *
     * @param deleteRuleGroupRequest
     * @return Result of the DeleteRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws UnsupportedOperationException
     *         The operation you requested isn't supported by Network Firewall.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRuleGroupResponse deleteRuleGroup(DeleteRuleGroupRequest deleteRuleGroupRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, UnsupportedOperationException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRuleGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteRuleGroupRequest, DeleteRuleGroupResponse>()
                    .withOperationName("DeleteRuleGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRuleGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>TLSInspectionConfiguration</a>.
     * </p>
     *
     * @param deleteTlsInspectionConfigurationRequest
     * @return Result of the DeleteTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTlsInspectionConfigurationResponse deleteTLSInspectionConfiguration(
            DeleteTlsInspectionConfigurationRequest deleteTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTlsInspectionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTlsInspectionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTLSInspectionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTlsInspectionConfigurationRequest, DeleteTlsInspectionConfigurationResponse>()
                            .withOperationName("DeleteTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTlsInspectionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTlsInspectionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified <a>VpcEndpointAssociation</a>.
     * </p>
     * <p>
     * You can check whether an endpoint association is in use by reviewing the route tables for the Availability Zones
     * where you have the endpoint subnet mapping. You can retrieve the subnet mapping by calling
     * <a>DescribeVpcEndpointAssociation</a>. You define and update the route tables through Amazon VPC. As needed,
     * update the route tables for the Availability Zone to remove the firewall endpoint for the association. When the
     * route tables no longer use the firewall endpoint, you can remove the endpoint association safely.
     * </p>
     *
     * @param deleteVpcEndpointAssociationRequest
     * @return Result of the DeleteVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DeleteVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DeleteVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcEndpointAssociationResponse deleteVpcEndpointAssociation(
            DeleteVpcEndpointAssociationRequest deleteVpcEndpointAssociationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidOperationException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVpcEndpointAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcEndpointAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpointAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointAssociationRequest, DeleteVpcEndpointAssociationResponse>()
                            .withOperationName("DeleteVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVpcEndpointAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpcEndpointAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall.
     * </p>
     *
     * @param describeFirewallRequest
     * @return Result of the DescribeFirewall operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewall"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFirewallResponse describeFirewall(DescribeFirewallRequest describeFirewallRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFirewallResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeFirewallResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewall");

            return clientHandler.execute(new ClientExecutionParams<DescribeFirewallRequest, DescribeFirewallResponse>()
                    .withOperationName("DescribeFirewall").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFirewallRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFirewallRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the high-level information about a firewall, including the Availability Zones where the Firewall is
     * currently in use.
     * </p>
     *
     * @param describeFirewallMetadataRequest
     * @return Result of the DescribeFirewallMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFirewallMetadataResponse describeFirewallMetadata(
            DescribeFirewallMetadataRequest describeFirewallMetadataRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFirewallMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFirewallMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewallMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFirewallMetadataRequest, DescribeFirewallMetadataResponse>()
                            .withOperationName("DescribeFirewallMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeFirewallMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFirewallMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified firewall policy.
     * </p>
     *
     * @param describeFirewallPolicyRequest
     * @return Result of the DescribeFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFirewallPolicyResponse describeFirewallPolicy(DescribeFirewallPolicyRequest describeFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFirewallPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFirewallPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFirewallPolicyRequest, DescribeFirewallPolicyResponse>()
                            .withOperationName("DescribeFirewallPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeFirewallPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFirewallPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns key information about a specific flow operation.
     * </p>
     *
     * @param describeFlowOperationRequest
     * @return Result of the DescribeFlowOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeFlowOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeFlowOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFlowOperationResponse describeFlowOperation(DescribeFlowOperationRequest describeFlowOperationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFlowOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFlowOperationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFlowOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFlowOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFlowOperation");

            return clientHandler.execute(new ClientExecutionParams<DescribeFlowOperationRequest, DescribeFlowOperationResponse>()
                    .withOperationName("DescribeFlowOperation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFlowOperationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFlowOperationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the logging configuration for the specified firewall.
     * </p>
     *
     * @param describeLoggingConfigurationRequest
     * @return Result of the DescribeLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLoggingConfigurationResponse describeLoggingConfiguration(
            DescribeLoggingConfigurationRequest describeLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLoggingConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoggingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLoggingConfigurationRequest, DescribeLoggingConfigurationResponse>()
                            .withOperationName("DescribeLoggingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeLoggingConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeLoggingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a resource policy that you created in a <a>PutResourcePolicy</a> request.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeResourcePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified rule group.
     * </p>
     *
     * @param describeRuleGroupRequest
     * @return Result of the DescribeRuleGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRuleGroupResponse describeRuleGroup(DescribeRuleGroupRequest describeRuleGroupRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeRuleGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeRuleGroupRequest, DescribeRuleGroupResponse>()
                    .withOperationName("DescribeRuleGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRuleGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * High-level information about a rule group, returned by operations like create and describe. You can use the
     * information provided in the metadata to retrieve and manage a rule group. You can retrieve all objects for a rule
     * group by calling <a>DescribeRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupMetadataRequest
     * @return Result of the DescribeRuleGroupMetadata operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRuleGroupMetadataResponse describeRuleGroupMetadata(
            DescribeRuleGroupMetadataRequest describeRuleGroupMetadataRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRuleGroupMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRuleGroupMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroupMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRuleGroupMetadataRequest, DescribeRuleGroupMetadataResponse>()
                            .withOperationName("DescribeRuleGroupMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeRuleGroupMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRuleGroupMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information for a stateful rule group.
     * </p>
     * <p>
     * For active threat defense Amazon Web Services managed rule groups, this operation provides insight into the
     * protections enabled by the rule group, based on Suricata rule metadata fields. Summaries are available for rule
     * groups you manage and for active threat defense Amazon Web Services managed rule groups.
     * </p>
     * <p>
     * To modify how threat information appears in summaries, use the <code>SummaryConfiguration</code> parameter in
     * <a>UpdateRuleGroup</a>.
     * </p>
     *
     * @param describeRuleGroupSummaryRequest
     * @return Result of the DescribeRuleGroupSummary operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeRuleGroupSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeRuleGroupSummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRuleGroupSummaryResponse describeRuleGroupSummary(
            DescribeRuleGroupSummaryRequest describeRuleGroupSummaryRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRuleGroupSummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRuleGroupSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRuleGroupSummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRuleGroupSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRuleGroupSummary");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRuleGroupSummaryRequest, DescribeRuleGroupSummaryResponse>()
                            .withOperationName("DescribeRuleGroupSummary").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeRuleGroupSummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRuleGroupSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the data objects for the specified TLS inspection configuration.
     * </p>
     *
     * @param describeTlsInspectionConfigurationRequest
     * @return Result of the DescribeTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTlsInspectionConfigurationResponse describeTLSInspectionConfiguration(
            DescribeTlsInspectionConfigurationRequest describeTlsInspectionConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTlsInspectionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTlsInspectionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTLSInspectionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTlsInspectionConfigurationRequest, DescribeTlsInspectionConfigurationResponse>()
                            .withOperationName("DescribeTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTlsInspectionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTlsInspectionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the data object for the specified VPC endpoint association.
     * </p>
     *
     * @param describeVpcEndpointAssociationRequest
     * @return Result of the DescribeVpcEndpointAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DescribeVpcEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DescribeVpcEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeVpcEndpointAssociationResponse describeVpcEndpointAssociation(
            DescribeVpcEndpointAssociationRequest describeVpcEndpointAssociationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeVpcEndpointAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeVpcEndpointAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcEndpointAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeVpcEndpointAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcEndpointAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeVpcEndpointAssociationRequest, DescribeVpcEndpointAssociationResponse>()
                            .withOperationName("DescribeVpcEndpointAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeVpcEndpointAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeVpcEndpointAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified Availability Zone associations from a transit gateway-attached firewall. This removes the
     * firewall endpoints from these Availability Zones and stops traffic filtering in those zones. Before removing an
     * Availability Zone, ensure you've updated your transit gateway route tables to redirect traffic appropriately.
     * </p>
     * <note>
     * <p>
     * If <code>AvailabilityZoneChangeProtection</code> is enabled, you must first disable it using
     * <a>UpdateAvailabilityZoneChangeProtection</a>.
     * </p>
     * </note>
     * <p>
     * To verify the status of your Availability Zone changes, use <a>DescribeFirewall</a>.
     * </p>
     *
     * @param disassociateAvailabilityZonesRequest
     * @return Result of the DisassociateAvailabilityZones operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateAvailabilityZones
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateAvailabilityZones"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateAvailabilityZonesResponse disassociateAvailabilityZones(
            DisassociateAvailabilityZonesRequest disassociateAvailabilityZonesRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateAvailabilityZonesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateAvailabilityZonesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateAvailabilityZonesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateAvailabilityZonesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAvailabilityZones");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateAvailabilityZonesRequest, DisassociateAvailabilityZonesResponse>()
                            .withOperationName("DisassociateAvailabilityZones").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateAvailabilityZonesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateAvailabilityZonesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified subnet associations from the firewall. This removes the firewall endpoints from the subnets
     * and removes any network filtering protections that the endpoints were providing.
     * </p>
     *
     * @param disassociateSubnetsRequest
     * @return Result of the DisassociateSubnets operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws InvalidOperationException
     *         The operation failed because it's not valid. For example, you might have tried to delete a rule group or
     *         firewall policy that's in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.DisassociateSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/DisassociateSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSubnetsResponse disassociateSubnets(DisassociateSubnetsRequest disassociateSubnetsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, InvalidOperationException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSubnetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSubnetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateSubnetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateSubnets");

            return clientHandler.execute(new ClientExecutionParams<DisassociateSubnetsRequest, DisassociateSubnetsResponse>()
                    .withOperationName("DisassociateSubnets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disassociateSubnetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateSubnetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The results of a <code>COMPLETED</code> analysis report generated with <a>StartAnalysisReport</a>.
     * </p>
     * <p>
     * For more information, see <a>AnalysisTypeReportResult</a>.
     * </p>
     *
     * @param getAnalysisReportResultsRequest
     * @return Result of the GetAnalysisReportResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.GetAnalysisReportResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/GetAnalysisReportResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAnalysisReportResultsResponse getAnalysisReportResults(
            GetAnalysisReportResultsRequest getAnalysisReportResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnalysisReportResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnalysisReportResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnalysisReportResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnalysisReportResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnalysisReportResults");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAnalysisReportResultsRequest, GetAnalysisReportResultsResponse>()
                            .withOperationName("GetAnalysisReportResults").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAnalysisReportResultsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAnalysisReportResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all traffic analysis reports generated within the last 30 days.
     * </p>
     *
     * @param listAnalysisReportsRequest
     * @return Result of the ListAnalysisReports operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnalysisReportsResponse listAnalysisReports(ListAnalysisReportsRequest listAnalysisReportsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnalysisReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnalysisReportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnalysisReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnalysisReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnalysisReports");

            return clientHandler.execute(new ClientExecutionParams<ListAnalysisReportsRequest, ListAnalysisReportsResponse>()
                    .withOperationName("ListAnalysisReports").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAnalysisReportsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnalysisReportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the firewall policies that you have defined. Depending on your setting for max results
     * and the number of firewall policies, a single call might not return the full list.
     * </p>
     *
     * @param listFirewallPoliciesRequest
     * @return Result of the ListFirewallPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewallPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewallPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFirewallPoliciesResponse listFirewallPolicies(ListFirewallPoliciesRequest listFirewallPoliciesRequest)
            throws InvalidRequestException, ThrottlingException, InternalServerErrorException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFirewallPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFirewallPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListFirewallPoliciesRequest, ListFirewallPoliciesResponse>()
                    .withOperationName("ListFirewallPolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFirewallPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFirewallPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the firewalls that you have defined. If you provide VPC identifiers in your request,
     * this returns only the firewalls for those VPCs.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of firewalls, a single call might not return the full
     * list.
     * </p>
     *
     * @param listFirewallsRequest
     * @return Result of the ListFirewalls operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFirewalls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFirewalls"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFirewallsResponse listFirewalls(ListFirewallsRequest listFirewallsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFirewallsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFirewallsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewalls");

            return clientHandler.execute(new ClientExecutionParams<ListFirewallsRequest, ListFirewallsResponse>()
                    .withOperationName("ListFirewalls").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFirewallsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFirewallsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the results of a specific flow operation.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationResultsRequest
     * @return Result of the ListFlowOperationResults operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFlowOperationResultsResponse listFlowOperationResults(
            ListFlowOperationResultsRequest listFlowOperationResultsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFlowOperationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFlowOperationResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowOperationResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowOperationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowOperationResults");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFlowOperationResultsRequest, ListFlowOperationResultsResponse>()
                            .withOperationName("ListFlowOperationResults").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listFlowOperationResultsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFlowOperationResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all flow operations ran in a specific firewall. You can optionally narrow the request scope by
     * specifying the operation type or Availability Zone associated with a firewall's flow operations.
     * </p>
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     *
     * @param listFlowOperationsRequest
     * @return Result of the ListFlowOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListFlowOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListFlowOperations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFlowOperationsResponse listFlowOperations(ListFlowOperationsRequest listFlowOperationsRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFlowOperationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFlowOperationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowOperationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowOperationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowOperations");

            return clientHandler.execute(new ClientExecutionParams<ListFlowOperationsRequest, ListFlowOperationsResponse>()
                    .withOperationName("ListFlowOperations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFlowOperationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFlowOperationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the rule groups that you have defined. Depending on your setting for max results and
     * the number of rule groups, a single call might not return the full list.
     * </p>
     *
     * @param listRuleGroupsRequest
     * @return Result of the ListRuleGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListRuleGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListRuleGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRuleGroupsResponse listRuleGroups(ListRuleGroupsRequest listRuleGroupsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRuleGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRuleGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRuleGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRuleGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuleGroups");

            return clientHandler.execute(new ClientExecutionParams<ListRuleGroupsRequest, ListRuleGroupsResponse>()
                    .withOperationName("ListRuleGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRuleGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRuleGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the TLS inspection configurations that you have defined. Depending on your setting for
     * max results and the number of TLS inspection configurations, a single call might not return the full list.
     * </p>
     *
     * @param listTlsInspectionConfigurationsRequest
     * @return Result of the ListTLSInspectionConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTLSInspectionConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTLSInspectionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTlsInspectionConfigurationsResponse listTLSInspectionConfigurations(
            ListTlsInspectionConfigurationsRequest listTlsInspectionConfigurationsRequest) throws InvalidRequestException,
            InternalServerErrorException, ThrottlingException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTlsInspectionConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTlsInspectionConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTlsInspectionConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTlsInspectionConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTLSInspectionConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTlsInspectionConfigurationsRequest, ListTlsInspectionConfigurationsResponse>()
                            .withOperationName("ListTLSInspectionConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTlsInspectionConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTlsInspectionConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the tags associated with the specified resource. Tags are key:value pairs that you can use to
     * categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, InternalServerErrorException, ResourceNotFoundException, InvalidRequestException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the VPC endpoint associations that you have defined. If you specify a fireawll, this
     * returns only the endpoint associations for that firewall.
     * </p>
     * <p>
     * Depending on your setting for max results and the number of associations, a single call might not return the full
     * list.
     * </p>
     *
     * @param listVpcEndpointAssociationsRequest
     * @return Result of the ListVpcEndpointAssociations operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.ListVpcEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/ListVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListVpcEndpointAssociationsResponse listVpcEndpointAssociations(
            ListVpcEndpointAssociationsRequest listVpcEndpointAssociationsRequest) throws InvalidRequestException,
            ThrottlingException, InternalServerErrorException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVpcEndpointAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVpcEndpointAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointAssociationsRequest, ListVpcEndpointAssociationsResponse>()
                            .withOperationName("ListVpcEndpointAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listVpcEndpointAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListVpcEndpointAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an IAM policy for your rule group, firewall policy, or firewall. Use this to share these
     * resources between accounts. This operation works in conjunction with the Amazon Web Services Resource Access
     * Manager (RAM) service to manage resource sharing for Network Firewall.
     * </p>
     * <p>
     * For information about using sharing with Network Firewall resources, see <a
     * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html">Sharing Network Firewall
     * resources</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Use this operation to create or update a resource policy for your Network Firewall rule group, firewall policy,
     * or firewall. In the resource policy, you specify the accounts that you want to share the Network Firewall
     * resource with and the operations that you want the accounts to be able to perform.
     * </p>
     * <p>
     * When you add an account in the resource policy, you then run the following Resource Access Manager (RAM)
     * operations to access and accept the shared resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_GetResourceShareInvitations.html">
     * GetResourceShareInvitations</a> - Returns the Amazon Resource Names (ARNs) of the resource share invitations.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_AcceptResourceShareInvitation.html">
     * AcceptResourceShareInvitation</a> - Accepts the share invitation for a specified resource share.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For additional information about resource sharing using RAM, see <a
     * href="https://docs.aws.amazon.com/ram/latest/userguide/what-is.html">Resource Access Manager User Guide</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidResourcePolicyException
     *         The policy statement failed validation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidResourcePolicyException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                    .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rejects a transit gateway attachment request for Network Firewall. When you reject the attachment request,
     * Network Firewall cancels the creation of routing components between the transit gateway and firewall endpoints.
     * </p>
     * <p>
     * Only the transit gateway owner can reject the attachment. After rejection, no traffic will flow through the
     * firewall endpoints for this attachment.
     * </p>
     * <p>
     * Use <a>DescribeFirewall</a> to monitor the rejection status. To accept the attachment instead of rejecting it,
     * use <a>AcceptNetworkFirewallTransitGatewayAttachment</a>.
     * </p>
     * <note>
     * <p>
     * Once rejected, you cannot reverse this action. To establish connectivity, you must create a new transit
     * gateway-attached firewall.
     * </p>
     * </note>
     *
     * @param rejectNetworkFirewallTransitGatewayAttachmentRequest
     * @return Result of the RejectNetworkFirewallTransitGatewayAttachment operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.RejectNetworkFirewallTransitGatewayAttachment
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/RejectNetworkFirewallTransitGatewayAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RejectNetworkFirewallTransitGatewayAttachmentResponse rejectNetworkFirewallTransitGatewayAttachment(
            RejectNetworkFirewallTransitGatewayAttachmentRequest rejectNetworkFirewallTransitGatewayAttachmentRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectNetworkFirewallTransitGatewayAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, RejectNetworkFirewallTransitGatewayAttachmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                rejectNetworkFirewallTransitGatewayAttachmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rejectNetworkFirewallTransitGatewayAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectNetworkFirewallTransitGatewayAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectNetworkFirewallTransitGatewayAttachmentRequest, RejectNetworkFirewallTransitGatewayAttachmentResponse>()
                            .withOperationName("RejectNetworkFirewallTransitGatewayAttachment")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(rejectNetworkFirewallTransitGatewayAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectNetworkFirewallTransitGatewayAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a traffic analysis report for the timeframe and traffic type you specify.
     * </p>
     * <p>
     * For information on the contents of a traffic analysis report, see <a>AnalysisReport</a>.
     * </p>
     *
     * @param startAnalysisReportRequest
     * @return Result of the StartAnalysisReport operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAnalysisReportResponse startAnalysisReport(StartAnalysisReportRequest startAnalysisReportRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAnalysisReportResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAnalysisReportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAnalysisReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAnalysisReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAnalysisReport");

            return clientHandler.execute(new ClientExecutionParams<StartAnalysisReportRequest, StartAnalysisReportResponse>()
                    .withOperationName("StartAnalysisReport").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startAnalysisReportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartAnalysisReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Begins capturing the flows in a firewall, according to the filters you define. Captures are similar, but not
     * identical to snapshots. Capture operations provide visibility into flows that are not closed and are tracked by a
     * firewall's flow table. Unlike snapshots, captures are a time-boxed view.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <note>
     * <p>
     * To avoid encountering operation limits, you should avoid starting captures with broad filters, like wide IP
     * ranges. Instead, we recommend you define more specific criteria with <code>FlowFilters</code>, like narrow IP
     * ranges, ports, or protocols.
     * </p>
     * </note>
     *
     * @param startFlowCaptureRequest
     * @return Result of the StartFlowCapture operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowCapture
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowCapture"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartFlowCaptureResponse startFlowCapture(StartFlowCaptureRequest startFlowCaptureRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartFlowCaptureResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartFlowCaptureResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowCaptureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowCaptureRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlowCapture");

            return clientHandler.execute(new ClientExecutionParams<StartFlowCaptureRequest, StartFlowCaptureResponse>()
                    .withOperationName("StartFlowCapture").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startFlowCaptureRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartFlowCaptureRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Begins the flushing of traffic from the firewall, according to the filters you define. When the operation starts,
     * impacted flows are temporarily marked as timed out before the Suricata engine prunes, or flushes, the flows from
     * the firewall table.
     * </p>
     * <important>
     * <p>
     * While the flush completes, impacted flows are processed as midstream traffic. This may result in a temporary
     * increase in midstream traffic metrics. We recommend that you double check your stream exception policy before you
     * perform a flush operation.
     * </p>
     * </important>
     *
     * @param startFlowFlushRequest
     * @return Result of the StartFlowFlush operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.StartFlowFlush
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/StartFlowFlush"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartFlowFlushResponse startFlowFlush(StartFlowFlushRequest startFlowFlushRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartFlowFlushResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartFlowFlushResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startFlowFlushRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startFlowFlushRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartFlowFlush");

            return clientHandler.execute(new ClientExecutionParams<StartFlowFlushRequest, StartFlowFlushResponse>()
                    .withOperationName("StartFlowFlush").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startFlowFlushRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartFlowFlushRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. Tags are key:value pairs that you can use to categorize and
     * manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the
     * value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource,
     * up to 50 tags for a resource.
     * </p>
     * <p>
     * You can tag the Amazon Web Services resources that you manage through Network Firewall: firewalls, firewall
     * policies, and rule groups.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the tags with the specified keys from the specified resource. Tags are key:value pairs that you can use
     * to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to
     * "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web
     * Services resource, up to 50 tags for a resource.
     * </p>
     * <p>
     * You can manage tags for the Amazon Web Services resources that you manage through Network Firewall: firewalls,
     * firewall policies, and rule groups.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            InternalServerErrorException, ResourceNotFoundException, InvalidRequestException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the <code>AvailabilityZoneChangeProtection</code> setting for a transit gateway-attached firewall. When
     * enabled, this setting prevents accidental changes to the firewall's Availability Zone configuration. This helps
     * protect against disrupting traffic flow in production environments.
     * </p>
     * <p>
     * When enabled, you must disable this protection before using <a>AssociateAvailabilityZones</a> or
     * <a>DisassociateAvailabilityZones</a> to modify the firewall's Availability Zone configuration.
     * </p>
     *
     * @param updateAvailabilityZoneChangeProtectionRequest
     * @return Result of the UpdateAvailabilityZoneChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateAvailabilityZoneChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateAvailabilityZoneChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAvailabilityZoneChangeProtectionResponse updateAvailabilityZoneChangeProtection(
            UpdateAvailabilityZoneChangeProtectionRequest updateAvailabilityZoneChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAvailabilityZoneChangeProtectionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateAvailabilityZoneChangeProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAvailabilityZoneChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAvailabilityZoneChangeProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAvailabilityZoneChangeProtection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAvailabilityZoneChangeProtectionRequest, UpdateAvailabilityZoneChangeProtectionResponse>()
                            .withOperationName("UpdateAvailabilityZoneChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(updateAvailabilityZoneChangeProtectionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAvailabilityZoneChangeProtectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables specific types of firewall analysis on a specific firewall you define.
     * </p>
     *
     * @param updateFirewallAnalysisSettingsRequest
     * @return Result of the UpdateFirewallAnalysisSettings operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallAnalysisSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallAnalysisSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallAnalysisSettingsResponse updateFirewallAnalysisSettings(
            UpdateFirewallAnalysisSettingsRequest updateFirewallAnalysisSettingsRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallAnalysisSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallAnalysisSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallAnalysisSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallAnalysisSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallAnalysisSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallAnalysisSettingsRequest, UpdateFirewallAnalysisSettingsResponse>()
                            .withOperationName("UpdateFirewallAnalysisSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFirewallAnalysisSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFirewallAnalysisSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the flag, <code>DeleteProtection</code>, which indicates whether it is possible to delete the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected against deletion. This setting helps protect
     * against accidentally deleting a firewall that's in use.
     * </p>
     *
     * @param updateFirewallDeleteProtectionRequest
     * @return Result of the UpdateFirewallDeleteProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDeleteProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallDeleteProtectionResponse updateFirewallDeleteProtection(
            UpdateFirewallDeleteProtectionRequest updateFirewallDeleteProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallDeleteProtectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallDeleteProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDeleteProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallDeleteProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDeleteProtection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallDeleteProtectionRequest, UpdateFirewallDeleteProtectionResponse>()
                            .withOperationName("UpdateFirewallDeleteProtection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFirewallDeleteProtectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFirewallDeleteProtectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the description for the specified firewall. Use the description to help you identify the firewall when
     * you're working with it.
     * </p>
     *
     * @param updateFirewallDescriptionRequest
     * @return Result of the UpdateFirewallDescription operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallDescription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallDescription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallDescriptionResponse updateFirewallDescription(
            UpdateFirewallDescriptionRequest updateFirewallDescriptionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallDescriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallDescriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDescriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallDescriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDescription");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallDescriptionRequest, UpdateFirewallDescriptionResponse>()
                            .withOperationName("UpdateFirewallDescription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFirewallDescriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFirewallDescriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A complex type that contains settings for encryption of your firewall resources.
     * </p>
     *
     * @param updateFirewallEncryptionConfigurationRequest
     * @return Result of the UpdateFirewallEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallEncryptionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallEncryptionConfigurationResponse updateFirewallEncryptionConfiguration(
            UpdateFirewallEncryptionConfigurationRequest updateFirewallEncryptionConfigurationRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallEncryptionConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateFirewallEncryptionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallEncryptionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallEncryptionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallEncryptionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallEncryptionConfigurationRequest, UpdateFirewallEncryptionConfigurationResponse>()
                            .withOperationName("UpdateFirewallEncryptionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(updateFirewallEncryptionConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFirewallEncryptionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the properties of the specified firewall policy.
     * </p>
     *
     * @param updateFirewallPolicyRequest
     * @return Result of the UpdateFirewallPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallPolicyResponse updateFirewallPolicy(UpdateFirewallPolicyRequest updateFirewallPolicyRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallPolicy");

            return clientHandler.execute(new ClientExecutionParams<UpdateFirewallPolicyRequest, UpdateFirewallPolicyResponse>()
                    .withOperationName("UpdateFirewallPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFirewallPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFirewallPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the flag, <code>ChangeProtection</code>, which indicates whether it is possible to change the firewall.
     * If the flag is set to <code>TRUE</code>, the firewall is protected from changes. This setting helps protect
     * against accidentally changing a firewall that's in use.
     * </p>
     *
     * @param updateFirewallPolicyChangeProtectionRequest
     * @return Result of the UpdateFirewallPolicyChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateFirewallPolicyChangeProtection
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateFirewallPolicyChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallPolicyChangeProtectionResponse updateFirewallPolicyChangeProtection(
            UpdateFirewallPolicyChangeProtectionRequest updateFirewallPolicyChangeProtectionRequest)
            throws InvalidRequestException, InternalServerErrorException, ResourceNotFoundException, ThrottlingException,
            InvalidTokenException, ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallPolicyChangeProtectionResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateFirewallPolicyChangeProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallPolicyChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFirewallPolicyChangeProtectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallPolicyChangeProtection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFirewallPolicyChangeProtectionRequest, UpdateFirewallPolicyChangeProtectionResponse>()
                            .withOperationName("UpdateFirewallPolicyChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFirewallPolicyChangeProtectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFirewallPolicyChangeProtectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the logging configuration for the specified firewall.
     * </p>
     * <p>
     * To change the logging configuration, retrieve the <a>LoggingConfiguration</a> by calling
     * <a>DescribeLoggingConfiguration</a>, then change it and provide the modified object to this update call. You must
     * change the logging configuration one <a>LogDestinationConfig</a> at a time inside the retrieved
     * <a>LoggingConfiguration</a> object.
     * </p>
     * <p>
     * You can perform only one of the following actions in any call to <code>UpdateLoggingConfiguration</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new log destination object by adding a single <code>LogDestinationConfig</code> array element to
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete a log destination object by removing a single <code>LogDestinationConfig</code> array element from
     * <code>LogDestinationConfigs</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change the <code>LogDestination</code> setting in a single <code>LogDestinationConfig</code> array element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change the <code>LogDestinationType</code> or <code>LogType</code> in a
     * <code>LogDestinationConfig</code>. To change these settings, delete the existing
     * <code>LogDestinationConfig</code> object and create a new one, using two separate calls to this update operation.
     * </p>
     *
     * @param updateLoggingConfigurationRequest
     * @return Result of the UpdateLoggingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws LogDestinationPermissionException
     *         Unable to send logs to a configured logging destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateLoggingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLoggingConfigurationResponse updateLoggingConfiguration(
            UpdateLoggingConfigurationRequest updateLoggingConfigurationRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            LogDestinationPermissionException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLoggingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLoggingConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLoggingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoggingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoggingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLoggingConfigurationRequest, UpdateLoggingConfigurationResponse>()
                            .withOperationName("UpdateLoggingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateLoggingConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLoggingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the rule settings for the specified rule group. You use a rule group by reference in one or more firewall
     * policies. When you modify a rule group, you modify all firewall policies that use the rule group.
     * </p>
     * <p>
     * To update a rule group, first call <a>DescribeRuleGroup</a> to retrieve the current <a>RuleGroup</a> object,
     * update the object as needed, and then provide the updated object to this call.
     * </p>
     *
     * @param updateRuleGroupRequest
     * @return Result of the UpdateRuleGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateRuleGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateRuleGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRuleGroupResponse updateRuleGroup(UpdateRuleGroupRequest updateRuleGroupRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalServerErrorException,
            InvalidTokenException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRuleGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRuleGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRuleGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRuleGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRuleGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateRuleGroupRequest, UpdateRuleGroupResponse>()
                    .withOperationName("UpdateRuleGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRuleGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRuleGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p/>
     *
     * @param updateSubnetChangeProtectionRequest
     * @return Result of the UpdateSubnetChangeProtection operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws ResourceOwnerCheckException
     *         Unable to change the resource because your account doesn't own it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateSubnetChangeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateSubnetChangeProtection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSubnetChangeProtectionResponse updateSubnetChangeProtection(
            UpdateSubnetChangeProtectionRequest updateSubnetChangeProtectionRequest) throws InvalidRequestException,
            InternalServerErrorException, ResourceNotFoundException, ThrottlingException, InvalidTokenException,
            ResourceOwnerCheckException, AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSubnetChangeProtectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSubnetChangeProtectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSubnetChangeProtectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSubnetChangeProtectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSubnetChangeProtection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSubnetChangeProtectionRequest, UpdateSubnetChangeProtectionResponse>()
                            .withOperationName("UpdateSubnetChangeProtection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateSubnetChangeProtectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSubnetChangeProtectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS
     * inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection
     * configuration, you modify all firewall policies that use the TLS inspection configuration.
     * </p>
     * <p>
     * To update a TLS inspection configuration, first call <a>DescribeTLSInspectionConfiguration</a> to retrieve the
     * current <a>TLSInspectionConfiguration</a> object, update the object as needed, and then provide the updated
     * object to this call.
     * </p>
     *
     * @param updateTlsInspectionConfigurationRequest
     * @return Result of the UpdateTLSInspectionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The operation failed because of a problem with your request. Examples include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You specified an unsupported parameter name or value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You tried to update a property with a value that isn't among the available types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Your request references an ARN that is malformed, or corresponds to a resource that isn't valid in the
     *         context of the request.
     *         </p>
     *         </li>
     * @throws ResourceNotFoundException
     *         Unable to locate a resource using the parameters that you provided.
     * @throws ThrottlingException
     *         Unable to process the request due to throttling limitations.
     * @throws InternalServerErrorException
     *         Your request is valid, but Network Firewall couldn't perform the operation because of a system problem.
     *         Retry your request.
     * @throws InvalidTokenException
     *         The token you provided is stale or isn't valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NetworkFirewallException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NetworkFirewallClient.UpdateTLSInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/UpdateTLSInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTlsInspectionConfigurationResponse updateTLSInspectionConfiguration(
            UpdateTlsInspectionConfigurationRequest updateTlsInspectionConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerErrorException, InvalidTokenException,
            AwsServiceException, SdkClientException, NetworkFirewallException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTlsInspectionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateTlsInspectionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "LogDestinationPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LogDestinationPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LogDestinationPermissionException::builder).build());
            case "InsufficientCapacityException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientCapacityException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InsufficientCapacityException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ResourceOwnerCheckException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceOwnerCheckException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceOwnerCheckException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InvalidResourcePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourcePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourcePolicyException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTlsInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateTlsInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Network Firewall");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTLSInspectionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTlsInspectionConfigurationRequest, UpdateTlsInspectionConfigurationResponse>()
                            .withOperationName("UpdateTLSInspectionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateTlsInspectionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTlsInspectionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        NetworkFirewallServiceClientConfigurationBuilder serviceConfigBuilder = new NetworkFirewallServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NetworkFirewallException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    @Override
    public final NetworkFirewallServiceClientConfiguration serviceClientConfiguration() {
        return new NetworkFirewallServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
