/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results of a <code>COMPLETED</code> analysis report generated with <a>StartAnalysisReport</a>.
 * </p>
 * <p>
 * For an example of traffic analysis report results, see the response syntax of <a>GetAnalysisReportResults</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisTypeReportResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisTypeReportResult.Builder, AnalysisTypeReportResult> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AnalysisTypeReportResult::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Instant> FIRST_ACCESSED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FirstAccessed").getter(getter(AnalysisTypeReportResult::firstAccessed))
            .setter(setter(Builder::firstAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstAccessed").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessed").getter(getter(AnalysisTypeReportResult::lastAccessed))
            .setter(setter(Builder::lastAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessed").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(AnalysisTypeReportResult::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<Hits> HITS_FIELD = SdkField.<Hits> builder(MarshallingType.SDK_POJO).memberName("Hits")
            .getter(getter(AnalysisTypeReportResult::hits)).setter(setter(Builder::hits)).constructor(Hits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hits").build()).build();

    private static final SdkField<UniqueSources> UNIQUE_SOURCES_FIELD = SdkField
            .<UniqueSources> builder(MarshallingType.SDK_POJO).memberName("UniqueSources")
            .getter(getter(AnalysisTypeReportResult::uniqueSources)).setter(setter(Builder::uniqueSources))
            .constructor(UniqueSources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            FIRST_ACCESSED_FIELD, LAST_ACCESSED_FIELD, DOMAIN_FIELD, HITS_FIELD, UNIQUE_SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final Instant firstAccessed;

    private final Instant lastAccessed;

    private final String domain;

    private final Hits hits;

    private final UniqueSources uniqueSources;

    private AnalysisTypeReportResult(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.firstAccessed = builder.firstAccessed;
        this.lastAccessed = builder.lastAccessed;
        this.domain = builder.domain;
        this.hits = builder.hits;
        this.uniqueSources = builder.uniqueSources;
    }

    /**
     * <p>
     * The type of traffic captured by the analysis report.
     * </p>
     * 
     * @return The type of traffic captured by the analysis report.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The date and time any domain was first accessed (within the last 30 day period).
     * </p>
     * 
     * @return The date and time any domain was first accessed (within the last 30 day period).
     */
    public final Instant firstAccessed() {
        return firstAccessed;
    }

    /**
     * <p>
     * The date and time any domain was last accessed (within the last 30 day period).
     * </p>
     * 
     * @return The date and time any domain was last accessed (within the last 30 day period).
     */
    public final Instant lastAccessed() {
        return lastAccessed;
    }

    /**
     * <p>
     * The most frequently accessed domains.
     * </p>
     * 
     * @return The most frequently accessed domains.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The number of attempts made to access a observed domain.
     * </p>
     * 
     * @return The number of attempts made to access a observed domain.
     */
    public final Hits hits() {
        return hits;
    }

    /**
     * <p>
     * The number of unique source IP addresses that connected to a domain.
     * </p>
     * 
     * @return The number of unique source IP addresses that connected to a domain.
     */
    public final UniqueSources uniqueSources() {
        return uniqueSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(firstAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(hits());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTypeReportResult)) {
            return false;
        }
        AnalysisTypeReportResult other = (AnalysisTypeReportResult) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(firstAccessed(), other.firstAccessed())
                && Objects.equals(lastAccessed(), other.lastAccessed()) && Objects.equals(domain(), other.domain())
                && Objects.equals(hits(), other.hits()) && Objects.equals(uniqueSources(), other.uniqueSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisTypeReportResult").add("Protocol", protocol()).add("FirstAccessed", firstAccessed())
                .add("LastAccessed", lastAccessed()).add("Domain", domain()).add("Hits", hits())
                .add("UniqueSources", uniqueSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "FirstAccessed":
            return Optional.ofNullable(clazz.cast(firstAccessed()));
        case "LastAccessed":
            return Optional.ofNullable(clazz.cast(lastAccessed()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Hits":
            return Optional.ofNullable(clazz.cast(hits()));
        case "UniqueSources":
            return Optional.ofNullable(clazz.cast(uniqueSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("FirstAccessed", FIRST_ACCESSED_FIELD);
        map.put("LastAccessed", LAST_ACCESSED_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("Hits", HITS_FIELD);
        map.put("UniqueSources", UNIQUE_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTypeReportResult, T> g) {
        return obj -> g.apply((AnalysisTypeReportResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisTypeReportResult> {
        /**
         * <p>
         * The type of traffic captured by the analysis report.
         * </p>
         * 
         * @param protocol
         *        The type of traffic captured by the analysis report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The date and time any domain was first accessed (within the last 30 day period).
         * </p>
         * 
         * @param firstAccessed
         *        The date and time any domain was first accessed (within the last 30 day period).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstAccessed(Instant firstAccessed);

        /**
         * <p>
         * The date and time any domain was last accessed (within the last 30 day period).
         * </p>
         * 
         * @param lastAccessed
         *        The date and time any domain was last accessed (within the last 30 day period).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessed(Instant lastAccessed);

        /**
         * <p>
         * The most frequently accessed domains.
         * </p>
         * 
         * @param domain
         *        The most frequently accessed domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The number of attempts made to access a observed domain.
         * </p>
         * 
         * @param hits
         *        The number of attempts made to access a observed domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hits(Hits hits);

        /**
         * <p>
         * The number of attempts made to access a observed domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link Hits.Builder} avoiding the need to create
         * one manually via {@link Hits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hits.Builder#build()} is called immediately and its result is
         * passed to {@link #hits(Hits)}.
         * 
         * @param hits
         *        a consumer that will call methods on {@link Hits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hits(Hits)
         */
        default Builder hits(Consumer<Hits.Builder> hits) {
            return hits(Hits.builder().applyMutation(hits).build());
        }

        /**
         * <p>
         * The number of unique source IP addresses that connected to a domain.
         * </p>
         * 
         * @param uniqueSources
         *        The number of unique source IP addresses that connected to a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueSources(UniqueSources uniqueSources);

        /**
         * <p>
         * The number of unique source IP addresses that connected to a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link UniqueSources.Builder} avoiding the need
         * to create one manually via {@link UniqueSources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UniqueSources.Builder#build()} is called immediately and its
         * result is passed to {@link #uniqueSources(UniqueSources)}.
         * 
         * @param uniqueSources
         *        a consumer that will call methods on {@link UniqueSources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uniqueSources(UniqueSources)
         */
        default Builder uniqueSources(Consumer<UniqueSources.Builder> uniqueSources) {
            return uniqueSources(UniqueSources.builder().applyMutation(uniqueSources).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private Instant firstAccessed;

        private Instant lastAccessed;

        private String domain;

        private Hits hits;

        private UniqueSources uniqueSources;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTypeReportResult model) {
            protocol(model.protocol);
            firstAccessed(model.firstAccessed);
            lastAccessed(model.lastAccessed);
            domain(model.domain);
            hits(model.hits);
            uniqueSources(model.uniqueSources);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Instant getFirstAccessed() {
            return firstAccessed;
        }

        public final void setFirstAccessed(Instant firstAccessed) {
            this.firstAccessed = firstAccessed;
        }

        @Override
        public final Builder firstAccessed(Instant firstAccessed) {
            this.firstAccessed = firstAccessed;
            return this;
        }

        public final Instant getLastAccessed() {
            return lastAccessed;
        }

        public final void setLastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public final Builder lastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Hits.Builder getHits() {
            return hits != null ? hits.toBuilder() : null;
        }

        public final void setHits(Hits.BuilderImpl hits) {
            this.hits = hits != null ? hits.build() : null;
        }

        @Override
        public final Builder hits(Hits hits) {
            this.hits = hits;
            return this;
        }

        public final UniqueSources.Builder getUniqueSources() {
            return uniqueSources != null ? uniqueSources.toBuilder() : null;
        }

        public final void setUniqueSources(UniqueSources.BuilderImpl uniqueSources) {
            this.uniqueSources = uniqueSources != null ? uniqueSources.build() : null;
        }

        @Override
        public final Builder uniqueSources(UniqueSources uniqueSources) {
            this.uniqueSources = uniqueSources;
            return this;
        }

        @Override
        public AnalysisTypeReportResult build() {
            return new AnalysisTypeReportResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
