/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFirewallRequest extends NetworkFirewallRequest implements
        ToCopyableBuilder<DeleteFirewallRequest.Builder, DeleteFirewallRequest> {
    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(DeleteFirewallRequest::firewallName)).setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(DeleteFirewallRequest::firewallArn)).setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_NAME_FIELD,
            FIREWALL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallName;

    private final String firewallArn;

    private DeleteFirewallRequest(BuilderImpl builder) {
        super(builder);
        this.firewallName = builder.firewallName;
        this.firewallArn = builder.firewallArn;
    }

    /**
     * <p>
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * <p>
     * You must specify the ARN or the name, and you can specify both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.</p>
     *         <p>
     *         You must specify the ARN or the name, and you can specify both.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFirewallRequest)) {
            return false;
        }
        DeleteFirewallRequest other = (DeleteFirewallRequest) obj;
        return Objects.equals(firewallName(), other.firewallName()) && Objects.equals(firewallArn(), other.firewallArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFirewallRequest").add("FirewallName", firewallName()).add("FirewallArn", firewallArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallName", FIREWALL_NAME_FIELD);
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFirewallRequest, T> g) {
        return obj -> g.apply((DeleteFirewallRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFirewallRequest> {
        /**
         * <p>
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallName
         *        The descriptive name of the firewall. You can't change the name of a firewall after you create it.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * <p>
         * You must specify the ARN or the name, and you can specify both.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.</p>
         *        <p>
         *        You must specify the ARN or the name, and you can specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkFirewallRequest.BuilderImpl implements Builder {
        private String firewallName;

        private String firewallArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFirewallRequest model) {
            super(model);
            firewallName(model.firewallName);
            firewallArn(model.firewallArn);
        }

        public final String getFirewallName() {
            return firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFirewallRequest build() {
            return new DeleteFirewallRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
