/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRuleGroupResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<DescribeRuleGroupResponse.Builder, DescribeRuleGroupResponse> {
    private static final SdkField<String> UPDATE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateToken").getter(getter(DescribeRuleGroupResponse::updateToken))
            .setter(setter(Builder::updateToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateToken").build()).build();

    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.<RuleGroup> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroup").getter(getter(DescribeRuleGroupResponse::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<RuleGroupResponse> RULE_GROUP_RESPONSE_FIELD = SdkField
            .<RuleGroupResponse> builder(MarshallingType.SDK_POJO).memberName("RuleGroupResponse")
            .getter(getter(DescribeRuleGroupResponse::ruleGroupResponse)).setter(setter(Builder::ruleGroupResponse))
            .constructor(RuleGroupResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_TOKEN_FIELD,
            RULE_GROUP_FIELD, RULE_GROUP_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String updateToken;

    private final RuleGroup ruleGroup;

    private final RuleGroupResponse ruleGroupResponse;

    private DescribeRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.updateToken = builder.updateToken;
        this.ruleGroup = builder.ruleGroup;
        this.ruleGroupResponse = builder.ruleGroupResponse;
    }

    /**
     * <p>
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule
     * group. The token marks the state of the rule group resource at the time of the request.
     * </p>
     * <p>
     * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to
     * ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails
     * with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current copy
     * of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     * </p>
     * 
     * @return A token used for optimistic locking. Network Firewall returns a token to your requests that access the
     *         rule group. The token marks the state of the rule group resource at the time of the request. </p>
     *         <p>
     *         To make changes to the rule group, you provide the token in your request. Network Firewall uses the token
     *         to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the
     *         operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group
     *         again to get a current copy of it with a current token. Reapply your changes as needed, then try the
     *         operation again using the new token.
     */
    public final String updateToken() {
        return updateToken;
    }

    /**
     * <p>
     * The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule
     * group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * <p>
     * Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups to
     * inspect individual packets and you define stateful rule groups to inspect packets in the context of their traffic
     * flow.
     * </p>
     * <p>
     * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the policy
     * in a firewall. You can reference a rule group from more than one firewall policy, and you can use a firewall
     * policy in more than one firewall.
     * </p>
     * 
     * @return The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the
     *         rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>. </p>
     *         <p>
     *         Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule
     *         groups to inspect individual packets and you define stateful rule groups to inspect packets in the
     *         context of their traffic flow.
     *         </p>
     *         <p>
     *         To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the
     *         policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use
     *         a firewall policy in more than one firewall.
     */
    public final RuleGroup ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You can
     * retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
     * </p>
     * 
     * @return The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group.
     *         You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
     */
    public final RuleGroupResponse ruleGroupResponse() {
        return ruleGroupResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateToken());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuleGroupResponse)) {
            return false;
        }
        DescribeRuleGroupResponse other = (DescribeRuleGroupResponse) obj;
        return Objects.equals(updateToken(), other.updateToken()) && Objects.equals(ruleGroup(), other.ruleGroup())
                && Objects.equals(ruleGroupResponse(), other.ruleGroupResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRuleGroupResponse").add("UpdateToken", updateToken()).add("RuleGroup", ruleGroup())
                .add("RuleGroupResponse", ruleGroupResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateToken":
            return Optional.ofNullable(clazz.cast(updateToken()));
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "RuleGroupResponse":
            return Optional.ofNullable(clazz.cast(ruleGroupResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdateToken", UPDATE_TOKEN_FIELD);
        map.put("RuleGroup", RULE_GROUP_FIELD);
        map.put("RuleGroupResponse", RULE_GROUP_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuleGroupResponse, T> g) {
        return obj -> g.apply((DescribeRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRuleGroupResponse> {
        /**
         * <p>
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule
         * group. The token marks the state of the rule group resource at the time of the request.
         * </p>
         * <p>
         * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to
         * ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails
         * with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group again to get a current
         * copy of it with a current token. Reapply your changes as needed, then try the operation again using the new
         * token.
         * </p>
         * 
         * @param updateToken
         *        A token used for optimistic locking. Network Firewall returns a token to your requests that access the
         *        rule group. The token marks the state of the rule group resource at the time of the request. </p>
         *        <p>
         *        To make changes to the rule group, you provide the token in your request. Network Firewall uses the
         *        token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the
         *        operation fails with an <code>InvalidTokenException</code>. If this happens, retrieve the rule group
         *        again to get a current copy of it with a current token. Reapply your changes as needed, then try the
         *        operation again using the new token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToken(String updateToken);

        /**
         * <p>
         * The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule
         * group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * <p>
         * Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups
         * to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
         * traffic flow.
         * </p>
         * <p>
         * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the
         * policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a
         * firewall policy in more than one firewall.
         * </p>
         * 
         * @param ruleGroup
         *        The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define
         *        the rule group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         *        </p>
         *        <p>
         *        Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule
         *        groups to inspect individual packets and you define stateful rule groups to inspect packets in the
         *        context of their traffic flow.
         *        </p>
         *        <p>
         *        To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use
         *        the policy in a firewall. You can reference a rule group from more than one firewall policy, and you
         *        can use a firewall policy in more than one firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroup ruleGroup);

        /**
         * <p>
         * The object that defines the rules in a rule group. This, along with <a>RuleGroupResponse</a>, define the rule
         * group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * <p>
         * Network Firewall uses a rule group to inspect and control network traffic. You define stateless rule groups
         * to inspect individual packets and you define stateful rule groups to inspect packets in the context of their
         * traffic flow.
         * </p>
         * <p>
         * To use a rule group, you include it by reference in an Network Firewall firewall policy, then you use the
         * policy in a firewall. You can reference a rule group from more than one firewall policy, and you can use a
         * firewall policy in more than one firewall.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroup.Builder} avoiding the need to
         * create one manually via {@link RuleGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleGroup(RuleGroup)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroup)
         */
        default Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return ruleGroup(RuleGroup.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You
         * can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * 
         * @param ruleGroupResponse
         *        The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule
         *        group. You can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupResponse(RuleGroupResponse ruleGroupResponse);

        /**
         * <p>
         * The high-level properties of a rule group. This, along with the <a>RuleGroup</a>, define the rule group. You
         * can retrieve all objects for a rule group by calling <a>DescribeRuleGroup</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupResponse.Builder} avoiding the
         * need to create one manually via {@link RuleGroupResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleGroupResponse(RuleGroupResponse)}.
         * 
         * @param ruleGroupResponse
         *        a consumer that will call methods on {@link RuleGroupResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupResponse(RuleGroupResponse)
         */
        default Builder ruleGroupResponse(Consumer<RuleGroupResponse.Builder> ruleGroupResponse) {
            return ruleGroupResponse(RuleGroupResponse.builder().applyMutation(ruleGroupResponse).build());
        }
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String updateToken;

        private RuleGroup ruleGroup;

        private RuleGroupResponse ruleGroupResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuleGroupResponse model) {
            super(model);
            updateToken(model.updateToken);
            ruleGroup(model.ruleGroup);
            ruleGroupResponse(model.ruleGroupResponse);
        }

        public final String getUpdateToken() {
            return updateToken;
        }

        public final void setUpdateToken(String updateToken) {
            this.updateToken = updateToken;
        }

        @Override
        public final Builder updateToken(String updateToken) {
            this.updateToken = updateToken;
            return this;
        }

        public final RuleGroup.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        @Override
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final RuleGroupResponse.Builder getRuleGroupResponse() {
            return ruleGroupResponse != null ? ruleGroupResponse.toBuilder() : null;
        }

        public final void setRuleGroupResponse(RuleGroupResponse.BuilderImpl ruleGroupResponse) {
            this.ruleGroupResponse = ruleGroupResponse != null ? ruleGroupResponse.build() : null;
        }

        @Override
        public final Builder ruleGroupResponse(RuleGroupResponse ruleGroupResponse) {
            this.ruleGroupResponse = ruleGroupResponse;
            return this;
        }

        @Override
        public DescribeRuleGroupResponse build() {
            return new DescribeRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
