/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the amount of time that can pass without any traffic sent through the firewall before the firewall
 * determines that the connection is idle and Network Firewall removes the flow entry from its flow table. Existing
 * connections and flows are not impacted when you update this value. Only new connections after you update this value
 * are impacted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTimeouts implements SdkPojo, Serializable, ToCopyableBuilder<FlowTimeouts.Builder, FlowTimeouts> {
    private static final SdkField<Integer> TCP_IDLE_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TcpIdleTimeoutSeconds").getter(getter(FlowTimeouts::tcpIdleTimeoutSeconds))
            .setter(setter(Builder::tcpIdleTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TcpIdleTimeoutSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TCP_IDLE_TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer tcpIdleTimeoutSeconds;

    private FlowTimeouts(BuilderImpl builder) {
        this.tcpIdleTimeoutSeconds = builder.tcpIdleTimeoutSeconds;
    }

    /**
     * <p>
     * The number of seconds that can pass without any TCP traffic sent through the firewall before the firewall
     * determines that the connection is idle. After the idle timeout passes, data packets are dropped, however, the
     * next TCP SYN packet is considered a new flow and is processed by the firewall. Clients or targets can use TCP
     * keepalive packets to reset the idle timeout.
     * </p>
     * <p>
     * You can define the <code>TcpIdleTimeoutSeconds</code> value to be between 60 and 6000 seconds. If no value is
     * provided, it defaults to 350 seconds.
     * </p>
     * 
     * @return The number of seconds that can pass without any TCP traffic sent through the firewall before the firewall
     *         determines that the connection is idle. After the idle timeout passes, data packets are dropped, however,
     *         the next TCP SYN packet is considered a new flow and is processed by the firewall. Clients or targets can
     *         use TCP keepalive packets to reset the idle timeout. </p>
     *         <p>
     *         You can define the <code>TcpIdleTimeoutSeconds</code> value to be between 60 and 6000 seconds. If no
     *         value is provided, it defaults to 350 seconds.
     */
    public final Integer tcpIdleTimeoutSeconds() {
        return tcpIdleTimeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tcpIdleTimeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTimeouts)) {
            return false;
        }
        FlowTimeouts other = (FlowTimeouts) obj;
        return Objects.equals(tcpIdleTimeoutSeconds(), other.tcpIdleTimeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTimeouts").add("TcpIdleTimeoutSeconds", tcpIdleTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TcpIdleTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(tcpIdleTimeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TcpIdleTimeoutSeconds", TCP_IDLE_TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTimeouts, T> g) {
        return obj -> g.apply((FlowTimeouts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTimeouts> {
        /**
         * <p>
         * The number of seconds that can pass without any TCP traffic sent through the firewall before the firewall
         * determines that the connection is idle. After the idle timeout passes, data packets are dropped, however, the
         * next TCP SYN packet is considered a new flow and is processed by the firewall. Clients or targets can use TCP
         * keepalive packets to reset the idle timeout.
         * </p>
         * <p>
         * You can define the <code>TcpIdleTimeoutSeconds</code> value to be between 60 and 6000 seconds. If no value is
         * provided, it defaults to 350 seconds.
         * </p>
         * 
         * @param tcpIdleTimeoutSeconds
         *        The number of seconds that can pass without any TCP traffic sent through the firewall before the
         *        firewall determines that the connection is idle. After the idle timeout passes, data packets are
         *        dropped, however, the next TCP SYN packet is considered a new flow and is processed by the firewall.
         *        Clients or targets can use TCP keepalive packets to reset the idle timeout. </p>
         *        <p>
         *        You can define the <code>TcpIdleTimeoutSeconds</code> value to be between 60 and 6000 seconds. If no
         *        value is provided, it defaults to 350 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpIdleTimeoutSeconds(Integer tcpIdleTimeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer tcpIdleTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTimeouts model) {
            tcpIdleTimeoutSeconds(model.tcpIdleTimeoutSeconds);
        }

        public final Integer getTcpIdleTimeoutSeconds() {
            return tcpIdleTimeoutSeconds;
        }

        public final void setTcpIdleTimeoutSeconds(Integer tcpIdleTimeoutSeconds) {
            this.tcpIdleTimeoutSeconds = tcpIdleTimeoutSeconds;
        }

        @Override
        public final Builder tcpIdleTimeoutSeconds(Integer tcpIdleTimeoutSeconds) {
            this.tcpIdleTimeoutSeconds = tcpIdleTimeoutSeconds;
            return this;
        }

        @Override
        public FlowTimeouts build() {
            return new FlowTimeouts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
