/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * General information about the IP set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPSetMetadata implements SdkPojo, Serializable, ToCopyableBuilder<IPSetMetadata.Builder, IPSetMetadata> {
    private static final SdkField<Integer> RESOLVED_CIDR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResolvedCIDRCount").getter(getter(IPSetMetadata::resolvedCIDRCount))
            .setter(setter(Builder::resolvedCIDRCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedCIDRCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVED_CIDR_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer resolvedCIDRCount;

    private IPSetMetadata(BuilderImpl builder) {
        this.resolvedCIDRCount = builder.resolvedCIDRCount;
    }

    /**
     * <p>
     * Describes the total number of CIDR blocks currently in use by the IP set references in a firewall. To determine
     * how many CIDR blocks are available for you to use in a firewall, you can call <code>AvailableCIDRCount</code>.
     * </p>
     * 
     * @return Describes the total number of CIDR blocks currently in use by the IP set references in a firewall. To
     *         determine how many CIDR blocks are available for you to use in a firewall, you can call
     *         <code>AvailableCIDRCount</code>.
     */
    public final Integer resolvedCIDRCount() {
        return resolvedCIDRCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resolvedCIDRCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetMetadata)) {
            return false;
        }
        IPSetMetadata other = (IPSetMetadata) obj;
        return Objects.equals(resolvedCIDRCount(), other.resolvedCIDRCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IPSetMetadata").add("ResolvedCIDRCount", resolvedCIDRCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolvedCIDRCount":
            return Optional.ofNullable(clazz.cast(resolvedCIDRCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResolvedCIDRCount", RESOLVED_CIDR_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IPSetMetadata, T> g) {
        return obj -> g.apply((IPSetMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPSetMetadata> {
        /**
         * <p>
         * Describes the total number of CIDR blocks currently in use by the IP set references in a firewall. To
         * determine how many CIDR blocks are available for you to use in a firewall, you can call
         * <code>AvailableCIDRCount</code>.
         * </p>
         * 
         * @param resolvedCIDRCount
         *        Describes the total number of CIDR blocks currently in use by the IP set references in a firewall. To
         *        determine how many CIDR blocks are available for you to use in a firewall, you can call
         *        <code>AvailableCIDRCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedCIDRCount(Integer resolvedCIDRCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer resolvedCIDRCount;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetMetadata model) {
            resolvedCIDRCount(model.resolvedCIDRCount);
        }

        public final Integer getResolvedCIDRCount() {
            return resolvedCIDRCount;
        }

        public final void setResolvedCIDRCount(Integer resolvedCIDRCount) {
            this.resolvedCIDRCount = resolvedCIDRCount;
        }

        @Override
        public final Builder resolvedCIDRCount(Integer resolvedCIDRCount) {
            this.resolvedCIDRCount = resolvedCIDRCount;
            return this;
        }

        @Override
        public IPSetMetadata build() {
            return new IPSetMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
