/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlowOperationResultsResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<ListFlowOperationResultsResponse.Builder, ListFlowOperationResultsResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(ListFlowOperationResultsResponse::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ListFlowOperationResultsResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationArn").getter(getter(ListFlowOperationResultsResponse::vpcEndpointAssociationArn))
            .setter(setter(Builder::vpcEndpointAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(ListFlowOperationResultsResponse::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationId").getter(getter(ListFlowOperationResultsResponse::flowOperationId))
            .setter(setter(Builder::flowOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()).build();

    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationStatus").getter(getter(ListFlowOperationResultsResponse::flowOperationStatusAsString))
            .setter(setter(Builder::flowOperationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ListFlowOperationResultsResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> FLOW_REQUEST_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FlowRequestTimestamp").getter(getter(ListFlowOperationResultsResponse::flowRequestTimestamp))
            .setter(setter(Builder::flowRequestTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowRequestTimestamp").build())
            .build();

    private static final SdkField<List<Flow>> FLOWS_FIELD = SdkField
            .<List<Flow>> builder(MarshallingType.LIST)
            .memberName("Flows")
            .getter(getter(ListFlowOperationResultsResponse::flows))
            .setter(setter(Builder::flows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Flow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Flow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFlowOperationResultsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            AVAILABILITY_ZONE_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, VPC_ENDPOINT_ID_FIELD, FLOW_OPERATION_ID_FIELD,
            FLOW_OPERATION_STATUS_FIELD, STATUS_MESSAGE_FIELD, FLOW_REQUEST_TIMESTAMP_FIELD, FLOWS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String availabilityZone;

    private final String vpcEndpointAssociationArn;

    private final String vpcEndpointId;

    private final String flowOperationId;

    private final String flowOperationStatus;

    private final String statusMessage;

    private final Instant flowRequestTimestamp;

    private final List<Flow> flows;

    private final String nextToken;

    private ListFlowOperationResultsResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.availabilityZone = builder.availabilityZone;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationStatus = builder.flowOperationStatus;
        this.statusMessage = builder.statusMessage;
        this.flowRequestTimestamp = builder.flowRequestTimestamp;
        this.flows = builder.flows;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
     * </p>
     * <p>
     * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     * </p>
     * 
     * @return The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.</p>
     *         <p>
     *         Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String vpcEndpointAssociationArn() {
        return vpcEndpointAssociationArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands. You
     * provide to describe commands.
     * </p>
     * 
     * @return A unique identifier for the flow operation. This ID is returned in the responses to start and list
     *         commands. You provide to describe commands.
     */
    public final String flowOperationId() {
        return flowOperationId;
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(flowOperationStatus);
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final String flowOperationStatusAsString() {
        return flowOperationStatus;
    }

    /**
     * <p>
     * If the asynchronous operation fails, Network Firewall populates this with the reason for the error or failure.
     * Options include <code>Flow operation error</code> and <code>Flow timeout</code>.
     * </p>
     * 
     * @return If the asynchronous operation fails, Network Firewall populates this with the reason for the error or
     *         failure. Options include <code>Flow operation error</code> and <code>Flow timeout</code>.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * A timestamp indicating when the Suricata engine identified flows impacted by an operation.
     * </p>
     * 
     * @return A timestamp indicating when the Suricata engine identified flows impacted by an operation.
     */
    public final Instant flowRequestTimestamp() {
        return flowRequestTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Flows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFlows() {
        return flows != null && !(flows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any number of arrays, where each array is a single flow identified in the scope of the operation. If multiple
     * flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlows} method.
     * </p>
     * 
     * @return Any number of arrays, where each array is a single flow identified in the scope of the operation. If
     *         multiple flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
     */
    public final List<Flow> flows() {
        return flows;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(flowRequestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasFlows() ? flows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationResultsResponse)) {
            return false;
        }
        ListFlowOperationResultsResponse other = (ListFlowOperationResultsResponse) obj;
        return Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(flowOperationId(), other.flowOperationId())
                && Objects.equals(flowOperationStatusAsString(), other.flowOperationStatusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(flowRequestTimestamp(), other.flowRequestTimestamp()) && hasFlows() == other.hasFlows()
                && Objects.equals(flows(), other.flows()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFlowOperationResultsResponse").add("FirewallArn", firewallArn())
                .add("AvailabilityZone", availabilityZone()).add("VpcEndpointAssociationArn", vpcEndpointAssociationArn())
                .add("VpcEndpointId", vpcEndpointId()).add("FlowOperationId", flowOperationId())
                .add("FlowOperationStatus", flowOperationStatusAsString()).add("StatusMessage", statusMessage())
                .add("FlowRequestTimestamp", flowRequestTimestamp()).add("Flows", hasFlows() ? flows() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcEndpointAssociationArn":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationArn()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "FlowOperationId":
            return Optional.ofNullable(clazz.cast(flowOperationId()));
        case "FlowOperationStatus":
            return Optional.ofNullable(clazz.cast(flowOperationStatusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "FlowRequestTimestamp":
            return Optional.ofNullable(clazz.cast(flowRequestTimestamp()));
        case "Flows":
            return Optional.ofNullable(clazz.cast(flows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("FlowRequestTimestamp", FLOW_REQUEST_TIMESTAMP_FIELD);
        map.put("Flows", FLOWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationResultsResponse, T> g) {
        return obj -> g.apply((ListFlowOperationResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFlowOperationResultsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>.
         * </p>
         * <p>
         * Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * </p>
         * 
         * @param availabilityZone
         *        The ID of the Availability Zone where the firewall is located. For example, <code>us-east-2a</code>
         *        .</p>
         *        <p>
         *        Defines the scope a flow operation. You can use up to 20 filters to configure a single flow operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p/>
         * 
         * @param vpcEndpointAssociationArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn);

        /**
         * <p/>
         * 
         * @param vpcEndpointId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands.
         * You provide to describe commands.
         * </p>
         * 
         * @param flowOperationId
         *        A unique identifier for the flow operation. This ID is returned in the responses to start and list
         *        commands. You provide to describe commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperationId(String flowOperationId);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(String flowOperationStatus);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(FlowOperationStatus flowOperationStatus);

        /**
         * <p>
         * If the asynchronous operation fails, Network Firewall populates this with the reason for the error or
         * failure. Options include <code>Flow operation error</code> and <code>Flow timeout</code>.
         * </p>
         * 
         * @param statusMessage
         *        If the asynchronous operation fails, Network Firewall populates this with the reason for the error or
         *        failure. Options include <code>Flow operation error</code> and <code>Flow timeout</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * A timestamp indicating when the Suricata engine identified flows impacted by an operation.
         * </p>
         * 
         * @param flowRequestTimestamp
         *        A timestamp indicating when the Suricata engine identified flows impacted by an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowRequestTimestamp(Instant flowRequestTimestamp);

        /**
         * <p>
         * Any number of arrays, where each array is a single flow identified in the scope of the operation. If multiple
         * flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
         * </p>
         * 
         * @param flows
         *        Any number of arrays, where each array is a single flow identified in the scope of the operation. If
         *        multiple flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(Collection<Flow> flows);

        /**
         * <p>
         * Any number of arrays, where each array is a single flow identified in the scope of the operation. If multiple
         * flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
         * </p>
         * 
         * @param flows
         *        Any number of arrays, where each array is a single flow identified in the scope of the operation. If
         *        multiple flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flows(Flow... flows);

        /**
         * <p>
         * Any number of arrays, where each array is a single flow identified in the scope of the operation. If multiple
         * flows were in the scope of the operation, multiple <code>Flows</code> arrays are returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Flow.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Flow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Flow.Builder#build()} is called immediately and
         * its result is passed to {@link #flows(List<Flow>)}.
         * 
         * @param flows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Flow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flows(java.util.Collection<Flow>)
         */
        Builder flows(Consumer<Flow.Builder>... flows);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String firewallArn;

        private String availabilityZone;

        private String vpcEndpointAssociationArn;

        private String vpcEndpointId;

        private String flowOperationId;

        private String flowOperationStatus;

        private String statusMessage;

        private Instant flowRequestTimestamp;

        private List<Flow> flows = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationResultsResponse model) {
            super(model);
            firewallArn(model.firewallArn);
            availabilityZone(model.availabilityZone);
            vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            vpcEndpointId(model.vpcEndpointId);
            flowOperationId(model.flowOperationId);
            flowOperationStatus(model.flowOperationStatus);
            statusMessage(model.statusMessage);
            flowRequestTimestamp(model.flowRequestTimestamp);
            flows(model.flows);
            nextToken(model.nextToken);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getFlowOperationId() {
            return flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationStatus() {
            return flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getFlowRequestTimestamp() {
            return flowRequestTimestamp;
        }

        public final void setFlowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
        }

        @Override
        public final Builder flowRequestTimestamp(Instant flowRequestTimestamp) {
            this.flowRequestTimestamp = flowRequestTimestamp;
            return this;
        }

        public final List<Flow.Builder> getFlows() {
            List<Flow.Builder> result = FlowsCopier.copyToBuilder(this.flows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlows(Collection<Flow.BuilderImpl> flows) {
            this.flows = FlowsCopier.copyFromBuilder(flows);
        }

        @Override
        public final Builder flows(Collection<Flow> flows) {
            this.flows = FlowsCopier.copy(flows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Flow... flows) {
            flows(Arrays.asList(flows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flows(Consumer<Flow.Builder>... flows) {
            flows(Stream.of(flows).map(c -> Flow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowOperationResultsResponse build() {
            return new ListFlowOperationResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
