/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlowOperationsResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<ListFlowOperationsResponse.Builder, ListFlowOperationsResponse> {
    private static final SdkField<List<FlowOperationMetadata>> FLOW_OPERATIONS_FIELD = SdkField
            .<List<FlowOperationMetadata>> builder(MarshallingType.LIST)
            .memberName("FlowOperations")
            .getter(getter(ListFlowOperationsResponse::flowOperations))
            .setter(setter(Builder::flowOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowOperationMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowOperationMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFlowOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OPERATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FlowOperationMetadata> flowOperations;

    private final String nextToken;

    private ListFlowOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.flowOperations = builder.flowOperations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FlowOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFlowOperations() {
        return flowOperations != null && !(flowOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
     * </p>
     * <p>
     * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic to
     * be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
     * SourcePort.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFlowOperations} method.
     * </p>
     * 
     * @return Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.</p>
     *         <p>
     *         A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For
     *         traffic to be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol,
     *         Source, and SourcePort.
     */
    public final List<FlowOperationMetadata> flowOperations() {
        return flowOperations;
    }

    /**
     * <p>
     * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
     * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned from
     * the prior request in your next request.
     * </p>
     * 
     * @return When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that
     *         are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
     *         returned from the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFlowOperations() ? flowOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowOperationsResponse)) {
            return false;
        }
        ListFlowOperationsResponse other = (ListFlowOperationsResponse) obj;
        return hasFlowOperations() == other.hasFlowOperations() && Objects.equals(flowOperations(), other.flowOperations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFlowOperationsResponse")
                .add("FlowOperations", hasFlowOperations() ? flowOperations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowOperations":
            return Optional.ofNullable(clazz.cast(flowOperations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlowOperations", FLOW_OPERATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFlowOperationsResponse, T> g) {
        return obj -> g.apply((ListFlowOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFlowOperationsResponse> {
        /**
         * <p>
         * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
         * </p>
         * <p>
         * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic
         * to be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
         * SourcePort.
         * </p>
         * 
         * @param flowOperations
         *        Flow operations let you manage the flows tracked in the flow table, also known as the firewall
         *        table.</p>
         *        <p>
         *        A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For
         *        traffic to be considered part of a flow, it must share Destination, DestinationPort, Direction,
         *        Protocol, Source, and SourcePort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperations(Collection<FlowOperationMetadata> flowOperations);

        /**
         * <p>
         * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
         * </p>
         * <p>
         * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic
         * to be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
         * SourcePort.
         * </p>
         * 
         * @param flowOperations
         *        Flow operations let you manage the flows tracked in the flow table, also known as the firewall
         *        table.</p>
         *        <p>
         *        A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For
         *        traffic to be considered part of a flow, it must share Destination, DestinationPort, Direction,
         *        Protocol, Source, and SourcePort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperations(FlowOperationMetadata... flowOperations);

        /**
         * <p>
         * Flow operations let you manage the flows tracked in the flow table, also known as the firewall table.
         * </p>
         * <p>
         * A flow is network traffic that is monitored by a firewall, either by stateful or stateless rules. For traffic
         * to be considered part of a flow, it must share Destination, DestinationPort, Direction, Protocol, Source, and
         * SourcePort.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #flowOperations(List<FlowOperationMetadata>)}.
         * 
         * @param flowOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.FlowOperationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowOperations(java.util.Collection<FlowOperationMetadata>)
         */
        Builder flowOperations(Consumer<FlowOperationMetadata.Builder>... flowOperations);

        /**
         * <p>
         * When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects that are
         * still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token returned
         * from the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        When you request a list of objects with a <code>MaxResults</code> setting, if the number of objects
         *        that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        returned from the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private List<FlowOperationMetadata> flowOperations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowOperationsResponse model) {
            super(model);
            flowOperations(model.flowOperations);
            nextToken(model.nextToken);
        }

        public final List<FlowOperationMetadata.Builder> getFlowOperations() {
            List<FlowOperationMetadata.Builder> result = FlowOperationsCopier.copyToBuilder(this.flowOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFlowOperations(Collection<FlowOperationMetadata.BuilderImpl> flowOperations) {
            this.flowOperations = FlowOperationsCopier.copyFromBuilder(flowOperations);
        }

        @Override
        public final Builder flowOperations(Collection<FlowOperationMetadata> flowOperations) {
            this.flowOperations = FlowOperationsCopier.copy(flowOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowOperations(FlowOperationMetadata... flowOperations) {
            flowOperations(Arrays.asList(flowOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowOperations(Consumer<FlowOperationMetadata.Builder>... flowOperations) {
            flowOperations(Stream.of(flowOperations).map(c -> FlowOperationMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFlowOperationsResponse build() {
            return new ListFlowOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
