/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectNetworkFirewallTransitGatewayAttachmentResponse extends NetworkFirewallResponse
        implements
        ToCopyableBuilder<RejectNetworkFirewallTransitGatewayAttachmentResponse.Builder, RejectNetworkFirewallTransitGatewayAttachmentResponse> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(RejectNetworkFirewallTransitGatewayAttachmentResponse::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").build())
            .build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentStatus")
            .getter(getter(RejectNetworkFirewallTransitGatewayAttachmentResponse::transitGatewayAttachmentStatusAsString))
            .setter(setter(Builder::transitGatewayAttachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transitGatewayAttachmentId;

    private final String transitGatewayAttachmentStatus;

    private RejectNetworkFirewallTransitGatewayAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayAttachmentStatus = builder.transitGatewayAttachmentStatus;
    }

    /**
     * <p>
     * The unique identifier of the transit gateway attachment that was rejected.
     * </p>
     * 
     * @return The unique identifier of the transit gateway attachment that was rejected.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The current status of the transit gateway attachment. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The attachment is being created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The attachment is being deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The attachment has been deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The attachment is in an error state that might be recoverable
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The attachment is active and processing traffic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTING</code> - The attachment is in the process of being rejected
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The attachment has been rejected
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about troubleshooting endpoint failures, see <a href=
     * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitGatewayAttachmentStatus} will return {@link TransitGatewayAttachmentStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #transitGatewayAttachmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the transit gateway attachment. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The attachment is being created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The attachment is being deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The attachment has been deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The attachment is in an error state that might be recoverable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The attachment is active and processing traffic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTING</code> - The attachment is in the process of being rejected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The attachment has been rejected
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about troubleshooting endpoint failures, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     *         >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     * @see TransitGatewayAttachmentStatus
     */
    public final TransitGatewayAttachmentStatus transitGatewayAttachmentStatus() {
        return TransitGatewayAttachmentStatus.fromValue(transitGatewayAttachmentStatus);
    }

    /**
     * <p>
     * The current status of the transit gateway attachment. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The attachment is being created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The attachment is being deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The attachment has been deleted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The attachment is in an error state that might be recoverable
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code> - The attachment is active and processing traffic
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTING</code> - The attachment is in the process of being rejected
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The attachment has been rejected
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about troubleshooting endpoint failures, see <a href=
     * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #transitGatewayAttachmentStatus} will return {@link TransitGatewayAttachmentStatus#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #transitGatewayAttachmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the transit gateway attachment. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The attachment is being created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The attachment is being deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The attachment has been deleted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The attachment creation has failed and cannot be recovered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The attachment is in an error state that might be recoverable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code> - The attachment is active and processing traffic
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTING</code> - The attachment is in the process of being rejected
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The attachment has been rejected
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about troubleshooting endpoint failures, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
     *         >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
     * @see TransitGatewayAttachmentStatus
     */
    public final String transitGatewayAttachmentStatusAsString() {
        return transitGatewayAttachmentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectNetworkFirewallTransitGatewayAttachmentResponse)) {
            return false;
        }
        RejectNetworkFirewallTransitGatewayAttachmentResponse other = (RejectNetworkFirewallTransitGatewayAttachmentResponse) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transitGatewayAttachmentStatusAsString(), other.transitGatewayAttachmentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectNetworkFirewallTransitGatewayAttachmentResponse")
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransitGatewayAttachmentStatus", transitGatewayAttachmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransitGatewayAttachmentStatus":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("TransitGatewayAttachmentStatus", TRANSIT_GATEWAY_ATTACHMENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectNetworkFirewallTransitGatewayAttachmentResponse, T> g) {
        return obj -> g.apply((RejectNetworkFirewallTransitGatewayAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RejectNetworkFirewallTransitGatewayAttachmentResponse> {
        /**
         * <p>
         * The unique identifier of the transit gateway attachment that was rejected.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The unique identifier of the transit gateway attachment that was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The current status of the transit gateway attachment. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The attachment is being created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The attachment is being deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The attachment has been deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The attachment is in an error state that might be recoverable
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The attachment is active and processing traffic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTING</code> - The attachment is in the process of being rejected
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The attachment has been rejected
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about troubleshooting endpoint failures, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param transitGatewayAttachmentStatus
         *        The current status of the transit gateway attachment. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The attachment is being created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The attachment is being deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The attachment has been deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The attachment is in an error state that might be recoverable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The attachment is active and processing traffic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTING</code> - The attachment is in the process of being rejected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The attachment has been rejected
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about troubleshooting endpoint failures, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         *        >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * @see TransitGatewayAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentStatus
         */
        Builder transitGatewayAttachmentStatus(String transitGatewayAttachmentStatus);

        /**
         * <p>
         * The current status of the transit gateway attachment. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The attachment is being created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The attachment is being deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The attachment has been deleted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The attachment is in an error state that might be recoverable
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code> - The attachment is active and processing traffic
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTING</code> - The attachment is in the process of being rejected
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The attachment has been rejected
         * </p>
         * </li>
         * </ul>
         * <p>
         * For information about troubleshooting endpoint failures, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         * >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param transitGatewayAttachmentStatus
         *        The current status of the transit gateway attachment. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The attachment is being created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The attachment is being deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The attachment has been deleted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The attachment creation has failed and cannot be recovered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The attachment is in an error state that might be recoverable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code> - The attachment is active and processing traffic
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code> - The attachment is waiting to be accepted
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTING</code> - The attachment is in the process of being rejected
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The attachment has been rejected
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For information about troubleshooting endpoint failures, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html"
         *        >Troubleshooting firewall endpoint failures</a> in the <i>Network Firewall Developer Guide</i>.
         * @see TransitGatewayAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentStatus
         */
        Builder transitGatewayAttachmentStatus(TransitGatewayAttachmentStatus transitGatewayAttachmentStatus);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transitGatewayAttachmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectNetworkFirewallTransitGatewayAttachmentResponse model) {
            super(model);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transitGatewayAttachmentStatus(model.transitGatewayAttachmentStatus);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayAttachmentStatus() {
            return transitGatewayAttachmentStatus;
        }

        public final void setTransitGatewayAttachmentStatus(String transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus = transitGatewayAttachmentStatus;
        }

        @Override
        public final Builder transitGatewayAttachmentStatus(String transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus = transitGatewayAttachmentStatus;
            return this;
        }

        @Override
        public final Builder transitGatewayAttachmentStatus(TransitGatewayAttachmentStatus transitGatewayAttachmentStatus) {
            this.transitGatewayAttachmentStatus(transitGatewayAttachmentStatus == null ? null : transitGatewayAttachmentStatus
                    .toString());
            return this;
        }

        @Override
        public RejectNetworkFirewallTransitGatewayAttachmentResponse build() {
            return new RejectNetworkFirewallTransitGatewayAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
