/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFlowCaptureResponse extends NetworkFirewallResponse implements
        ToCopyableBuilder<StartFlowCaptureResponse.Builder, StartFlowCaptureResponse> {
    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(StartFlowCaptureResponse::firewallArn)).setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FLOW_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationId").getter(getter(StartFlowCaptureResponse::flowOperationId))
            .setter(setter(Builder::flowOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationId").build()).build();

    private static final SdkField<String> FLOW_OPERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowOperationStatus").getter(getter(StartFlowCaptureResponse::flowOperationStatusAsString))
            .setter(setter(Builder::flowOperationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowOperationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_ARN_FIELD,
            FLOW_OPERATION_ID_FIELD, FLOW_OPERATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallArn;

    private final String flowOperationId;

    private final String flowOperationStatus;

    private StartFlowCaptureResponse(BuilderImpl builder) {
        super(builder);
        this.firewallArn = builder.firewallArn;
        this.flowOperationId = builder.flowOperationId;
        this.flowOperationStatus = builder.flowOperationStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands. You
     * provide to describe commands.
     * </p>
     * 
     * @return A unique identifier for the flow operation. This ID is returned in the responses to start and list
     *         commands. You provide to describe commands.
     */
    public final String flowOperationId() {
        return flowOperationId;
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final FlowOperationStatus flowOperationStatus() {
        return FlowOperationStatus.fromValue(flowOperationStatus);
    }

    /**
     * <p>
     * Returns the status of the flow operation. This string is returned in the responses to start, list, and describe
     * commands.
     * </p>
     * <p>
     * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code> returned
     * will be empty.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowOperationStatus} will return {@link FlowOperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowOperationStatusAsString}.
     * </p>
     * 
     * @return Returns the status of the flow operation. This string is returned in the responses to start, list, and
     *         describe commands.</p>
     *         <p>
     *         If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
     *         <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
     *         returned will be empty.
     * @see FlowOperationStatus
     */
    public final String flowOperationStatusAsString() {
        return flowOperationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(flowOperationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowCaptureResponse)) {
            return false;
        }
        StartFlowCaptureResponse other = (StartFlowCaptureResponse) obj;
        return Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(flowOperationId(), other.flowOperationId())
                && Objects.equals(flowOperationStatusAsString(), other.flowOperationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFlowCaptureResponse").add("FirewallArn", firewallArn())
                .add("FlowOperationId", flowOperationId()).add("FlowOperationStatus", flowOperationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FlowOperationId":
            return Optional.ofNullable(clazz.cast(flowOperationId()));
        case "FlowOperationStatus":
            return Optional.ofNullable(clazz.cast(flowOperationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("FlowOperationId", FLOW_OPERATION_ID_FIELD);
        map.put("FlowOperationStatus", FLOW_OPERATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlowCaptureResponse, T> g) {
        return obj -> g.apply((StartFlowCaptureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NetworkFirewallResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartFlowCaptureResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * A unique identifier for the flow operation. This ID is returned in the responses to start and list commands.
         * You provide to describe commands.
         * </p>
         * 
         * @param flowOperationId
         *        A unique identifier for the flow operation. This ID is returned in the responses to start and list
         *        commands. You provide to describe commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowOperationId(String flowOperationId);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(String flowOperationStatus);

        /**
         * <p>
         * Returns the status of the flow operation. This string is returned in the responses to start, list, and
         * describe commands.
         * </p>
         * <p>
         * If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         * <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         * returned will be empty.
         * </p>
         * 
         * @param flowOperationStatus
         *        Returns the status of the flow operation. This string is returned in the responses to start, list, and
         *        describe commands.</p>
         *        <p>
         *        If the status is <code>COMPLETED_WITH_ERRORS</code>, results may be returned with any number of
         *        <code>Flows</code> missing from the response. If the status is <code>FAILED</code>, <code>Flows</code>
         *        returned will be empty.
         * @see FlowOperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowOperationStatus
         */
        Builder flowOperationStatus(FlowOperationStatus flowOperationStatus);
    }

    static final class BuilderImpl extends NetworkFirewallResponse.BuilderImpl implements Builder {
        private String firewallArn;

        private String flowOperationId;

        private String flowOperationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowCaptureResponse model) {
            super(model);
            firewallArn(model.firewallArn);
            flowOperationId(model.flowOperationId);
            flowOperationStatus(model.flowOperationStatus);
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFlowOperationId() {
            return flowOperationId;
        }

        public final void setFlowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
        }

        @Override
        public final Builder flowOperationId(String flowOperationId) {
            this.flowOperationId = flowOperationId;
            return this;
        }

        public final String getFlowOperationStatus() {
            return flowOperationStatus;
        }

        public final void setFlowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
        }

        @Override
        public final Builder flowOperationStatus(String flowOperationStatus) {
            this.flowOperationStatus = flowOperationStatus;
            return this;
        }

        @Override
        public final Builder flowOperationStatus(FlowOperationStatus flowOperationStatus) {
            this.flowOperationStatus(flowOperationStatus == null ? null : flowOperationStatus.toString());
            return this;
        }

        @Override
        public StartFlowCaptureResponse build() {
            return new StartFlowCaptureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
