/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single stateless rule. This is used in <a>StatelessRulesAndCustomActions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatelessRule implements SdkPojo, Serializable, ToCopyableBuilder<StatelessRule.Builder, StatelessRule> {
    private static final SdkField<RuleDefinition> RULE_DEFINITION_FIELD = SdkField
            .<RuleDefinition> builder(MarshallingType.SDK_POJO).memberName("RuleDefinition")
            .getter(getter(StatelessRule::ruleDefinition)).setter(setter(Builder::ruleDefinition))
            .constructor(RuleDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleDefinition").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(StatelessRule::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_DEFINITION_FIELD,
            PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleDefinition ruleDefinition;

    private final Integer priority;

    private StatelessRule(BuilderImpl builder) {
        this.ruleDefinition = builder.ruleDefinition;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the
     * criteria.
     * </p>
     * 
     * @return Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches
     *         the criteria.
     */
    public final RuleDefinition ruleDefinition() {
        return ruleDefinition;
    }

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule
     * group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting. You must
     * ensure that the priority settings are unique for the rule group.
     * </p>
     * <p>
     * Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each
     * <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To ensure
     * unique priority settings for your rule groups, set unique priorities for the stateless rules that you define
     * inside any single <code>StatelessRules</code> object.
     * </p>
     * <p>
     * You can change the priority settings of your rules at any time. To make it easier to insert rules later, number
     * them so there's a wide range in between, for example use 100, 200, and so on.
     * </p>
     * 
     * @return Indicates the order in which to run this rule relative to all of the rules that are defined for a
     *         stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest
     *         priority setting. You must ensure that the priority settings are unique for the rule group. </p>
     *         <p>
     *         Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each
     *         <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To
     *         ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that
     *         you define inside any single <code>StatelessRules</code> object.
     *         </p>
     *         <p>
     *         You can change the priority settings of your rules at any time. To make it easier to insert rules later,
     *         number them so there's a wide range in between, for example use 100, 200, and so on.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatelessRule)) {
            return false;
        }
        StatelessRule other = (StatelessRule) obj;
        return Objects.equals(ruleDefinition(), other.ruleDefinition()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatelessRule").add("RuleDefinition", ruleDefinition()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleDefinition":
            return Optional.ofNullable(clazz.cast(ruleDefinition()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleDefinition", RULE_DEFINITION_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatelessRule, T> g) {
        return obj -> g.apply((StatelessRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatelessRule> {
        /**
         * <p>
         * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the
         * criteria.
         * </p>
         * 
         * @param ruleDefinition
         *        Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that
         *        matches the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinition(RuleDefinition ruleDefinition);

        /**
         * <p>
         * Defines the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the
         * criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleDefinition.Builder} avoiding the need
         * to create one manually via {@link RuleDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleDefinition(RuleDefinition)}.
         * 
         * @param ruleDefinition
         *        a consumer that will call methods on {@link RuleDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleDefinition(RuleDefinition)
         */
        default Builder ruleDefinition(Consumer<RuleDefinition.Builder> ruleDefinition) {
            return ruleDefinition(RuleDefinition.builder().applyMutation(ruleDefinition).build());
        }

        /**
         * <p>
         * Indicates the order in which to run this rule relative to all of the rules that are defined for a stateless
         * rule group. Network Firewall evaluates the rules in a rule group starting with the lowest priority setting.
         * You must ensure that the priority settings are unique for the rule group.
         * </p>
         * <p>
         * Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and each
         * <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code> object. To
         * ensure unique priority settings for your rule groups, set unique priorities for the stateless rules that you
         * define inside any single <code>StatelessRules</code> object.
         * </p>
         * <p>
         * You can change the priority settings of your rules at any time. To make it easier to insert rules later,
         * number them so there's a wide range in between, for example use 100, 200, and so on.
         * </p>
         * 
         * @param priority
         *        Indicates the order in which to run this rule relative to all of the rules that are defined for a
         *        stateless rule group. Network Firewall evaluates the rules in a rule group starting with the lowest
         *        priority setting. You must ensure that the priority settings are unique for the rule group. </p>
         *        <p>
         *        Each stateless rule group uses exactly one <code>StatelessRulesAndCustomActions</code> object, and
         *        each <code>StatelessRulesAndCustomActions</code> contains exactly one <code>StatelessRules</code>
         *        object. To ensure unique priority settings for your rule groups, set unique priorities for the
         *        stateless rules that you define inside any single <code>StatelessRules</code> object.
         *        </p>
         *        <p>
         *        You can change the priority settings of your rules at any time. To make it easier to insert rules
         *        later, number them so there's a wide range in between, for example use 100, 200, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private RuleDefinition ruleDefinition;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(StatelessRule model) {
            ruleDefinition(model.ruleDefinition);
            priority(model.priority);
        }

        public final RuleDefinition.Builder getRuleDefinition() {
            return ruleDefinition != null ? ruleDefinition.toBuilder() : null;
        }

        public final void setRuleDefinition(RuleDefinition.BuilderImpl ruleDefinition) {
            this.ruleDefinition = ruleDefinition != null ? ruleDefinition.build() : null;
        }

        @Override
        public final Builder ruleDefinition(RuleDefinition ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public StatelessRule build() {
            return new StatelessRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
