/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A VPC endpoint association defines a single subnet to use for a firewall endpoint for a <code>Firewall</code>. You
 * can define VPC endpoint associations only in the Availability Zones that already have a subnet mapping defined in the
 * <code>Firewall</code> resource.
 * </p>
 * <note>
 * <p>
 * You can retrieve the list of Availability Zones that are available for use by calling
 * <code>DescribeFirewallMetadata</code>.
 * </p>
 * </note>
 * <p>
 * To manage firewall endpoints, first, in the <code>Firewall</code> specification, you specify a single VPC and one
 * subnet for each of the Availability Zones where you want to use the firewall. Then you can define additional
 * endpoints as VPC endpoint associations.
 * </p>
 * <p>
 * You can use VPC endpoint associations to expand the protections of the firewall as follows:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Protect multiple VPCs with a single firewall</b> - You can use the firewall to protect other VPCs, either in your
 * account or in accounts where the firewall is shared. You can only specify Availability Zones that already have a
 * firewall endpoint defined in the <code>Firewall</code> subnet mappings.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Define multiple firewall endpoints for a VPC in an Availability Zone</b> - You can create additional firewall
 * endpoints for the VPC that you have defined in the firewall, in any Availability Zone that already has an endpoint
 * defined in the <code>Firewall</code> subnet mappings. You can create multiple VPC endpoint associations for any other
 * VPC where you use the firewall.
 * </p>
 * </li>
 * </ul>
 * <p>
 * You can use Resource Access Manager to share a <code>Firewall</code> that you own with other accounts, which gives
 * them the ability to use the firewall to create VPC endpoint associations. For information about sharing a firewall,
 * see <code>PutResourcePolicy</code> in this guide and see <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/sharing.html">Sharing Network Firewall
 * resources</a> in the <i>Network Firewall Developer Guide</i>.
 * </p>
 * <p>
 * The status of the VPC endpoint association, which indicates whether it's ready to filter network traffic, is provided
 * in the corresponding <a>VpcEndpointAssociationStatus</a>. You can retrieve both the association and its status by
 * calling <a>DescribeVpcEndpointAssociation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpointAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEndpointAssociation.Builder, VpcEndpointAssociation> {
    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationId").getter(getter(VpcEndpointAssociation::vpcEndpointAssociationId))
            .setter(setter(Builder::vpcEndpointAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationId").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointAssociationArn").getter(getter(VpcEndpointAssociation::vpcEndpointAssociationArn))
            .setter(setter(Builder::vpcEndpointAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointAssociationArn").build())
            .build();

    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(VpcEndpointAssociation::firewallArn)).setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcEndpointAssociation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<SubnetMapping> SUBNET_MAPPING_FIELD = SdkField
            .<SubnetMapping> builder(MarshallingType.SDK_POJO).memberName("SubnetMapping")
            .getter(getter(VpcEndpointAssociation::subnetMapping)).setter(setter(Builder::subnetMapping))
            .constructor(SubnetMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMapping").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(VpcEndpointAssociation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VpcEndpointAssociation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_ASSOCIATION_ID_FIELD, VPC_ENDPOINT_ASSOCIATION_ARN_FIELD, FIREWALL_ARN_FIELD, VPC_ID_FIELD,
            SUBNET_MAPPING_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointAssociationId;

    private final String vpcEndpointAssociationArn;

    private final String firewallArn;

    private final String vpcId;

    private final SubnetMapping subnetMapping;

    private final String description;

    private final List<Tag> tags;

    private VpcEndpointAssociation(BuilderImpl builder) {
        this.vpcEndpointAssociationId = builder.vpcEndpointAssociationId;
        this.vpcEndpointAssociationArn = builder.vpcEndpointAssociationArn;
        this.firewallArn = builder.firewallArn;
        this.vpcId = builder.vpcId;
        this.subnetMapping = builder.subnetMapping;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the VPC endpoint association.
     * </p>
     * 
     * @return The unique identifier of the VPC endpoint association.
     */
    public final String vpcEndpointAssociationId() {
        return vpcEndpointAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a VPC endpoint association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a VPC endpoint association.
     */
    public final String vpcEndpointAssociationArn() {
        return vpcEndpointAssociationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The unique identifier of the VPC for the endpoint association.
     * </p>
     * 
     * @return The unique identifier of the VPC for the endpoint association.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * Returns the value of the SubnetMapping property for this object.
     * 
     * @return The value of the SubnetMapping property for this object.
     */
    public final SubnetMapping subnetMapping() {
        return subnetMapping;
    }

    /**
     * <p>
     * A description of the VPC endpoint association.
     * </p>
     * 
     * @return A description of the VPC endpoint association.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key:value pairs to associate with the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key:value pairs to associate with the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetMapping());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociation)) {
            return false;
        }
        VpcEndpointAssociation other = (VpcEndpointAssociation) obj;
        return Objects.equals(vpcEndpointAssociationId(), other.vpcEndpointAssociationId())
                && Objects.equals(vpcEndpointAssociationArn(), other.vpcEndpointAssociationArn())
                && Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(subnetMapping(), other.subnetMapping()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpointAssociation").add("VpcEndpointAssociationId", vpcEndpointAssociationId())
                .add("VpcEndpointAssociationArn", vpcEndpointAssociationArn()).add("FirewallArn", firewallArn())
                .add("VpcId", vpcId()).add("SubnetMapping", subnetMapping()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointAssociationId":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationId()));
        case "VpcEndpointAssociationArn":
            return Optional.ofNullable(clazz.cast(vpcEndpointAssociationArn()));
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetMapping":
            return Optional.ofNullable(clazz.cast(subnetMapping()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointAssociationId", VPC_ENDPOINT_ASSOCIATION_ID_FIELD);
        map.put("VpcEndpointAssociationArn", VPC_ENDPOINT_ASSOCIATION_ARN_FIELD);
        map.put("FirewallArn", FIREWALL_ARN_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetMapping", SUBNET_MAPPING_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociation, T> g) {
        return obj -> g.apply((VpcEndpointAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpointAssociation> {
        /**
         * <p>
         * The unique identifier of the VPC endpoint association.
         * </p>
         * 
         * @param vpcEndpointAssociationId
         *        The unique identifier of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationId(String vpcEndpointAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a VPC endpoint association.
         * </p>
         * 
         * @param vpcEndpointAssociationArn
         *        The Amazon Resource Name (ARN) of a VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The Amazon Resource Name (ARN) of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The unique identifier of the VPC for the endpoint association.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the VPC for the endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * Sets the value of the SubnetMapping property for this object.
         *
         * @param subnetMapping
         *        The new value for the SubnetMapping property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMapping(SubnetMapping subnetMapping);

        /**
         * Sets the value of the SubnetMapping property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SubnetMapping.Builder} avoiding the need
         * to create one manually via {@link SubnetMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubnetMapping.Builder#build()} is called immediately and its
         * result is passed to {@link #subnetMapping(SubnetMapping)}.
         * 
         * @param subnetMapping
         *        a consumer that will call methods on {@link SubnetMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetMapping(SubnetMapping)
         */
        default Builder subnetMapping(Consumer<SubnetMapping.Builder> subnetMapping) {
            return subnetMapping(SubnetMapping.builder().applyMutation(subnetMapping).build());
        }

        /**
         * <p>
         * A description of the VPC endpoint association.
         * </p>
         * 
         * @param description
         *        A description of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * 
         * @param tags
         *        The key:value pairs to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key:value pairs to associate with the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.networkfirewall.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointAssociationId;

        private String vpcEndpointAssociationArn;

        private String firewallArn;

        private String vpcId;

        private SubnetMapping subnetMapping;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociation model) {
            vpcEndpointAssociationId(model.vpcEndpointAssociationId);
            vpcEndpointAssociationArn(model.vpcEndpointAssociationArn);
            firewallArn(model.firewallArn);
            vpcId(model.vpcId);
            subnetMapping(model.subnetMapping);
            description(model.description);
            tags(model.tags);
        }

        public final String getVpcEndpointAssociationId() {
            return vpcEndpointAssociationId;
        }

        public final void setVpcEndpointAssociationId(String vpcEndpointAssociationId) {
            this.vpcEndpointAssociationId = vpcEndpointAssociationId;
        }

        @Override
        public final Builder vpcEndpointAssociationId(String vpcEndpointAssociationId) {
            this.vpcEndpointAssociationId = vpcEndpointAssociationId;
            return this;
        }

        public final String getVpcEndpointAssociationArn() {
            return vpcEndpointAssociationArn;
        }

        public final void setVpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
        }

        @Override
        public final Builder vpcEndpointAssociationArn(String vpcEndpointAssociationArn) {
            this.vpcEndpointAssociationArn = vpcEndpointAssociationArn;
            return this;
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final SubnetMapping.Builder getSubnetMapping() {
            return subnetMapping != null ? subnetMapping.toBuilder() : null;
        }

        public final void setSubnetMapping(SubnetMapping.BuilderImpl subnetMapping) {
            this.subnetMapping = subnetMapping != null ? subnetMapping.build() : null;
        }

        @Override
        public final Builder subnetMapping(SubnetMapping subnetMapping) {
            this.subnetMapping = subnetMapping;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VpcEndpointAssociation build() {
            return new VpcEndpointAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
