/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the current status of a <a>VpcEndpointAssociation</a>. You can retrieve this by calling
 * <a>DescribeVpcEndpointAssociation</a> and providing the VPC endpoint association ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpointAssociationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEndpointAssociationStatus.Builder, VpcEndpointAssociationStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VpcEndpointAssociationStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, AZSyncState>> ASSOCIATION_SYNC_STATE_FIELD = SdkField
            .<Map<String, AZSyncState>> builder(MarshallingType.MAP)
            .memberName("AssociationSyncState")
            .getter(getter(VpcEndpointAssociationStatus::associationSyncState))
            .setter(setter(Builder::associationSyncState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSyncState").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AZSyncState> builder(MarshallingType.SDK_POJO)
                                            .constructor(AZSyncState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ASSOCIATION_SYNC_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Map<String, AZSyncState> associationSyncState;

    private VpcEndpointAssociationStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.associationSyncState = builder.associationSyncState;
    }

    /**
     * <p>
     * The readiness of the configured firewall endpoint to handle network traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall endpoint to handle network traffic.
     * @see FirewallStatusValue
     */
    public final FirewallStatusValue status() {
        return FirewallStatusValue.fromValue(status);
    }

    /**
     * <p>
     * The readiness of the configured firewall endpoint to handle network traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The readiness of the configured firewall endpoint to handle network traffic.
     * @see FirewallStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationSyncState property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociationSyncState() {
        return associationSyncState != null && !(associationSyncState instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of the Availability Zone sync states for all subnets that are defined by the firewall.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationSyncState} method.
     * </p>
     * 
     * @return The list of the Availability Zone sync states for all subnets that are defined by the firewall.
     */
    public final Map<String, AZSyncState> associationSyncState() {
        return associationSyncState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationSyncState() ? associationSyncState() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointAssociationStatus)) {
            return false;
        }
        VpcEndpointAssociationStatus other = (VpcEndpointAssociationStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && hasAssociationSyncState() == other.hasAssociationSyncState()
                && Objects.equals(associationSyncState(), other.associationSyncState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpointAssociationStatus").add("Status", statusAsString())
                .add("AssociationSyncState", hasAssociationSyncState() ? associationSyncState() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AssociationSyncState":
            return Optional.ofNullable(clazz.cast(associationSyncState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("AssociationSyncState", ASSOCIATION_SYNC_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointAssociationStatus, T> g) {
        return obj -> g.apply((VpcEndpointAssociationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpointAssociationStatus> {
        /**
         * <p>
         * The readiness of the configured firewall endpoint to handle network traffic.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall endpoint to handle network traffic.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * The readiness of the configured firewall endpoint to handle network traffic.
         * </p>
         * 
         * @param status
         *        The readiness of the configured firewall endpoint to handle network traffic.
         * @see FirewallStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallStatusValue
         */
        Builder status(FirewallStatusValue status);

        /**
         * <p>
         * The list of the Availability Zone sync states for all subnets that are defined by the firewall.
         * </p>
         * 
         * @param associationSyncState
         *        The list of the Availability Zone sync states for all subnets that are defined by the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSyncState(Map<String, AZSyncState> associationSyncState);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Map<String, AZSyncState> associationSyncState = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointAssociationStatus model) {
            status(model.status);
            associationSyncState(model.associationSyncState);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, AZSyncState.Builder> getAssociationSyncState() {
            Map<String, AZSyncState.Builder> result = AssociationSyncStateCopier.copyToBuilder(this.associationSyncState);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociationSyncState(Map<String, AZSyncState.BuilderImpl> associationSyncState) {
            this.associationSyncState = AssociationSyncStateCopier.copyFromBuilder(associationSyncState);
        }

        @Override
        public final Builder associationSyncState(Map<String, AZSyncState> associationSyncState) {
            this.associationSyncState = AssociationSyncStateCopier.copy(associationSyncState);
            return this;
        }

        @Override
        public VpcEndpointAssociationStatus build() {
            return new VpcEndpointAssociationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
