/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateLinkRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<AssociateLinkRequest.Builder, AssociateLinkRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateLinkRequest::globalNetworkId)).setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateLinkRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateLinkRequest::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            DEVICE_ID_FIELD, LINK_ID_FIELD));

    private final String globalNetworkId;

    private final String deviceId;

    private final String linkId;

    private AssociateLinkRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the link.
     * </p>
     * 
     * @return The ID of the link.
     */
    public String linkId() {
        return linkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateLinkRequest)) {
            return false;
        }
        AssociateLinkRequest other = (AssociateLinkRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(linkId(), other.linkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateLinkRequest").add("GlobalNetworkId", globalNetworkId()).add("DeviceId", deviceId())
                .add("LinkId", linkId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "LinkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateLinkRequest, T> g) {
        return obj -> g.apply((AssociateLinkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateLinkRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the link.
         * </p>
         * 
         * @param linkId
         *        The ID of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String deviceId;

        private String linkId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateLinkRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            linkId(model.linkId);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getLinkId() {
            return linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateLinkRequest build() {
            return new AssociateLinkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
