/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association between a device and a link.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LinkAssociation implements SdkPojo, Serializable, ToCopyableBuilder<LinkAssociation.Builder, LinkAssociation> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LinkAssociation::globalNetworkId)).setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LinkAssociation::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LinkAssociation::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()).build();

    private static final SdkField<String> LINK_ASSOCIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LinkAssociation::linkAssociationStateAsString)).setter(setter(Builder::linkAssociationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkAssociationState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            DEVICE_ID_FIELD, LINK_ID_FIELD, LINK_ASSOCIATION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String globalNetworkId;

    private final String deviceId;

    private final String linkId;

    private final String linkAssociationState;

    private LinkAssociation(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.linkId = builder.linkId;
        this.linkAssociationState = builder.linkAssociationState;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The device ID for the link association.
     * </p>
     * 
     * @return The device ID for the link association.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the link.
     * </p>
     * 
     * @return The ID of the link.
     */
    public String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linkAssociationState} will return {@link LinkAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #linkAssociationStateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see LinkAssociationState
     */
    public LinkAssociationState linkAssociationState() {
        return LinkAssociationState.fromValue(linkAssociationState);
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #linkAssociationState} will return {@link LinkAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #linkAssociationStateAsString}.
     * </p>
     * 
     * @return The state of the association.
     * @see LinkAssociationState
     */
    public String linkAssociationStateAsString() {
        return linkAssociationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(linkAssociationStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkAssociation)) {
            return false;
        }
        LinkAssociation other = (LinkAssociation) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(linkId(), other.linkId())
                && Objects.equals(linkAssociationStateAsString(), other.linkAssociationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LinkAssociation").add("GlobalNetworkId", globalNetworkId()).add("DeviceId", deviceId())
                .add("LinkId", linkId()).add("LinkAssociationState", linkAssociationStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "LinkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "LinkAssociationState":
            return Optional.ofNullable(clazz.cast(linkAssociationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkAssociation, T> g) {
        return obj -> g.apply((LinkAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LinkAssociation> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The device ID for the link association.
         * </p>
         * 
         * @param deviceId
         *        The device ID for the link association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the link.
         * </p>
         * 
         * @param linkId
         *        The ID of the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param linkAssociationState
         *        The state of the association.
         * @see LinkAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkAssociationState
         */
        Builder linkAssociationState(String linkAssociationState);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param linkAssociationState
         *        The state of the association.
         * @see LinkAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LinkAssociationState
         */
        Builder linkAssociationState(LinkAssociationState linkAssociationState);
    }

    static final class BuilderImpl implements Builder {
        private String globalNetworkId;

        private String deviceId;

        private String linkId;

        private String linkAssociationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LinkAssociation model) {
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            linkId(model.linkId);
            linkAssociationState(model.linkAssociationState);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getLinkId() {
            return linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        public final String getLinkAssociationStateAsString() {
            return linkAssociationState;
        }

        @Override
        public final Builder linkAssociationState(String linkAssociationState) {
            this.linkAssociationState = linkAssociationState;
            return this;
        }

        @Override
        public final Builder linkAssociationState(LinkAssociationState linkAssociationState) {
            this.linkAssociationState(linkAssociationState == null ? null : linkAssociationState.toString());
            return this;
        }

        public final void setLinkAssociationState(String linkAssociationState) {
            this.linkAssociationState = linkAssociationState;
        }

        @Override
        public LinkAssociation build() {
            return new LinkAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
