/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateLinkResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DisassociateLinkResponse.Builder, DisassociateLinkResponse> {
    private static final SdkField<LinkAssociation> LINK_ASSOCIATION_FIELD = SdkField
            .<LinkAssociation> builder(MarshallingType.SDK_POJO).getter(getter(DisassociateLinkResponse::linkAssociation))
            .setter(setter(Builder::linkAssociation)).constructor(LinkAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_ASSOCIATION_FIELD));

    private final LinkAssociation linkAssociation;

    private DisassociateLinkResponse(BuilderImpl builder) {
        super(builder);
        this.linkAssociation = builder.linkAssociation;
    }

    /**
     * <p>
     * Information about the link association.
     * </p>
     * 
     * @return Information about the link association.
     */
    public LinkAssociation linkAssociation() {
        return linkAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(linkAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateLinkResponse)) {
            return false;
        }
        DisassociateLinkResponse other = (DisassociateLinkResponse) obj;
        return Objects.equals(linkAssociation(), other.linkAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateLinkResponse").add("LinkAssociation", linkAssociation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkAssociation":
            return Optional.ofNullable(clazz.cast(linkAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateLinkResponse, T> g) {
        return obj -> g.apply((DisassociateLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DisassociateLinkResponse> {
        /**
         * <p>
         * Information about the link association.
         * </p>
         * 
         * @param linkAssociation
         *        Information about the link association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkAssociation(LinkAssociation linkAssociation);

        /**
         * <p>
         * Information about the link association.
         * </p>
         * This is a convenience that creates an instance of the {@link LinkAssociation.Builder} avoiding the need to
         * create one manually via {@link LinkAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link LinkAssociation.Builder#build()} is called immediately and its
         * result is passed to {@link #linkAssociation(LinkAssociation)}.
         * 
         * @param linkAssociation
         *        a consumer that will call methods on {@link LinkAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkAssociation(LinkAssociation)
         */
        default Builder linkAssociation(Consumer<LinkAssociation.Builder> linkAssociation) {
            return linkAssociation(LinkAssociation.builder().applyMutation(linkAssociation).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private LinkAssociation linkAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateLinkResponse model) {
            super(model);
            linkAssociation(model.linkAssociation);
        }

        public final LinkAssociation.Builder getLinkAssociation() {
            return linkAssociation != null ? linkAssociation.toBuilder() : null;
        }

        @Override
        public final Builder linkAssociation(LinkAssociation linkAssociation) {
            this.linkAssociation = linkAssociation;
            return this;
        }

        public final void setLinkAssociation(LinkAssociation.BuilderImpl linkAssociation) {
            this.linkAssociation = linkAssociation != null ? linkAssociation.build() : null;
        }

        @Override
        public DisassociateLinkResponse build() {
            return new DisassociateLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
