/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes bandwidth information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bandwidth implements SdkPojo, Serializable, ToCopyableBuilder<Bandwidth.Builder, Bandwidth> {
    private static final SdkField<Integer> UPLOAD_SPEED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UploadSpeed").getter(getter(Bandwidth::uploadSpeed)).setter(setter(Builder::uploadSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadSpeed").build()).build();

    private static final SdkField<Integer> DOWNLOAD_SPEED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DownloadSpeed").getter(getter(Bandwidth::downloadSpeed)).setter(setter(Builder::downloadSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownloadSpeed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_SPEED_FIELD,
            DOWNLOAD_SPEED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer uploadSpeed;

    private final Integer downloadSpeed;

    private Bandwidth(BuilderImpl builder) {
        this.uploadSpeed = builder.uploadSpeed;
        this.downloadSpeed = builder.downloadSpeed;
    }

    /**
     * <p>
     * Upload speed in Mbps.
     * </p>
     * 
     * @return Upload speed in Mbps.
     */
    public Integer uploadSpeed() {
        return uploadSpeed;
    }

    /**
     * <p>
     * Download speed in Mbps.
     * </p>
     * 
     * @return Download speed in Mbps.
     */
    public Integer downloadSpeed() {
        return downloadSpeed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uploadSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(downloadSpeed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bandwidth)) {
            return false;
        }
        Bandwidth other = (Bandwidth) obj;
        return Objects.equals(uploadSpeed(), other.uploadSpeed()) && Objects.equals(downloadSpeed(), other.downloadSpeed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Bandwidth").add("UploadSpeed", uploadSpeed()).add("DownloadSpeed", downloadSpeed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadSpeed":
            return Optional.ofNullable(clazz.cast(uploadSpeed()));
        case "DownloadSpeed":
            return Optional.ofNullable(clazz.cast(downloadSpeed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bandwidth, T> g) {
        return obj -> g.apply((Bandwidth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bandwidth> {
        /**
         * <p>
         * Upload speed in Mbps.
         * </p>
         * 
         * @param uploadSpeed
         *        Upload speed in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSpeed(Integer uploadSpeed);

        /**
         * <p>
         * Download speed in Mbps.
         * </p>
         * 
         * @param downloadSpeed
         *        Download speed in Mbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downloadSpeed(Integer downloadSpeed);
    }

    static final class BuilderImpl implements Builder {
        private Integer uploadSpeed;

        private Integer downloadSpeed;

        private BuilderImpl() {
        }

        private BuilderImpl(Bandwidth model) {
            uploadSpeed(model.uploadSpeed);
            downloadSpeed(model.downloadSpeed);
        }

        public final Integer getUploadSpeed() {
            return uploadSpeed;
        }

        @Override
        public final Builder uploadSpeed(Integer uploadSpeed) {
            this.uploadSpeed = uploadSpeed;
            return this;
        }

        public final void setUploadSpeed(Integer uploadSpeed) {
            this.uploadSpeed = uploadSpeed;
        }

        public final Integer getDownloadSpeed() {
            return downloadSpeed;
        }

        @Override
        public final Builder downloadSpeed(Integer downloadSpeed) {
            this.downloadSpeed = downloadSpeed;
            return this;
        }

        public final void setDownloadSpeed(Integer downloadSpeed) {
            this.downloadSpeed = downloadSpeed;
        }

        @Override
        public Bandwidth build() {
            return new Bandwidth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
