/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransitGatewayConnectPeerAssociationsResponse extends NetworkManagerResponse
        implements
        ToCopyableBuilder<GetTransitGatewayConnectPeerAssociationsResponse.Builder, GetTransitGatewayConnectPeerAssociationsResponse> {
    private static final SdkField<List<TransitGatewayConnectPeerAssociation>> TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATIONS_FIELD = SdkField
            .<List<TransitGatewayConnectPeerAssociation>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayConnectPeerAssociations")
            .getter(getter(GetTransitGatewayConnectPeerAssociationsResponse::transitGatewayConnectPeerAssociations))
            .setter(setter(Builder::transitGatewayConnectPeerAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransitGatewayConnectPeerAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayConnectPeerAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayConnectPeerAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTransitGatewayConnectPeerAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations;

    private final String nextToken;

    private GetTransitGatewayConnectPeerAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeerAssociations = builder.transitGatewayConnectPeerAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TransitGatewayConnectPeerAssociations property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public boolean hasTransitGatewayConnectPeerAssociations() {
        return transitGatewayConnectPeerAssociations != null
                && !(transitGatewayConnectPeerAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the transit gateway Connect peer associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTransitGatewayConnectPeerAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the transit gateway Connect peer associations.
     */
    public List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations() {
        return transitGatewayConnectPeerAssociations;
    }

    /**
     * <p>
     * The token to use for the next page of results.
     * </p>
     * 
     * @return The token to use for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasTransitGatewayConnectPeerAssociations() ? transitGatewayConnectPeerAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayConnectPeerAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayConnectPeerAssociationsResponse other = (GetTransitGatewayConnectPeerAssociationsResponse) obj;
        return hasTransitGatewayConnectPeerAssociations() == other.hasTransitGatewayConnectPeerAssociations()
                && Objects.equals(transitGatewayConnectPeerAssociations(), other.transitGatewayConnectPeerAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("GetTransitGatewayConnectPeerAssociationsResponse")
                .add("TransitGatewayConnectPeerAssociations",
                        hasTransitGatewayConnectPeerAssociations() ? transitGatewayConnectPeerAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnectPeerAssociations":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayConnectPeerAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayConnectPeerAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransitGatewayConnectPeerAssociationsResponse> {
        /**
         * <p>
         * Information about the transit gateway Connect peer associations.
         * </p>
         * 
         * @param transitGatewayConnectPeerAssociations
         *        Information about the transit gateway Connect peer associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerAssociations(
                Collection<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations);

        /**
         * <p>
         * Information about the transit gateway Connect peer associations.
         * </p>
         * 
         * @param transitGatewayConnectPeerAssociations
         *        Information about the transit gateway Connect peer associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerAssociations(
                TransitGatewayConnectPeerAssociation... transitGatewayConnectPeerAssociations);

        /**
         * <p>
         * Information about the transit gateway Connect peer associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <TransitGatewayConnectPeerAssociation>.Builder} avoiding the need to create one manually via {@link List
         * <TransitGatewayConnectPeerAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransitGatewayConnectPeerAssociation>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #transitGatewayConnectPeerAssociations(List<TransitGatewayConnectPeerAssociation>)}.
         * 
         * @param transitGatewayConnectPeerAssociations
         *        a consumer that will call methods on {@link List<TransitGatewayConnectPeerAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConnectPeerAssociations(List<TransitGatewayConnectPeerAssociation>)
         */
        Builder transitGatewayConnectPeerAssociations(
                Consumer<TransitGatewayConnectPeerAssociation.Builder>... transitGatewayConnectPeerAssociations);

        /**
         * <p>
         * The token to use for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayConnectPeerAssociationsResponse model) {
            super(model);
            transitGatewayConnectPeerAssociations(model.transitGatewayConnectPeerAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayConnectPeerAssociation.Builder> getTransitGatewayConnectPeerAssociations() {
            if (transitGatewayConnectPeerAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayConnectPeerAssociations != null ? transitGatewayConnectPeerAssociations.stream()
                    .map(TransitGatewayConnectPeerAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayConnectPeerAssociations(
                Collection<TransitGatewayConnectPeerAssociation> transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations = TransitGatewayConnectPeerAssociationListCopier
                    .copy(transitGatewayConnectPeerAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeerAssociations(
                TransitGatewayConnectPeerAssociation... transitGatewayConnectPeerAssociations) {
            transitGatewayConnectPeerAssociations(Arrays.asList(transitGatewayConnectPeerAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayConnectPeerAssociations(
                Consumer<TransitGatewayConnectPeerAssociation.Builder>... transitGatewayConnectPeerAssociations) {
            transitGatewayConnectPeerAssociations(Stream.of(transitGatewayConnectPeerAssociations)
                    .map(c -> TransitGatewayConnectPeerAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayConnectPeerAssociations(
                Collection<TransitGatewayConnectPeerAssociation.BuilderImpl> transitGatewayConnectPeerAssociations) {
            this.transitGatewayConnectPeerAssociations = TransitGatewayConnectPeerAssociationListCopier
                    .copyFromBuilder(transitGatewayConnectPeerAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetTransitGatewayConnectPeerAssociationsResponse build() {
            return new GetTransitGatewayConnectPeerAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
