/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connection implements SdkPojo, Serializable, ToCopyableBuilder<Connection.Builder, Connection> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(Connection::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(Connection::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(Connection::globalNetworkId)).setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(Connection::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> CONNECTED_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectedDeviceId").getter(getter(Connection::connectedDeviceId))
            .setter(setter(Builder::connectedDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDeviceId").build()).build();

    private static final SdkField<String> LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("LinkId")
            .getter(getter(Connection::linkId)).setter(setter(Builder::linkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkId").build()).build();

    private static final SdkField<String> CONNECTED_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectedLinkId").getter(getter(Connection::connectedLinkId)).setter(setter(Builder::connectedLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedLinkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Connection::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Connection::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Connection::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Connection::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            CONNECTION_ARN_FIELD, GLOBAL_NETWORK_ID_FIELD, DEVICE_ID_FIELD, CONNECTED_DEVICE_ID_FIELD, LINK_ID_FIELD,
            CONNECTED_LINK_ID_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionId;

    private final String connectionArn;

    private final String globalNetworkId;

    private final String deviceId;

    private final String connectedDeviceId;

    private final String linkId;

    private final String connectedLinkId;

    private final String description;

    private final Instant createdAt;

    private final String state;

    private final List<Tag> tags;

    private Connection(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.connectionArn = builder.connectionArn;
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.connectedDeviceId = builder.connectedDeviceId;
        this.linkId = builder.linkId;
        this.connectedLinkId = builder.connectedLinkId;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection.
     */
    public String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the first device in the connection.
     * </p>
     * 
     * @return The ID of the first device in the connection.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The ID of the second device in the connection.
     * </p>
     * 
     * @return The ID of the second device in the connection.
     */
    public String connectedDeviceId() {
        return connectedDeviceId;
    }

    /**
     * <p>
     * The ID of the link for the first device in the connection.
     * </p>
     * 
     * @return The ID of the link for the first device in the connection.
     */
    public String linkId() {
        return linkId;
    }

    /**
     * <p>
     * The ID of the link for the second device in the connection.
     * </p>
     * 
     * @return The ID of the link for the second device in the connection.
     */
    public String connectedLinkId() {
        return connectedLinkId;
    }

    /**
     * <p>
     * The description of the connection.
     * </p>
     * 
     * @return The description of the connection.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that the connection was created.
     * </p>
     * 
     * @return The date and time that the connection was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The state of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the connection.
     * @see ConnectionState
     */
    public ConnectionState state() {
        return ConnectionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the connection.
     * @see ConnectionState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the connection.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectedDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(linkId());
        hashCode = 31 * hashCode + Objects.hashCode(connectedLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(connectedDeviceId(), other.connectedDeviceId()) && Objects.equals(linkId(), other.linkId())
                && Objects.equals(connectedLinkId(), other.connectedLinkId())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Connection").add("ConnectionId", connectionId()).add("ConnectionArn", connectionArn())
                .add("GlobalNetworkId", globalNetworkId()).add("DeviceId", deviceId())
                .add("ConnectedDeviceId", connectedDeviceId()).add("LinkId", linkId()).add("ConnectedLinkId", connectedLinkId())
                .add("Description", description()).add("CreatedAt", createdAt()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "ConnectedDeviceId":
            return Optional.ofNullable(clazz.cast(connectedDeviceId()));
        case "LinkId":
            return Optional.ofNullable(clazz.cast(linkId()));
        case "ConnectedLinkId":
            return Optional.ofNullable(clazz.cast(connectedLinkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connection> {
        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the first device in the connection.
         * </p>
         * 
         * @param deviceId
         *        The ID of the first device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The ID of the second device in the connection.
         * </p>
         * 
         * @param connectedDeviceId
         *        The ID of the second device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedDeviceId(String connectedDeviceId);

        /**
         * <p>
         * The ID of the link for the first device in the connection.
         * </p>
         * 
         * @param linkId
         *        The ID of the link for the first device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkId(String linkId);

        /**
         * <p>
         * The ID of the link for the second device in the connection.
         * </p>
         * 
         * @param connectedLinkId
         *        The ID of the link for the second device in the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedLinkId(String connectedLinkId);

        /**
         * <p>
         * The description of the connection.
         * </p>
         * 
         * @param description
         *        The description of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that the connection was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the connection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The state of the connection.
         * </p>
         * 
         * @param state
         *        The state of the connection.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the connection.
         * </p>
         * 
         * @param state
         *        The state of the connection.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder state(ConnectionState state);

        /**
         * <p>
         * The tags for the connection.
         * </p>
         * 
         * @param tags
         *        The tags for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the connection.
         * </p>
         * 
         * @param tags
         *        The tags for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the connection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String connectionId;

        private String connectionArn;

        private String globalNetworkId;

        private String deviceId;

        private String connectedDeviceId;

        private String linkId;

        private String connectedLinkId;

        private String description;

        private Instant createdAt;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            connectionId(model.connectionId);
            connectionArn(model.connectionArn);
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            connectedDeviceId(model.connectedDeviceId);
            linkId(model.linkId);
            connectedLinkId(model.connectedLinkId);
            description(model.description);
            createdAt(model.createdAt);
            state(model.state);
            tags(model.tags);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getConnectedDeviceId() {
            return connectedDeviceId;
        }

        @Override
        public final Builder connectedDeviceId(String connectedDeviceId) {
            this.connectedDeviceId = connectedDeviceId;
            return this;
        }

        public final void setConnectedDeviceId(String connectedDeviceId) {
            this.connectedDeviceId = connectedDeviceId;
        }

        public final String getLinkId() {
            return linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        public final String getConnectedLinkId() {
            return connectedLinkId;
        }

        @Override
        public final Builder connectedLinkId(String connectedLinkId) {
            this.connectedLinkId = connectedLinkId;
            return this;
        }

        public final void setConnectedLinkId(String connectedLinkId) {
            this.connectedLinkId = connectedLinkId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
