/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateTransitGatewayConnectPeerResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<DisassociateTransitGatewayConnectPeerResponse.Builder, DisassociateTransitGatewayConnectPeerResponse> {
    private static final SdkField<TransitGatewayConnectPeerAssociation> TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATION_FIELD = SdkField
            .<TransitGatewayConnectPeerAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayConnectPeerAssociation")
            .getter(getter(DisassociateTransitGatewayConnectPeerResponse::transitGatewayConnectPeerAssociation))
            .setter(setter(Builder::transitGatewayConnectPeerAssociation))
            .constructor(TransitGatewayConnectPeerAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransitGatewayConnectPeerAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_CONNECT_PEER_ASSOCIATION_FIELD));

    private final TransitGatewayConnectPeerAssociation transitGatewayConnectPeerAssociation;

    private DisassociateTransitGatewayConnectPeerResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayConnectPeerAssociation = builder.transitGatewayConnectPeerAssociation;
    }

    /**
     * <p>
     * The transit gateway Connect peer association.
     * </p>
     * 
     * @return The transit gateway Connect peer association.
     */
    public TransitGatewayConnectPeerAssociation transitGatewayConnectPeerAssociation() {
        return transitGatewayConnectPeerAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeerAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTransitGatewayConnectPeerResponse)) {
            return false;
        }
        DisassociateTransitGatewayConnectPeerResponse other = (DisassociateTransitGatewayConnectPeerResponse) obj;
        return Objects.equals(transitGatewayConnectPeerAssociation(), other.transitGatewayConnectPeerAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateTransitGatewayConnectPeerResponse")
                .add("TransitGatewayConnectPeerAssociation", transitGatewayConnectPeerAssociation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayConnectPeerAssociation":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTransitGatewayConnectPeerResponse, T> g) {
        return obj -> g.apply((DisassociateTransitGatewayConnectPeerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateTransitGatewayConnectPeerResponse> {
        /**
         * <p>
         * The transit gateway Connect peer association.
         * </p>
         * 
         * @param transitGatewayConnectPeerAssociation
         *        The transit gateway Connect peer association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerAssociation(TransitGatewayConnectPeerAssociation transitGatewayConnectPeerAssociation);

        /**
         * <p>
         * The transit gateway Connect peer association.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayConnectPeerAssociation.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConnectPeerAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayConnectPeerAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayConnectPeerAssociation(TransitGatewayConnectPeerAssociation)}.
         * 
         * @param transitGatewayConnectPeerAssociation
         *        a consumer that will call methods on {@link TransitGatewayConnectPeerAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConnectPeerAssociation(TransitGatewayConnectPeerAssociation)
         */
        default Builder transitGatewayConnectPeerAssociation(
                Consumer<TransitGatewayConnectPeerAssociation.Builder> transitGatewayConnectPeerAssociation) {
            return transitGatewayConnectPeerAssociation(TransitGatewayConnectPeerAssociation.builder()
                    .applyMutation(transitGatewayConnectPeerAssociation).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private TransitGatewayConnectPeerAssociation transitGatewayConnectPeerAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTransitGatewayConnectPeerResponse model) {
            super(model);
            transitGatewayConnectPeerAssociation(model.transitGatewayConnectPeerAssociation);
        }

        public final TransitGatewayConnectPeerAssociation.Builder getTransitGatewayConnectPeerAssociation() {
            return transitGatewayConnectPeerAssociation != null ? transitGatewayConnectPeerAssociation.toBuilder() : null;
        }

        @Override
        public final Builder transitGatewayConnectPeerAssociation(
                TransitGatewayConnectPeerAssociation transitGatewayConnectPeerAssociation) {
            this.transitGatewayConnectPeerAssociation = transitGatewayConnectPeerAssociation;
            return this;
        }

        public final void setTransitGatewayConnectPeerAssociation(
                TransitGatewayConnectPeerAssociation.BuilderImpl transitGatewayConnectPeerAssociation) {
            this.transitGatewayConnectPeerAssociation = transitGatewayConnectPeerAssociation != null ? transitGatewayConnectPeerAssociation
                    .build() : null;
        }

        @Override
        public DisassociateTransitGatewayConnectPeerResponse build() {
            return new DisassociateTransitGatewayConnectPeerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
