/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinksResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetLinksResponse.Builder, GetLinksResponse> {
    private static final SdkField<List<Link>> LINKS_FIELD = SdkField
            .<List<Link>> builder(MarshallingType.LIST)
            .memberName("Links")
            .getter(getter(GetLinksResponse::links))
            .setter(setter(Builder::links))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Link> builder(MarshallingType.SDK_POJO)
                                            .constructor(Link::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetLinksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LINKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Link> links;

    private final String nextToken;

    private GetLinksResponse(BuilderImpl builder) {
        super(builder);
        this.links = builder.links;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Links property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLinks() {
        return links != null && !(links instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The links.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The links.
     */
    public final List<Link> links() {
        return links;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinks() ? links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinksResponse)) {
            return false;
        }
        GetLinksResponse other = (GetLinksResponse) obj;
        return hasLinks() == other.hasLinks() && Objects.equals(links(), other.links())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinksResponse").add("Links", hasLinks() ? links() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Links":
            return Optional.ofNullable(clazz.cast(links()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinksResponse, T> g) {
        return obj -> g.apply((GetLinksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLinksResponse> {
        /**
         * <p>
         * The links.
         * </p>
         * 
         * @param links
         *        The links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Collection<Link> links);

        /**
         * <p>
         * The links.
         * </p>
         * 
         * @param links
         *        The links.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder links(Link... links);

        /**
         * <p>
         * The links.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Link>.Builder} avoiding the need to create
         * one manually via {@link List<Link>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Link>.Builder#build()} is called immediately and its result
         * is passed to {@link #links(List<Link>)}.
         * 
         * @param links
         *        a consumer that will call methods on {@link List<Link>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #links(List<Link>)
         */
        Builder links(Consumer<Link.Builder>... links);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<Link> links = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinksResponse model) {
            super(model);
            links(model.links);
            nextToken(model.nextToken);
        }

        public final Collection<Link.Builder> getLinks() {
            if (links instanceof SdkAutoConstructList) {
                return null;
            }
            return links != null ? links.stream().map(Link::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder links(Collection<Link> links) {
            this.links = LinkListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Link... links) {
            links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<Link.Builder>... links) {
            links(Stream.of(links).map(c -> Link.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLinks(Collection<Link.BuilderImpl> links) {
            this.links = LinkListCopier.copyFromBuilder(links);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetLinksResponse build() {
            return new GetLinksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
