/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route analysis path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAnalysisPath implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteAnalysisPath.Builder, RouteAnalysisPath> {
    private static final SdkField<RouteAnalysisCompletion> COMPLETION_STATUS_FIELD = SdkField
            .<RouteAnalysisCompletion> builder(MarshallingType.SDK_POJO).memberName("CompletionStatus")
            .getter(getter(RouteAnalysisPath::completionStatus)).setter(setter(Builder::completionStatus))
            .constructor(RouteAnalysisCompletion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionStatus").build()).build();

    private static final SdkField<List<PathComponent>> PATH_FIELD = SdkField
            .<List<PathComponent>> builder(MarshallingType.LIST)
            .memberName("Path")
            .getter(getter(RouteAnalysisPath::path))
            .setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PathComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(PathComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_STATUS_FIELD,
            PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final RouteAnalysisCompletion completionStatus;

    private final List<PathComponent> path;

    private RouteAnalysisPath(BuilderImpl builder) {
        this.completionStatus = builder.completionStatus;
        this.path = builder.path;
    }

    /**
     * <p>
     * The status of the analysis at completion.
     * </p>
     * 
     * @return The status of the analysis at completion.
     */
    public final RouteAnalysisCompletion completionStatus() {
        return completionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Path property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPath() {
        return path != null && !(path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The route analysis path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPath} method.
     * </p>
     * 
     * @return The route analysis path.
     */
    public final List<PathComponent> path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasPath() ? path() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisPath)) {
            return false;
        }
        RouteAnalysisPath other = (RouteAnalysisPath) obj;
        return Objects.equals(completionStatus(), other.completionStatus()) && hasPath() == other.hasPath()
                && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAnalysisPath").add("CompletionStatus", completionStatus())
                .add("Path", hasPath() ? path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionStatus":
            return Optional.ofNullable(clazz.cast(completionStatus()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysisPath, T> g) {
        return obj -> g.apply((RouteAnalysisPath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAnalysisPath> {
        /**
         * <p>
         * The status of the analysis at completion.
         * </p>
         * 
         * @param completionStatus
         *        The status of the analysis at completion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionStatus(RouteAnalysisCompletion completionStatus);

        /**
         * <p>
         * The status of the analysis at completion.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteAnalysisCompletion.Builder} avoiding the
         * need to create one manually via {@link RouteAnalysisCompletion#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisCompletion.Builder#build()} is called immediately
         * and its result is passed to {@link #completionStatus(RouteAnalysisCompletion)}.
         * 
         * @param completionStatus
         *        a consumer that will call methods on {@link RouteAnalysisCompletion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionStatus(RouteAnalysisCompletion)
         */
        default Builder completionStatus(Consumer<RouteAnalysisCompletion.Builder> completionStatus) {
            return completionStatus(RouteAnalysisCompletion.builder().applyMutation(completionStatus).build());
        }

        /**
         * <p>
         * The route analysis path.
         * </p>
         * 
         * @param path
         *        The route analysis path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(Collection<PathComponent> path);

        /**
         * <p>
         * The route analysis path.
         * </p>
         * 
         * @param path
         *        The route analysis path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(PathComponent... path);

        /**
         * <p>
         * The route analysis path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PathComponent>.Builder} avoiding the need
         * to create one manually via {@link List<PathComponent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PathComponent>.Builder#build()} is called immediately and
         * its result is passed to {@link #path(List<PathComponent>)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link List<PathComponent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(List<PathComponent>)
         */
        Builder path(Consumer<PathComponent.Builder>... path);
    }

    static final class BuilderImpl implements Builder {
        private RouteAnalysisCompletion completionStatus;

        private List<PathComponent> path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysisPath model) {
            completionStatus(model.completionStatus);
            path(model.path);
        }

        public final RouteAnalysisCompletion.Builder getCompletionStatus() {
            return completionStatus != null ? completionStatus.toBuilder() : null;
        }

        public final void setCompletionStatus(RouteAnalysisCompletion.BuilderImpl completionStatus) {
            this.completionStatus = completionStatus != null ? completionStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder completionStatus(RouteAnalysisCompletion completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        public final List<PathComponent.Builder> getPath() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<PathComponent.BuilderImpl> path) {
            this.path = PathComponentListCopier.copyFromBuilder(path);
        }

        @Override
        @Transient
        public final Builder path(Collection<PathComponent> path) {
            this.path = PathComponentListCopier.copy(path);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder path(PathComponent... path) {
            path(Arrays.asList(path));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder path(Consumer<PathComponent.Builder>... path) {
            path(Stream.of(path).map(c -> PathComponent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteAnalysisPath build() {
            return new RouteAnalysisPath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
