/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdge;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkEdgeListCopier;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegment;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkSegmentListCopier;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkState;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetwork> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(CoreNetwork.getter(CoreNetwork::globalNetworkId)).setter(CoreNetwork.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(CoreNetwork.getter(CoreNetwork::coreNetworkId)).setter(CoreNetwork.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkArn").getter(CoreNetwork.getter(CoreNetwork::coreNetworkArn)).setter(CoreNetwork.setter(Builder::coreNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CoreNetwork.getter(CoreNetwork::description)).setter(CoreNetwork.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CoreNetwork.getter(CoreNetwork::createdAt)).setter(CoreNetwork.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CoreNetwork.getter(CoreNetwork::stateAsString)).setter(CoreNetwork.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<CoreNetworkSegment>> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Segments").getter(CoreNetwork.getter(CoreNetwork::segments)).setter(CoreNetwork.setter(Builder::segments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoreNetworkSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CoreNetworkEdge>> EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Edges").getter(CoreNetwork.getter(CoreNetwork::edges)).setter(CoreNetwork.setter(Builder::edges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoreNetworkEdge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CoreNetwork.getter(CoreNetwork::tags)).setter(CoreNetwork.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, CORE_NETWORK_ID_FIELD, CORE_NETWORK_ARN_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, STATE_FIELD, SEGMENTS_FIELD, EDGES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String globalNetworkId;
    private final String coreNetworkId;
    private final String coreNetworkArn;
    private final String description;
    private final Instant createdAt;
    private final String state;
    private final List<CoreNetworkSegment> segments;
    private final List<CoreNetworkEdge> edges;
    private final List<Tag> tags;

    private CoreNetwork(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.state = builder.state;
        this.segments = builder.segments;
        this.edges = builder.edges;
        this.tags = builder.tags;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final String coreNetworkArn() {
        return this.coreNetworkArn;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final CoreNetworkState state() {
        return CoreNetworkState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasSegments() {
        return this.segments != null && !(this.segments instanceof SdkAutoConstructList);
    }

    public final List<CoreNetworkSegment> segments() {
        return this.segments;
    }

    public final boolean hasEdges() {
        return this.edges != null && !(this.edges instanceof SdkAutoConstructList);
    }

    public final List<CoreNetworkEdge> edges() {
        return this.edges;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegments() ? this.segments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdges() ? this.edges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetwork)) {
            return false;
        }
        CoreNetwork other = (CoreNetwork)obj;
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.coreNetworkArn(), other.coreNetworkArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasSegments() == other.hasSegments() && Objects.equals(this.segments(), other.segments()) && this.hasEdges() == other.hasEdges() && Objects.equals(this.edges(), other.edges()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetwork").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("CoreNetworkId", (Object)this.coreNetworkId()).add("CoreNetworkArn", (Object)this.coreNetworkArn()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("State", (Object)this.stateAsString()).add("Segments", this.hasSegments() ? this.segments() : null).add("Edges", this.hasEdges() ? this.edges() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "CoreNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
            case "Edges": {
                return Optional.ofNullable(clazz.cast(this.edges()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetwork, T> g) {
        return obj -> g.apply((CoreNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private String coreNetworkId;
        private String coreNetworkArn;
        private String description;
        private Instant createdAt;
        private String state;
        private List<CoreNetworkSegment> segments = DefaultSdkAutoConstructList.getInstance();
        private List<CoreNetworkEdge> edges = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetwork model) {
            this.globalNetworkId(model.globalNetworkId);
            this.coreNetworkId(model.coreNetworkId);
            this.coreNetworkArn(model.coreNetworkArn);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.state(model.state);
            this.segments(model.segments);
            this.edges(model.edges);
            this.tags(model.tags);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return this.coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        @Transient
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CoreNetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<CoreNetworkSegment.Builder> getSegments() {
            List<CoreNetworkSegment.Builder> result = CoreNetworkSegmentListCopier.copyToBuilder(this.segments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegments(Collection<CoreNetworkSegment.BuilderImpl> segments) {
            this.segments = CoreNetworkSegmentListCopier.copyFromBuilder(segments);
        }

        @Override
        @Transient
        public final Builder segments(Collection<CoreNetworkSegment> segments) {
            this.segments = CoreNetworkSegmentListCopier.copy(segments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder segments(CoreNetworkSegment ... segments) {
            this.segments(Arrays.asList(segments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder segments(Consumer<CoreNetworkSegment.Builder> ... segments) {
            this.segments(Stream.of(segments).map(c -> (CoreNetworkSegment)((CoreNetworkSegment.Builder)CoreNetworkSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoreNetworkEdge.Builder> getEdges() {
            List<CoreNetworkEdge.Builder> result = CoreNetworkEdgeListCopier.copyToBuilder(this.edges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdges(Collection<CoreNetworkEdge.BuilderImpl> edges) {
            this.edges = CoreNetworkEdgeListCopier.copyFromBuilder(edges);
        }

        @Override
        @Transient
        public final Builder edges(Collection<CoreNetworkEdge> edges) {
            this.edges = CoreNetworkEdgeListCopier.copy(edges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder edges(CoreNetworkEdge ... edges) {
            this.edges(Arrays.asList(edges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder edges(Consumer<CoreNetworkEdge.Builder> ... edges) {
            this.edges(Stream.of(edges).map(c -> (CoreNetworkEdge)((CoreNetworkEdge.Builder)CoreNetworkEdge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CoreNetwork build() {
            return new CoreNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetwork> {
        public Builder globalNetworkId(String var1);

        public Builder coreNetworkId(String var1);

        public Builder coreNetworkArn(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder state(String var1);

        public Builder state(CoreNetworkState var1);

        public Builder segments(Collection<CoreNetworkSegment> var1);

        public Builder segments(CoreNetworkSegment ... var1);

        public Builder segments(Consumer<CoreNetworkSegment.Builder> ... var1);

        public Builder edges(Collection<CoreNetworkEdge> var1);

        public Builder edges(CoreNetworkEdge ... var1);

        public Builder edges(Consumer<CoreNetworkEdge.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

