/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the destination of a network route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkRouteDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkRouteDestination.Builder, NetworkRouteDestination> {
    private static final SdkField<String> CORE_NETWORK_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkAttachmentId").getter(getter(NetworkRouteDestination::coreNetworkAttachmentId))
            .setter(setter(Builder::coreNetworkAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAttachmentId").build())
            .build();

    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAttachmentId")
            .getter(getter(NetworkRouteDestination::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").build())
            .build();

    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(NetworkRouteDestination::segmentName)).setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(NetworkRouteDestination::edgeLocation))
            .setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(NetworkRouteDestination::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(NetworkRouteDestination::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CORE_NETWORK_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, SEGMENT_NAME_FIELD, EDGE_LOCATION_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreNetworkAttachmentId;

    private final String transitGatewayAttachmentId;

    private final String segmentName;

    private final String edgeLocation;

    private final String resourceType;

    private final String resourceId;

    private NetworkRouteDestination(BuilderImpl builder) {
        this.coreNetworkAttachmentId = builder.coreNetworkAttachmentId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.segmentName = builder.segmentName;
        this.edgeLocation = builder.edgeLocation;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The ID of a core network attachment.
     * </p>
     * 
     * @return The ID of a core network attachment.
     */
    public final String coreNetworkAttachmentId() {
        return coreNetworkAttachmentId;
    }

    /**
     * <p>
     * The ID of the transit gateway attachment.
     * </p>
     * 
     * @return The ID of the transit gateway attachment.
     */
    public final String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The name of the segment.
     * </p>
     * 
     * @return The name of the segment.
     */
    public final String segmentName() {
        return segmentName;
    }

    /**
     * <p>
     * The edge location for the network destination.
     * </p>
     * 
     * @return The edge location for the network destination.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkRouteDestination)) {
            return false;
        }
        NetworkRouteDestination other = (NetworkRouteDestination) obj;
        return Objects.equals(coreNetworkAttachmentId(), other.coreNetworkAttachmentId())
                && Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(segmentName(), other.segmentName()) && Objects.equals(edgeLocation(), other.edgeLocation())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkRouteDestination").add("CoreNetworkAttachmentId", coreNetworkAttachmentId())
                .add("TransitGatewayAttachmentId", transitGatewayAttachmentId()).add("SegmentName", segmentName())
                .add("EdgeLocation", edgeLocation()).add("ResourceType", resourceType()).add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkAttachmentId":
            return Optional.ofNullable(clazz.cast(coreNetworkAttachmentId()));
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkRouteDestination, T> g) {
        return obj -> g.apply((NetworkRouteDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkRouteDestination> {
        /**
         * <p>
         * The ID of a core network attachment.
         * </p>
         * 
         * @param coreNetworkAttachmentId
         *        The ID of a core network attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkAttachmentId(String coreNetworkAttachmentId);

        /**
         * <p>
         * The ID of the transit gateway attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the transit gateway attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The name of the segment.
         * </p>
         * 
         * @param segmentName
         *        The name of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);

        /**
         * <p>
         * The edge location for the network destination.
         * </p>
         * 
         * @param edgeLocation
         *        The edge location for the network destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkAttachmentId;

        private String transitGatewayAttachmentId;

        private String segmentName;

        private String edgeLocation;

        private String resourceType;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkRouteDestination model) {
            coreNetworkAttachmentId(model.coreNetworkAttachmentId);
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            segmentName(model.segmentName);
            edgeLocation(model.edgeLocation);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
        }

        public final String getCoreNetworkAttachmentId() {
            return coreNetworkAttachmentId;
        }

        public final void setCoreNetworkAttachmentId(String coreNetworkAttachmentId) {
            this.coreNetworkAttachmentId = coreNetworkAttachmentId;
        }

        @Override
        @Transient
        public final Builder coreNetworkAttachmentId(String coreNetworkAttachmentId) {
            this.coreNetworkAttachmentId = coreNetworkAttachmentId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        @Transient
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        @Transient
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public NetworkRouteDestination build() {
            return new NetworkRouteDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
