/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectPeersResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<ListConnectPeersResponse.Builder, ListConnectPeersResponse> {
    private static final SdkField<List<ConnectPeerSummary>> CONNECT_PEERS_FIELD = SdkField
            .<List<ConnectPeerSummary>> builder(MarshallingType.LIST)
            .memberName("ConnectPeers")
            .getter(getter(ListConnectPeersResponse::connectPeers))
            .setter(setter(Builder::connectPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConnectPeerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectPeerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectPeersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_PEERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConnectPeerSummary> connectPeers;

    private final String nextToken;

    private ListConnectPeersResponse(BuilderImpl builder) {
        super(builder);
        this.connectPeers = builder.connectPeers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectPeers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectPeers() {
        return connectPeers != null && !(connectPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the Connect peers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectPeers} method.
     * </p>
     * 
     * @return Describes the Connect peers.
     */
    public final List<ConnectPeerSummary> connectPeers() {
        return connectPeers;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectPeers() ? connectPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectPeersResponse)) {
            return false;
        }
        ListConnectPeersResponse other = (ListConnectPeersResponse) obj;
        return hasConnectPeers() == other.hasConnectPeers() && Objects.equals(connectPeers(), other.connectPeers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectPeersResponse").add("ConnectPeers", hasConnectPeers() ? connectPeers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectPeers":
            return Optional.ofNullable(clazz.cast(connectPeers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectPeersResponse, T> g) {
        return obj -> g.apply((ListConnectPeersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectPeersResponse> {
        /**
         * <p>
         * Describes the Connect peers.
         * </p>
         * 
         * @param connectPeers
         *        Describes the Connect peers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeers(Collection<ConnectPeerSummary> connectPeers);

        /**
         * <p>
         * Describes the Connect peers.
         * </p>
         * 
         * @param connectPeers
         *        Describes the Connect peers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectPeers(ConnectPeerSummary... connectPeers);

        /**
         * <p>
         * Describes the Connect peers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConnectPeerSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ConnectPeerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectPeerSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #connectPeers(List<ConnectPeerSummary>)}.
         * 
         * @param connectPeers
         *        a consumer that will call methods on {@link List<ConnectPeerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectPeers(List<ConnectPeerSummary>)
         */
        Builder connectPeers(Consumer<ConnectPeerSummary.Builder>... connectPeers);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<ConnectPeerSummary> connectPeers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectPeersResponse model) {
            super(model);
            connectPeers(model.connectPeers);
            nextToken(model.nextToken);
        }

        public final List<ConnectPeerSummary.Builder> getConnectPeers() {
            List<ConnectPeerSummary.Builder> result = ConnectPeerSummaryListCopier.copyToBuilder(this.connectPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectPeers(Collection<ConnectPeerSummary.BuilderImpl> connectPeers) {
            this.connectPeers = ConnectPeerSummaryListCopier.copyFromBuilder(connectPeers);
        }

        @Override
        @Transient
        public final Builder connectPeers(Collection<ConnectPeerSummary> connectPeers) {
            this.connectPeers = ConnectPeerSummaryListCopier.copy(connectPeers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectPeers(ConnectPeerSummary... connectPeers) {
            connectPeers(Arrays.asList(connectPeers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectPeers(Consumer<ConnectPeerSummary.Builder>... connectPeers) {
            connectPeers(Stream.of(connectPeers).map(c -> ConnectPeerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectPeersResponse build() {
            return new ListConnectPeersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
