/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLinkResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<UpdateLinkResponse.Builder, UpdateLinkResponse> {
    private static final SdkField<Link> LINK_FIELD = SdkField.<Link> builder(MarshallingType.SDK_POJO).memberName("Link")
            .getter(getter(UpdateLinkResponse::link)).setter(setter(Builder::link)).constructor(Link::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_FIELD));

    private final Link link;

    private UpdateLinkResponse(BuilderImpl builder) {
        super(builder);
        this.link = builder.link;
    }

    /**
     * <p>
     * Information about the link.
     * </p>
     * 
     * @return Information about the link.
     */
    public final Link link() {
        return link;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(link());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkResponse)) {
            return false;
        }
        UpdateLinkResponse other = (UpdateLinkResponse) obj;
        return Objects.equals(link(), other.link());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLinkResponse").add("Link", link()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Link":
            return Optional.ofNullable(clazz.cast(link()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLinkResponse, T> g) {
        return obj -> g.apply((UpdateLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLinkResponse> {
        /**
         * <p>
         * Information about the link.
         * </p>
         * 
         * @param link
         *        Information about the link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(Link link);

        /**
         * <p>
         * Information about the link.
         * </p>
         * This is a convenience that creates an instance of the {@link Link.Builder} avoiding the need to create one
         * manually via {@link Link#builder()}.
         *
         * When the {@link Consumer} completes, {@link Link.Builder#build()} is called immediately and its result is
         * passed to {@link #link(Link)}.
         * 
         * @param link
         *        a consumer that will call methods on {@link Link.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #link(Link)
         */
        default Builder link(Consumer<Link.Builder> link) {
            return link(Link.builder().applyMutation(link).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private Link link;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLinkResponse model) {
            super(model);
            link(model.link);
        }

        public final Link.Builder getLink() {
            return link != null ? link.toBuilder() : null;
        }

        public final void setLink(Link.BuilderImpl link) {
            this.link = link != null ? link.build() : null;
        }

        @Override
        @Transient
        public final Builder link(Link link) {
            this.link = link;
            return this;
        }

        @Override
        public UpdateLinkResponse build() {
            return new UpdateLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
