/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<CreateConnectAttachmentResponse.Builder, CreateConnectAttachmentResponse> {
    private static final SdkField<ConnectAttachment> CONNECT_ATTACHMENT_FIELD = SdkField
            .<ConnectAttachment> builder(MarshallingType.SDK_POJO).memberName("ConnectAttachment")
            .getter(getter(CreateConnectAttachmentResponse::connectAttachment)).setter(setter(Builder::connectAttachment))
            .constructor(ConnectAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_ATTACHMENT_FIELD));

    private final ConnectAttachment connectAttachment;

    private CreateConnectAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.connectAttachment = builder.connectAttachment;
    }

    /**
     * <p>
     * The response to a Connect attachment request.
     * </p>
     * 
     * @return The response to a Connect attachment request.
     */
    public final ConnectAttachment connectAttachment() {
        return connectAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectAttachmentResponse)) {
            return false;
        }
        CreateConnectAttachmentResponse other = (CreateConnectAttachmentResponse) obj;
        return Objects.equals(connectAttachment(), other.connectAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectAttachmentResponse").add("ConnectAttachment", connectAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectAttachment":
            return Optional.ofNullable(clazz.cast(connectAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectAttachmentResponse, T> g) {
        return obj -> g.apply((CreateConnectAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConnectAttachmentResponse> {
        /**
         * <p>
         * The response to a Connect attachment request.
         * </p>
         * 
         * @param connectAttachment
         *        The response to a Connect attachment request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectAttachment(ConnectAttachment connectAttachment);

        /**
         * <p>
         * The response to a Connect attachment request.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectAttachment.Builder} avoiding the need to
         * create one manually via {@link ConnectAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectAttachment.Builder#build()} is called immediately and its
         * result is passed to {@link #connectAttachment(ConnectAttachment)}.
         * 
         * @param connectAttachment
         *        a consumer that will call methods on {@link ConnectAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectAttachment(ConnectAttachment)
         */
        default Builder connectAttachment(Consumer<ConnectAttachment.Builder> connectAttachment) {
            return connectAttachment(ConnectAttachment.builder().applyMutation(connectAttachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private ConnectAttachment connectAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectAttachmentResponse model) {
            super(model);
            connectAttachment(model.connectAttachment);
        }

        public final ConnectAttachment.Builder getConnectAttachment() {
            return connectAttachment != null ? connectAttachment.toBuilder() : null;
        }

        public final void setConnectAttachment(ConnectAttachment.BuilderImpl connectAttachment) {
            this.connectAttachment = connectAttachment != null ? connectAttachment.build() : null;
        }

        @Override
        @Transient
        public final Builder connectAttachment(ConnectAttachment connectAttachment) {
            this.connectAttachment = connectAttachment;
            return this;
        }

        @Override
        public CreateConnectAttachmentResponse build() {
            return new CreateConnectAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
