/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAnalysis implements SdkPojo, Serializable, ToCopyableBuilder<RouteAnalysis.Builder, RouteAnalysis> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(RouteAnalysis::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(RouteAnalysis::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> ROUTE_ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteAnalysisId").getter(getter(RouteAnalysis::routeAnalysisId))
            .setter(setter(Builder::routeAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteAnalysisId").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(RouteAnalysis::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RouteAnalysis::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<RouteAnalysisEndpointOptions> SOURCE_FIELD = SdkField
            .<RouteAnalysisEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(RouteAnalysis::source)).setter(setter(Builder::source))
            .constructor(RouteAnalysisEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<RouteAnalysisEndpointOptions> DESTINATION_FIELD = SdkField
            .<RouteAnalysisEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(RouteAnalysis::destination)).setter(setter(Builder::destination))
            .constructor(RouteAnalysisEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<Boolean> INCLUDE_RETURN_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeReturnPath").getter(getter(RouteAnalysis::includeReturnPath))
            .setter(setter(Builder::includeReturnPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeReturnPath").build()).build();

    private static final SdkField<Boolean> USE_MIDDLEBOXES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseMiddleboxes").getter(getter(RouteAnalysis::useMiddleboxes)).setter(setter(Builder::useMiddleboxes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseMiddleboxes").build()).build();

    private static final SdkField<RouteAnalysisPath> FORWARD_PATH_FIELD = SdkField
            .<RouteAnalysisPath> builder(MarshallingType.SDK_POJO).memberName("ForwardPath")
            .getter(getter(RouteAnalysis::forwardPath)).setter(setter(Builder::forwardPath))
            .constructor(RouteAnalysisPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardPath").build()).build();

    private static final SdkField<RouteAnalysisPath> RETURN_PATH_FIELD = SdkField
            .<RouteAnalysisPath> builder(MarshallingType.SDK_POJO).memberName("ReturnPath")
            .getter(getter(RouteAnalysis::returnPath)).setter(setter(Builder::returnPath))
            .constructor(RouteAnalysisPath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            OWNER_ACCOUNT_ID_FIELD, ROUTE_ANALYSIS_ID_FIELD, START_TIMESTAMP_FIELD, STATUS_FIELD, SOURCE_FIELD,
            DESTINATION_FIELD, INCLUDE_RETURN_PATH_FIELD, USE_MIDDLEBOXES_FIELD, FORWARD_PATH_FIELD, RETURN_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String globalNetworkId;

    private final String ownerAccountId;

    private final String routeAnalysisId;

    private final Instant startTimestamp;

    private final String status;

    private final RouteAnalysisEndpointOptions source;

    private final RouteAnalysisEndpointOptions destination;

    private final Boolean includeReturnPath;

    private final Boolean useMiddleboxes;

    private final RouteAnalysisPath forwardPath;

    private final RouteAnalysisPath returnPath;

    private RouteAnalysis(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.ownerAccountId = builder.ownerAccountId;
        this.routeAnalysisId = builder.routeAnalysisId;
        this.startTimestamp = builder.startTimestamp;
        this.status = builder.status;
        this.source = builder.source;
        this.destination = builder.destination;
        this.includeReturnPath = builder.includeReturnPath;
        this.useMiddleboxes = builder.useMiddleboxes;
        this.forwardPath = builder.forwardPath;
        this.returnPath = builder.returnPath;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the AWS account that created the route analysis.
     * </p>
     * 
     * @return The ID of the AWS account that created the route analysis.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The ID of the route analysis.
     * </p>
     * 
     * @return The ID of the route analysis.
     */
    public final String routeAnalysisId() {
        return routeAnalysisId;
    }

    /**
     * <p>
     * The time that the analysis started.
     * </p>
     * 
     * @return The time that the analysis started.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The status of the route analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RouteAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the route analysis.
     * @see RouteAnalysisStatus
     */
    public final RouteAnalysisStatus status() {
        return RouteAnalysisStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the route analysis.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RouteAnalysisStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the route analysis.
     * @see RouteAnalysisStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The source.
     * </p>
     * 
     * @return The source.
     */
    public final RouteAnalysisEndpointOptions source() {
        return source;
    }

    /**
     * <p>
     * The destination.
     * </p>
     * 
     * @return The destination.
     */
    public final RouteAnalysisEndpointOptions destination() {
        return destination;
    }

    /**
     * <p>
     * Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis does
     * not succeed.
     * </p>
     * 
     * @return Indicates whether to analyze the return path. The return path is not analyzed if the forward path
     *         analysis does not succeed.
     */
    public final Boolean includeReturnPath() {
        return includeReturnPath;
    }

    /**
     * <p>
     * Indicates whether to include the location of middlebox appliances in the route analysis.
     * </p>
     * 
     * @return Indicates whether to include the location of middlebox appliances in the route analysis.
     */
    public final Boolean useMiddleboxes() {
        return useMiddleboxes;
    }

    /**
     * <p>
     * The forward path.
     * </p>
     * 
     * @return The forward path.
     */
    public final RouteAnalysisPath forwardPath() {
        return forwardPath;
    }

    /**
     * <p>
     * The return path.
     * </p>
     * 
     * @return The return path.
     */
    public final RouteAnalysisPath returnPath() {
        return returnPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(routeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(includeReturnPath());
        hashCode = 31 * hashCode + Objects.hashCode(useMiddleboxes());
        hashCode = 31 * hashCode + Objects.hashCode(forwardPath());
        hashCode = 31 * hashCode + Objects.hashCode(returnPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysis)) {
            return false;
        }
        RouteAnalysis other = (RouteAnalysis) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(routeAnalysisId(), other.routeAnalysisId())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(includeReturnPath(), other.includeReturnPath())
                && Objects.equals(useMiddleboxes(), other.useMiddleboxes()) && Objects.equals(forwardPath(), other.forwardPath())
                && Objects.equals(returnPath(), other.returnPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAnalysis").add("GlobalNetworkId", globalNetworkId())
                .add("OwnerAccountId", ownerAccountId()).add("RouteAnalysisId", routeAnalysisId())
                .add("StartTimestamp", startTimestamp()).add("Status", statusAsString()).add("Source", source())
                .add("Destination", destination()).add("IncludeReturnPath", includeReturnPath())
                .add("UseMiddleboxes", useMiddleboxes()).add("ForwardPath", forwardPath()).add("ReturnPath", returnPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "RouteAnalysisId":
            return Optional.ofNullable(clazz.cast(routeAnalysisId()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "IncludeReturnPath":
            return Optional.ofNullable(clazz.cast(includeReturnPath()));
        case "UseMiddleboxes":
            return Optional.ofNullable(clazz.cast(useMiddleboxes()));
        case "ForwardPath":
            return Optional.ofNullable(clazz.cast(forwardPath()));
        case "ReturnPath":
            return Optional.ofNullable(clazz.cast(returnPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysis, T> g) {
        return obj -> g.apply((RouteAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAnalysis> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the AWS account that created the route analysis.
         * </p>
         * 
         * @param ownerAccountId
         *        The ID of the AWS account that created the route analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The ID of the route analysis.
         * </p>
         * 
         * @param routeAnalysisId
         *        The ID of the route analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeAnalysisId(String routeAnalysisId);

        /**
         * <p>
         * The time that the analysis started.
         * </p>
         * 
         * @param startTimestamp
         *        The time that the analysis started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The status of the route analysis.
         * </p>
         * 
         * @param status
         *        The status of the route analysis.
         * @see RouteAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the route analysis.
         * </p>
         * 
         * @param status
         *        The status of the route analysis.
         * @see RouteAnalysisStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteAnalysisStatus
         */
        Builder status(RouteAnalysisStatus status);

        /**
         * <p>
         * The source.
         * </p>
         * 
         * @param source
         *        The source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(RouteAnalysisEndpointOptions source);

        /**
         * <p>
         * The source.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteAnalysisEndpointOptions.Builder} avoiding
         * the need to create one manually via {@link RouteAnalysisEndpointOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisEndpointOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #source(RouteAnalysisEndpointOptions)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link RouteAnalysisEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(RouteAnalysisEndpointOptions)
         */
        default Builder source(Consumer<RouteAnalysisEndpointOptions.Builder> source) {
            return source(RouteAnalysisEndpointOptions.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The destination.
         * </p>
         * 
         * @param destination
         *        The destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(RouteAnalysisEndpointOptions destination);

        /**
         * <p>
         * The destination.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteAnalysisEndpointOptions.Builder} avoiding
         * the need to create one manually via {@link RouteAnalysisEndpointOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisEndpointOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #destination(RouteAnalysisEndpointOptions)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link RouteAnalysisEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(RouteAnalysisEndpointOptions)
         */
        default Builder destination(Consumer<RouteAnalysisEndpointOptions.Builder> destination) {
            return destination(RouteAnalysisEndpointOptions.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Indicates whether to analyze the return path. The return path is not analyzed if the forward path analysis
         * does not succeed.
         * </p>
         * 
         * @param includeReturnPath
         *        Indicates whether to analyze the return path. The return path is not analyzed if the forward path
         *        analysis does not succeed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeReturnPath(Boolean includeReturnPath);

        /**
         * <p>
         * Indicates whether to include the location of middlebox appliances in the route analysis.
         * </p>
         * 
         * @param useMiddleboxes
         *        Indicates whether to include the location of middlebox appliances in the route analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useMiddleboxes(Boolean useMiddleboxes);

        /**
         * <p>
         * The forward path.
         * </p>
         * 
         * @param forwardPath
         *        The forward path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardPath(RouteAnalysisPath forwardPath);

        /**
         * <p>
         * The forward path.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteAnalysisPath.Builder} avoiding the need to
         * create one manually via {@link RouteAnalysisPath#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisPath.Builder#build()} is called immediately and its
         * result is passed to {@link #forwardPath(RouteAnalysisPath)}.
         * 
         * @param forwardPath
         *        a consumer that will call methods on {@link RouteAnalysisPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardPath(RouteAnalysisPath)
         */
        default Builder forwardPath(Consumer<RouteAnalysisPath.Builder> forwardPath) {
            return forwardPath(RouteAnalysisPath.builder().applyMutation(forwardPath).build());
        }

        /**
         * <p>
         * The return path.
         * </p>
         * 
         * @param returnPath
         *        The return path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnPath(RouteAnalysisPath returnPath);

        /**
         * <p>
         * The return path.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteAnalysisPath.Builder} avoiding the need to
         * create one manually via {@link RouteAnalysisPath#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisPath.Builder#build()} is called immediately and its
         * result is passed to {@link #returnPath(RouteAnalysisPath)}.
         * 
         * @param returnPath
         *        a consumer that will call methods on {@link RouteAnalysisPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnPath(RouteAnalysisPath)
         */
        default Builder returnPath(Consumer<RouteAnalysisPath.Builder> returnPath) {
            return returnPath(RouteAnalysisPath.builder().applyMutation(returnPath).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String globalNetworkId;

        private String ownerAccountId;

        private String routeAnalysisId;

        private Instant startTimestamp;

        private String status;

        private RouteAnalysisEndpointOptions source;

        private RouteAnalysisEndpointOptions destination;

        private Boolean includeReturnPath;

        private Boolean useMiddleboxes;

        private RouteAnalysisPath forwardPath;

        private RouteAnalysisPath returnPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysis model) {
            globalNetworkId(model.globalNetworkId);
            ownerAccountId(model.ownerAccountId);
            routeAnalysisId(model.routeAnalysisId);
            startTimestamp(model.startTimestamp);
            status(model.status);
            source(model.source);
            destination(model.destination);
            includeReturnPath(model.includeReturnPath);
            useMiddleboxes(model.useMiddleboxes);
            forwardPath(model.forwardPath);
            returnPath(model.returnPath);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getRouteAnalysisId() {
            return routeAnalysisId;
        }

        public final void setRouteAnalysisId(String routeAnalysisId) {
            this.routeAnalysisId = routeAnalysisId;
        }

        @Override
        @Transient
        public final Builder routeAnalysisId(String routeAnalysisId) {
            this.routeAnalysisId = routeAnalysisId;
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        @Transient
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RouteAnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RouteAnalysisEndpointOptions.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(RouteAnalysisEndpointOptions.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(RouteAnalysisEndpointOptions source) {
            this.source = source;
            return this;
        }

        public final RouteAnalysisEndpointOptions.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(RouteAnalysisEndpointOptions.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(RouteAnalysisEndpointOptions destination) {
            this.destination = destination;
            return this;
        }

        public final Boolean getIncludeReturnPath() {
            return includeReturnPath;
        }

        public final void setIncludeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
        }

        @Override
        @Transient
        public final Builder includeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
            return this;
        }

        public final Boolean getUseMiddleboxes() {
            return useMiddleboxes;
        }

        public final void setUseMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
        }

        @Override
        @Transient
        public final Builder useMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
            return this;
        }

        public final RouteAnalysisPath.Builder getForwardPath() {
            return forwardPath != null ? forwardPath.toBuilder() : null;
        }

        public final void setForwardPath(RouteAnalysisPath.BuilderImpl forwardPath) {
            this.forwardPath = forwardPath != null ? forwardPath.build() : null;
        }

        @Override
        @Transient
        public final Builder forwardPath(RouteAnalysisPath forwardPath) {
            this.forwardPath = forwardPath;
            return this;
        }

        public final RouteAnalysisPath.Builder getReturnPath() {
            return returnPath != null ? returnPath.toBuilder() : null;
        }

        public final void setReturnPath(RouteAnalysisPath.BuilderImpl returnPath) {
            this.returnPath = returnPath != null ? returnPath.build() : null;
        }

        @Override
        @Transient
        public final Builder returnPath(RouteAnalysisPath returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        @Override
        public RouteAnalysis build() {
            return new RouteAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
