/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLinksRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<GetLinksRequest.Builder, GetLinksRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(GetLinksRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<List<String>> LINK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkIds")
            .getter(getter(GetLinksRequest::linkIds))
            .setter(setter(Builder::linkIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("linkIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(GetLinksRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("siteId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetLinksRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Provider").getter(getter(GetLinksRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("provider").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetLinksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetLinksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            LINK_IDS_FIELD, SITE_ID_FIELD, TYPE_FIELD, PROVIDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String globalNetworkId;

    private final List<String> linkIds;

    private final String siteId;

    private final String type;

    private final String provider;

    private final Integer maxResults;

    private final String nextToken;

    private GetLinksRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.linkIds = builder.linkIds;
        this.siteId = builder.siteId;
        this.type = builder.type;
        this.provider = builder.provider;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLinkIds() {
        return linkIds != null && !(linkIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more link IDs. The maximum is 10.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkIds} method.
     * </p>
     * 
     * @return One or more link IDs. The maximum is 10.
     */
    public final List<String> linkIds() {
        return linkIds;
    }

    /**
     * <p>
     * The ID of the site.
     * </p>
     * 
     * @return The ID of the site.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * <p>
     * The link type.
     * </p>
     * 
     * @return The link type.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The link provider.
     * </p>
     * 
     * @return The link provider.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkIds() ? linkIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLinksRequest)) {
            return false;
        }
        GetLinksRequest other = (GetLinksRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && hasLinkIds() == other.hasLinkIds()
                && Objects.equals(linkIds(), other.linkIds()) && Objects.equals(siteId(), other.siteId())
                && Objects.equals(type(), other.type()) && Objects.equals(provider(), other.provider())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLinksRequest").add("GlobalNetworkId", globalNetworkId())
                .add("LinkIds", hasLinkIds() ? linkIds() : null).add("SiteId", siteId()).add("Type", type())
                .add("Provider", provider()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "LinkIds":
            return Optional.ofNullable(clazz.cast(linkIds()));
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLinksRequest, T> g) {
        return obj -> g.apply((GetLinksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLinksRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * One or more link IDs. The maximum is 10.
         * </p>
         * 
         * @param linkIds
         *        One or more link IDs. The maximum is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkIds(Collection<String> linkIds);

        /**
         * <p>
         * One or more link IDs. The maximum is 10.
         * </p>
         * 
         * @param linkIds
         *        One or more link IDs. The maximum is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkIds(String... linkIds);

        /**
         * <p>
         * The ID of the site.
         * </p>
         * 
         * @param siteId
         *        The ID of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * <p>
         * The link type.
         * </p>
         * 
         * @param type
         *        The link type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The link provider.
         * </p>
         * 
         * @param provider
         *        The link provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private List<String> linkIds = DefaultSdkAutoConstructList.getInstance();

        private String siteId;

        private String type;

        private String provider;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLinksRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            linkIds(model.linkIds);
            siteId(model.siteId);
            type(model.type);
            provider(model.provider);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final Collection<String> getLinkIds() {
            if (linkIds instanceof SdkAutoConstructList) {
                return null;
            }
            return linkIds;
        }

        public final void setLinkIds(Collection<String> linkIds) {
            this.linkIds = LinkIdListCopier.copy(linkIds);
        }

        @Override
        @Transient
        public final Builder linkIds(Collection<String> linkIds) {
            this.linkIds = LinkIdListCopier.copy(linkIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder linkIds(String... linkIds) {
            linkIds(Arrays.asList(linkIds));
            return this;
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        @Transient
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLinksRequest build() {
            return new GetLinksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
