/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTransitGatewayResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<RegisterTransitGatewayResponse.Builder, RegisterTransitGatewayResponse> {
    private static final SdkField<TransitGatewayRegistration> TRANSIT_GATEWAY_REGISTRATION_FIELD = SdkField
            .<TransitGatewayRegistration> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayRegistration")
            .getter(getter(RegisterTransitGatewayResponse::transitGatewayRegistration))
            .setter(setter(Builder::transitGatewayRegistration))
            .constructor(TransitGatewayRegistration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRegistration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_REGISTRATION_FIELD));

    private final TransitGatewayRegistration transitGatewayRegistration;

    private RegisterTransitGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRegistration = builder.transitGatewayRegistration;
    }

    /**
     * <p>
     * Information about the transit gateway registration.
     * </p>
     * 
     * @return Information about the transit gateway registration.
     */
    public final TransitGatewayRegistration transitGatewayRegistration() {
        return transitGatewayRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRegistration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTransitGatewayResponse)) {
            return false;
        }
        RegisterTransitGatewayResponse other = (RegisterTransitGatewayResponse) obj;
        return Objects.equals(transitGatewayRegistration(), other.transitGatewayRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTransitGatewayResponse").add("TransitGatewayRegistration", transitGatewayRegistration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRegistration":
            return Optional.ofNullable(clazz.cast(transitGatewayRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTransitGatewayResponse, T> g) {
        return obj -> g.apply((RegisterTransitGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterTransitGatewayResponse> {
        /**
         * <p>
         * Information about the transit gateway registration.
         * </p>
         * 
         * @param transitGatewayRegistration
         *        Information about the transit gateway registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRegistration(TransitGatewayRegistration transitGatewayRegistration);

        /**
         * <p>
         * Information about the transit gateway registration.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayRegistration.Builder} avoiding the
         * need to create one manually via {@link TransitGatewayRegistration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayRegistration.Builder#build()} is called immediately
         * and its result is passed to {@link #transitGatewayRegistration(TransitGatewayRegistration)}.
         * 
         * @param transitGatewayRegistration
         *        a consumer that will call methods on {@link TransitGatewayRegistration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayRegistration(TransitGatewayRegistration)
         */
        default Builder transitGatewayRegistration(Consumer<TransitGatewayRegistration.Builder> transitGatewayRegistration) {
            return transitGatewayRegistration(TransitGatewayRegistration.builder().applyMutation(transitGatewayRegistration)
                    .build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private TransitGatewayRegistration transitGatewayRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTransitGatewayResponse model) {
            super(model);
            transitGatewayRegistration(model.transitGatewayRegistration);
        }

        public final TransitGatewayRegistration.Builder getTransitGatewayRegistration() {
            return transitGatewayRegistration != null ? transitGatewayRegistration.toBuilder() : null;
        }

        public final void setTransitGatewayRegistration(TransitGatewayRegistration.BuilderImpl transitGatewayRegistration) {
            this.transitGatewayRegistration = transitGatewayRegistration != null ? transitGatewayRegistration.build() : null;
        }

        @Override
        @Transient
        public final Builder transitGatewayRegistration(TransitGatewayRegistration transitGatewayRegistration) {
            this.transitGatewayRegistration = transitGatewayRegistration;
            return this;
        }

        @Override
        public RegisterTransitGatewayResponse build() {
            return new RegisterTransitGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
