/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachment implements SdkPojo, Serializable, ToCopyableBuilder<Attachment.Builder, Attachment> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(Attachment::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkArn").getter(getter(Attachment::coreNetworkArn)).setter(setter(Builder::coreNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkArn").build()).build();

    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(Attachment::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(Attachment::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> ATTACHMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentType").getter(getter(Attachment::attachmentTypeAsString))
            .setter(setter(Builder::attachmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentType").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Attachment::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeLocation").getter(getter(Attachment::edgeLocation)).setter(setter(Builder::edgeLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(Attachment::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Integer> ATTACHMENT_POLICY_RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AttachmentPolicyRuleNumber")
            .getter(getter(Attachment::attachmentPolicyRuleNumber))
            .setter(setter(Builder::attachmentPolicyRuleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentPolicyRuleNumber").build())
            .build();

    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(Attachment::segmentName)).setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Attachment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProposedSegmentChange> PROPOSED_SEGMENT_CHANGE_FIELD = SdkField
            .<ProposedSegmentChange> builder(MarshallingType.SDK_POJO).memberName("ProposedSegmentChange")
            .getter(getter(Attachment::proposedSegmentChange)).setter(setter(Builder::proposedSegmentChange))
            .constructor(ProposedSegmentChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedSegmentChange").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Attachment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(Attachment::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            CORE_NETWORK_ARN_FIELD, ATTACHMENT_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, ATTACHMENT_TYPE_FIELD, STATE_FIELD,
            EDGE_LOCATION_FIELD, RESOURCE_ARN_FIELD, ATTACHMENT_POLICY_RULE_NUMBER_FIELD, SEGMENT_NAME_FIELD, TAGS_FIELD,
            PROPOSED_SEGMENT_CHANGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final String coreNetworkArn;

    private final String attachmentId;

    private final String ownerAccountId;

    private final String attachmentType;

    private final String state;

    private final String edgeLocation;

    private final String resourceArn;

    private final Integer attachmentPolicyRuleNumber;

    private final String segmentName;

    private final List<Tag> tags;

    private final ProposedSegmentChange proposedSegmentChange;

    private final Instant createdAt;

    private final Instant updatedAt;

    private Attachment(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.coreNetworkArn = builder.coreNetworkArn;
        this.attachmentId = builder.attachmentId;
        this.ownerAccountId = builder.ownerAccountId;
        this.attachmentType = builder.attachmentType;
        this.state = builder.state;
        this.edgeLocation = builder.edgeLocation;
        this.resourceArn = builder.resourceArn;
        this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
        this.segmentName = builder.segmentName;
        this.tags = builder.tags;
        this.proposedSegmentChange = builder.proposedSegmentChange;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * A core network ID.
     * </p>
     * 
     * @return A core network ID.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of a core network.
     * </p>
     * 
     * @return The ARN of a core network.
     */
    public final String coreNetworkArn() {
        return coreNetworkArn;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The ID of the attachment account owner.
     * </p>
     * 
     * @return The ID of the attachment account owner.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The type of attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentType}
     * will return {@link AttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentTypeAsString}.
     * </p>
     * 
     * @return The type of attachment.
     * @see AttachmentType
     */
    public final AttachmentType attachmentType() {
        return AttachmentType.fromValue(attachmentType);
    }

    /**
     * <p>
     * The type of attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentType}
     * will return {@link AttachmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attachmentTypeAsString}.
     * </p>
     * 
     * @return The type of attachment.
     * @see AttachmentType
     */
    public final String attachmentTypeAsString() {
        return attachmentType;
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see AttachmentState
     */
    public final AttachmentState state() {
        return AttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the attachment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the attachment.
     * @see AttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The Region where the edge is located.
     * </p>
     * 
     * @return The Region where the edge is located.
     */
    public final String edgeLocation() {
        return edgeLocation;
    }

    /**
     * <p>
     * The attachment resource ARN.
     * </p>
     * 
     * @return The attachment resource ARN.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The policy rule number associated with the attachment.
     * </p>
     * 
     * @return The policy rule number associated with the attachment.
     */
    public final Integer attachmentPolicyRuleNumber() {
        return attachmentPolicyRuleNumber;
    }

    /**
     * <p>
     * The name of the segment attachment.
     * </p>
     * 
     * @return The name of the segment attachment.
     */
    public final String segmentName() {
        return segmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the attachment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The attachment to move from one segment to another.
     * </p>
     * 
     * @return The attachment to move from one segment to another.
     */
    public final ProposedSegmentChange proposedSegmentChange() {
        return proposedSegmentChange;
    }

    /**
     * <p>
     * The timestamp when the attachment was created.
     * </p>
     * 
     * @return The timestamp when the attachment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the attachment was last updated.
     * </p>
     * 
     * @return The timestamp when the attachment was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentPolicyRuleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(proposedSegmentChange());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(coreNetworkArn(), other.coreNetworkArn())
                && Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(attachmentTypeAsString(), other.attachmentTypeAsString())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(edgeLocation(), other.edgeLocation())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(attachmentPolicyRuleNumber(), other.attachmentPolicyRuleNumber())
                && Objects.equals(segmentName(), other.segmentName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(proposedSegmentChange(), other.proposedSegmentChange())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachment").add("CoreNetworkId", coreNetworkId()).add("CoreNetworkArn", coreNetworkArn())
                .add("AttachmentId", attachmentId()).add("OwnerAccountId", ownerAccountId())
                .add("AttachmentType", attachmentTypeAsString()).add("State", stateAsString())
                .add("EdgeLocation", edgeLocation()).add("ResourceArn", resourceArn())
                .add("AttachmentPolicyRuleNumber", attachmentPolicyRuleNumber()).add("SegmentName", segmentName())
                .add("Tags", hasTags() ? tags() : null).add("ProposedSegmentChange", proposedSegmentChange())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "CoreNetworkArn":
            return Optional.ofNullable(clazz.cast(coreNetworkArn()));
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "AttachmentType":
            return Optional.ofNullable(clazz.cast(attachmentTypeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EdgeLocation":
            return Optional.ofNullable(clazz.cast(edgeLocation()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "AttachmentPolicyRuleNumber":
            return Optional.ofNullable(clazz.cast(attachmentPolicyRuleNumber()));
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ProposedSegmentChange":
            return Optional.ofNullable(clazz.cast(proposedSegmentChange()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attachment, T> g) {
        return obj -> g.apply((Attachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachment> {
        /**
         * <p>
         * A core network ID.
         * </p>
         * 
         * @param coreNetworkId
         *        A core network ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of a core network.
         * </p>
         * 
         * @param coreNetworkArn
         *        The ARN of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkArn(String coreNetworkArn);

        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The ID of the attachment account owner.
         * </p>
         * 
         * @param ownerAccountId
         *        The ID of the attachment account owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The type of attachment.
         * </p>
         * 
         * @param attachmentType
         *        The type of attachment.
         * @see AttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentType
         */
        Builder attachmentType(String attachmentType);

        /**
         * <p>
         * The type of attachment.
         * </p>
         * 
         * @param attachmentType
         *        The type of attachment.
         * @see AttachmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentType
         */
        Builder attachmentType(AttachmentType attachmentType);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see AttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the attachment.
         * </p>
         * 
         * @param state
         *        The state of the attachment.
         * @see AttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentState
         */
        Builder state(AttachmentState state);

        /**
         * <p>
         * The Region where the edge is located.
         * </p>
         * 
         * @param edgeLocation
         *        The Region where the edge is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocation(String edgeLocation);

        /**
         * <p>
         * The attachment resource ARN.
         * </p>
         * 
         * @param resourceArn
         *        The attachment resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The policy rule number associated with the attachment.
         * </p>
         * 
         * @param attachmentPolicyRuleNumber
         *        The policy rule number associated with the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber);

        /**
         * <p>
         * The name of the segment attachment.
         * </p>
         * 
         * @param segmentName
         *        The name of the segment attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);

        /**
         * <p>
         * The tags associated with the attachment.
         * </p>
         * 
         * @param tags
         *        The tags associated with the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the attachment.
         * </p>
         * 
         * @param tags
         *        The tags associated with the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The attachment to move from one segment to another.
         * </p>
         * 
         * @param proposedSegmentChange
         *        The attachment to move from one segment to another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposedSegmentChange(ProposedSegmentChange proposedSegmentChange);

        /**
         * <p>
         * The attachment to move from one segment to another.
         * </p>
         * This is a convenience that creates an instance of the {@link ProposedSegmentChange.Builder} avoiding the need
         * to create one manually via {@link ProposedSegmentChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProposedSegmentChange.Builder#build()} is called immediately and
         * its result is passed to {@link #proposedSegmentChange(ProposedSegmentChange)}.
         * 
         * @param proposedSegmentChange
         *        a consumer that will call methods on {@link ProposedSegmentChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposedSegmentChange(ProposedSegmentChange)
         */
        default Builder proposedSegmentChange(Consumer<ProposedSegmentChange.Builder> proposedSegmentChange) {
            return proposedSegmentChange(ProposedSegmentChange.builder().applyMutation(proposedSegmentChange).build());
        }

        /**
         * <p>
         * The timestamp when the attachment was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the attachment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the attachment was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the attachment was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private String coreNetworkArn;

        private String attachmentId;

        private String ownerAccountId;

        private String attachmentType;

        private String state;

        private String edgeLocation;

        private String resourceArn;

        private Integer attachmentPolicyRuleNumber;

        private String segmentName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ProposedSegmentChange proposedSegmentChange;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            coreNetworkId(model.coreNetworkId);
            coreNetworkArn(model.coreNetworkArn);
            attachmentId(model.attachmentId);
            ownerAccountId(model.ownerAccountId);
            attachmentType(model.attachmentType);
            state(model.state);
            edgeLocation(model.edgeLocation);
            resourceArn(model.resourceArn);
            attachmentPolicyRuleNumber(model.attachmentPolicyRuleNumber);
            segmentName(model.segmentName);
            tags(model.tags);
            proposedSegmentChange(model.proposedSegmentChange);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getCoreNetworkArn() {
            return coreNetworkArn;
        }

        public final void setCoreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
        }

        @Override
        @Transient
        public final Builder coreNetworkArn(String coreNetworkArn) {
            this.coreNetworkArn = coreNetworkArn;
            return this;
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        @Transient
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        @Transient
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getAttachmentType() {
            return attachmentType;
        }

        public final void setAttachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
        }

        @Override
        @Transient
        public final Builder attachmentType(String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        @Override
        @Transient
        public final Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType(attachmentType == null ? null : attachmentType.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(AttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getEdgeLocation() {
            return edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        @Transient
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Integer getAttachmentPolicyRuleNumber() {
            return attachmentPolicyRuleNumber;
        }

        public final void setAttachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
        }

        @Override
        @Transient
        public final Builder attachmentPolicyRuleNumber(Integer attachmentPolicyRuleNumber) {
            this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
            return this;
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        @Transient
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProposedSegmentChange.Builder getProposedSegmentChange() {
            return proposedSegmentChange != null ? proposedSegmentChange.toBuilder() : null;
        }

        public final void setProposedSegmentChange(ProposedSegmentChange.BuilderImpl proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange != null ? proposedSegmentChange.build() : null;
        }

        @Override
        @Transient
        public final Builder proposedSegmentChange(ProposedSegmentChange proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Attachment build() {
            return new Attachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
