/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network segment, which are dedicated routes. Only attachments within this segment can communicate
 * with each other.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkSegment.Builder, CoreNetworkSegment> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CoreNetworkSegment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EdgeLocations")
            .getter(getter(CoreNetworkSegment::edgeLocations))
            .setter(setter(Builder::edgeLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SHARED_SEGMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SharedSegments")
            .getter(getter(CoreNetworkSegment::sharedSegments))
            .setter(setter(Builder::sharedSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            EDGE_LOCATIONS_FIELD, SHARED_SEGMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> edgeLocations;

    private final List<String> sharedSegments;

    private CoreNetworkSegment(BuilderImpl builder) {
        this.name = builder.name;
        this.edgeLocations = builder.edgeLocations;
        this.sharedSegments = builder.sharedSegments;
    }

    /**
     * <p>
     * The name of a core network segment.
     * </p>
     * 
     * @return The name of a core network segment.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeLocations() {
        return edgeLocations != null && !(edgeLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions where the edges are located.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeLocations} method.
     * </p>
     * 
     * @return The Regions where the edges are located.
     */
    public final List<String> edgeLocations() {
        return edgeLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedSegments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSharedSegments() {
        return sharedSegments != null && !(sharedSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The shared segments of a core network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedSegments} method.
     * </p>
     * 
     * @return The shared segments of a core network.
     */
    public final List<String> sharedSegments() {
        return sharedSegments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeLocations() ? edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedSegments() ? sharedSegments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkSegment)) {
            return false;
        }
        CoreNetworkSegment other = (CoreNetworkSegment) obj;
        return Objects.equals(name(), other.name()) && hasEdgeLocations() == other.hasEdgeLocations()
                && Objects.equals(edgeLocations(), other.edgeLocations()) && hasSharedSegments() == other.hasSharedSegments()
                && Objects.equals(sharedSegments(), other.sharedSegments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkSegment").add("Name", name())
                .add("EdgeLocations", hasEdgeLocations() ? edgeLocations() : null)
                .add("SharedSegments", hasSharedSegments() ? sharedSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EdgeLocations":
            return Optional.ofNullable(clazz.cast(edgeLocations()));
        case "SharedSegments":
            return Optional.ofNullable(clazz.cast(sharedSegments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkSegment, T> g) {
        return obj -> g.apply((CoreNetworkSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkSegment> {
        /**
         * <p>
         * The name of a core network segment.
         * </p>
         * 
         * @param name
         *        The name of a core network segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Regions where the edges are located.
         * </p>
         * 
         * @param edgeLocations
         *        The Regions where the edges are located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(Collection<String> edgeLocations);

        /**
         * <p>
         * The Regions where the edges are located.
         * </p>
         * 
         * @param edgeLocations
         *        The Regions where the edges are located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(String... edgeLocations);

        /**
         * <p>
         * The shared segments of a core network.
         * </p>
         * 
         * @param sharedSegments
         *        The shared segments of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSegments(Collection<String> sharedSegments);

        /**
         * <p>
         * The shared segments of a core network.
         * </p>
         * 
         * @param sharedSegments
         *        The shared segments of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSegments(String... sharedSegments);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private List<String> sharedSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkSegment model) {
            name(model.name);
            edgeLocations(model.edgeLocations);
            sharedSegments(model.sharedSegments);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        @Transient
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder edgeLocations(String... edgeLocations) {
            edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final Collection<String> getSharedSegments() {
            if (sharedSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedSegments;
        }

        public final void setSharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
        }

        @Override
        @Transient
        public final Builder sharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sharedSegments(String... sharedSegments) {
            sharedSegments(Arrays.asList(sharedSegments));
            return this;
        }

        @Override
        public CoreNetworkSegment build() {
            return new CoreNetworkSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
