/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoreNetworkChangeSetResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetCoreNetworkChangeSetResponse.Builder, GetCoreNetworkChangeSetResponse> {
    private static final SdkField<List<CoreNetworkChange>> CORE_NETWORK_CHANGES_FIELD = SdkField
            .<List<CoreNetworkChange>> builder(MarshallingType.LIST)
            .memberName("CoreNetworkChanges")
            .getter(getter(GetCoreNetworkChangeSetResponse::coreNetworkChanges))
            .setter(setter(Builder::coreNetworkChanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkChanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCoreNetworkChangeSetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_CHANGES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CoreNetworkChange> coreNetworkChanges;

    private final String nextToken;

    private GetCoreNetworkChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworkChanges = builder.coreNetworkChanges;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CoreNetworkChanges property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCoreNetworkChanges() {
        return coreNetworkChanges != null && !(coreNetworkChanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes a core network changes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCoreNetworkChanges} method.
     * </p>
     * 
     * @return Describes a core network changes.
     */
    public final List<CoreNetworkChange> coreNetworkChanges() {
        return coreNetworkChanges;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCoreNetworkChanges() ? coreNetworkChanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreNetworkChangeSetResponse)) {
            return false;
        }
        GetCoreNetworkChangeSetResponse other = (GetCoreNetworkChangeSetResponse) obj;
        return hasCoreNetworkChanges() == other.hasCoreNetworkChanges()
                && Objects.equals(coreNetworkChanges(), other.coreNetworkChanges())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoreNetworkChangeSetResponse")
                .add("CoreNetworkChanges", hasCoreNetworkChanges() ? coreNetworkChanges() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkChanges":
            return Optional.ofNullable(clazz.cast(coreNetworkChanges()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreNetworkChangeSetResponse, T> g) {
        return obj -> g.apply((GetCoreNetworkChangeSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCoreNetworkChangeSetResponse> {
        /**
         * <p>
         * Describes a core network changes.
         * </p>
         * 
         * @param coreNetworkChanges
         *        Describes a core network changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkChanges(Collection<CoreNetworkChange> coreNetworkChanges);

        /**
         * <p>
         * Describes a core network changes.
         * </p>
         * 
         * @param coreNetworkChanges
         *        Describes a core network changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkChanges(CoreNetworkChange... coreNetworkChanges);

        /**
         * <p>
         * Describes a core network changes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CoreNetworkChange>.Builder} avoiding the
         * need to create one manually via {@link List<CoreNetworkChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CoreNetworkChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #coreNetworkChanges(List<CoreNetworkChange>)}.
         * 
         * @param coreNetworkChanges
         *        a consumer that will call methods on {@link List<CoreNetworkChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworkChanges(List<CoreNetworkChange>)
         */
        Builder coreNetworkChanges(Consumer<CoreNetworkChange.Builder>... coreNetworkChanges);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<CoreNetworkChange> coreNetworkChanges = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreNetworkChangeSetResponse model) {
            super(model);
            coreNetworkChanges(model.coreNetworkChanges);
            nextToken(model.nextToken);
        }

        public final List<CoreNetworkChange.Builder> getCoreNetworkChanges() {
            List<CoreNetworkChange.Builder> result = CoreNetworkChangeListCopier.copyToBuilder(this.coreNetworkChanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoreNetworkChanges(Collection<CoreNetworkChange.BuilderImpl> coreNetworkChanges) {
            this.coreNetworkChanges = CoreNetworkChangeListCopier.copyFromBuilder(coreNetworkChanges);
        }

        @Override
        @Transient
        public final Builder coreNetworkChanges(Collection<CoreNetworkChange> coreNetworkChanges) {
            this.coreNetworkChanges = CoreNetworkChangeListCopier.copy(coreNetworkChanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder coreNetworkChanges(CoreNetworkChange... coreNetworkChanges) {
            coreNetworkChanges(Arrays.asList(coreNetworkChanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder coreNetworkChanges(Consumer<CoreNetworkChange.Builder>... coreNetworkChanges) {
            coreNetworkChanges(Stream.of(coreNetworkChanges).map(c -> CoreNetworkChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCoreNetworkChangeSetResponse build() {
            return new GetCoreNetworkChangeSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
