/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoreNetworkPolicyRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<GetCoreNetworkPolicyRequest.Builder, GetCoreNetworkPolicyRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(GetCoreNetworkPolicyRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreNetworkId").build()).build();

    private static final SdkField<Integer> POLICY_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicyVersionId").getter(getter(GetCoreNetworkPolicyRequest::policyVersionId))
            .setter(setter(Builder::policyVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyVersionId").build())
            .build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(GetCoreNetworkPolicyRequest::aliasAsString)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            POLICY_VERSION_ID_FIELD, ALIAS_FIELD));

    private final String coreNetworkId;

    private final Integer policyVersionId;

    private final String alias;

    private GetCoreNetworkPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.policyVersionId = builder.policyVersionId;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ID of a core network policy version.
     * </p>
     * 
     * @return The ID of a core network policy version.
     */
    public final Integer policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * The alias of a core network policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return The alias of a core network policy
     * @see CoreNetworkPolicyAlias
     */
    public final CoreNetworkPolicyAlias alias() {
        return CoreNetworkPolicyAlias.fromValue(alias);
    }

    /**
     * <p>
     * The alias of a core network policy
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return The alias of a core network policy
     * @see CoreNetworkPolicyAlias
     */
    public final String aliasAsString() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreNetworkPolicyRequest)) {
            return false;
        }
        GetCoreNetworkPolicyRequest other = (GetCoreNetworkPolicyRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(policyVersionId(), other.policyVersionId())
                && Objects.equals(aliasAsString(), other.aliasAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoreNetworkPolicyRequest").add("CoreNetworkId", coreNetworkId())
                .add("PolicyVersionId", policyVersionId()).add("Alias", aliasAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "PolicyVersionId":
            return Optional.ofNullable(clazz.cast(policyVersionId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(aliasAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreNetworkPolicyRequest, T> g) {
        return obj -> g.apply((GetCoreNetworkPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCoreNetworkPolicyRequest> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ID of a core network policy version.
         * </p>
         * 
         * @param policyVersionId
         *        The ID of a core network policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(Integer policyVersionId);

        /**
         * <p>
         * The alias of a core network policy
         * </p>
         * 
         * @param alias
         *        The alias of a core network policy
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(String alias);

        /**
         * <p>
         * The alias of a core network policy
         * </p>
         * 
         * @param alias
         *        The alias of a core network policy
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(CoreNetworkPolicyAlias alias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private Integer policyVersionId;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreNetworkPolicyRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            policyVersionId(model.policyVersionId);
            alias(model.alias);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final Integer getPolicyVersionId() {
            return policyVersionId;
        }

        public final void setPolicyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        @Transient
        public final Builder policyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        @Transient
        public final Builder alias(CoreNetworkPolicyAlias alias) {
            this.alias(alias == null ? null : alias.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCoreNetworkPolicyRequest build() {
            return new GetCoreNetworkPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
