/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkChangeValues implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkChangeValues.Builder, CoreNetworkChangeValues> {
    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(CoreNetworkChangeValues::segmentName)).setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EdgeLocations")
            .getter(getter(CoreNetworkChangeValues::edgeLocations))
            .setter(setter(Builder::edgeLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> ASN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Asn")
            .getter(getter(CoreNetworkChangeValues::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(CoreNetworkChangeValues::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()).build();

    private static final SdkField<String> DESTINATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIdentifier").getter(getter(CoreNetworkChangeValues::destinationIdentifier))
            .setter(setter(Builder::destinationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIdentifier").build())
            .build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(CoreNetworkChangeValues::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SHARED_SEGMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SharedSegments")
            .getter(getter(CoreNetworkChangeValues::sharedSegments))
            .setter(setter(Builder::sharedSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_NAME_FIELD,
            EDGE_LOCATIONS_FIELD, ASN_FIELD, CIDR_FIELD, DESTINATION_IDENTIFIER_FIELD, INSIDE_CIDR_BLOCKS_FIELD,
            SHARED_SEGMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String segmentName;

    private final List<String> edgeLocations;

    private final Long asn;

    private final String cidr;

    private final String destinationIdentifier;

    private final List<String> insideCidrBlocks;

    private final List<String> sharedSegments;

    private CoreNetworkChangeValues(BuilderImpl builder) {
        this.segmentName = builder.segmentName;
        this.edgeLocations = builder.edgeLocations;
        this.asn = builder.asn;
        this.cidr = builder.cidr;
        this.destinationIdentifier = builder.destinationIdentifier;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.sharedSegments = builder.sharedSegments;
    }

    /**
     * <p>
     * The names of the segments in a core network.
     * </p>
     * 
     * @return The names of the segments in a core network.
     */
    public final String segmentName() {
        return segmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeLocations() {
        return edgeLocations != null && !(edgeLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions where edges are located in a core network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeLocations} method.
     * </p>
     * 
     * @return The Regions where edges are located in a core network.
     */
    public final List<String> edgeLocations() {
        return edgeLocations;
    }

    /**
     * <p>
     * The ASN of a core network.
     * </p>
     * 
     * @return The ASN of a core network.
     */
    public final Long asn() {
        return asn;
    }

    /**
     * <p>
     * The IP addresses used for a core network.
     * </p>
     * 
     * @return The IP addresses used for a core network.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public final String destinationIdentifier() {
        return destinationIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inside IP addresses used for core network change values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The inside IP addresses used for core network change values.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the SharedSegments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSharedSegments() {
        return sharedSegments != null && !(sharedSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The shared segments for a core network change value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSharedSegments} method.
     * </p>
     * 
     * @return The shared segments for a core network change value.
     */
    public final List<String> sharedSegments() {
        return sharedSegments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeLocations() ? edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedSegments() ? sharedSegments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChangeValues)) {
            return false;
        }
        CoreNetworkChangeValues other = (CoreNetworkChangeValues) obj;
        return Objects.equals(segmentName(), other.segmentName()) && hasEdgeLocations() == other.hasEdgeLocations()
                && Objects.equals(edgeLocations(), other.edgeLocations()) && Objects.equals(asn(), other.asn())
                && Objects.equals(cidr(), other.cidr()) && Objects.equals(destinationIdentifier(), other.destinationIdentifier())
                && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks())
                && hasSharedSegments() == other.hasSharedSegments() && Objects.equals(sharedSegments(), other.sharedSegments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkChangeValues").add("SegmentName", segmentName())
                .add("EdgeLocations", hasEdgeLocations() ? edgeLocations() : null).add("Asn", asn()).add("Cidr", cidr())
                .add("DestinationIdentifier", destinationIdentifier())
                .add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null)
                .add("SharedSegments", hasSharedSegments() ? sharedSegments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        case "EdgeLocations":
            return Optional.ofNullable(clazz.cast(edgeLocations()));
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "DestinationIdentifier":
            return Optional.ofNullable(clazz.cast(destinationIdentifier()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        case "SharedSegments":
            return Optional.ofNullable(clazz.cast(sharedSegments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChangeValues, T> g) {
        return obj -> g.apply((CoreNetworkChangeValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkChangeValues> {
        /**
         * <p>
         * The names of the segments in a core network.
         * </p>
         * 
         * @param segmentName
         *        The names of the segments in a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);

        /**
         * <p>
         * The Regions where edges are located in a core network.
         * </p>
         * 
         * @param edgeLocations
         *        The Regions where edges are located in a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(Collection<String> edgeLocations);

        /**
         * <p>
         * The Regions where edges are located in a core network.
         * </p>
         * 
         * @param edgeLocations
         *        The Regions where edges are located in a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeLocations(String... edgeLocations);

        /**
         * <p>
         * The ASN of a core network.
         * </p>
         * 
         * @param asn
         *        The ASN of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Long asn);

        /**
         * <p>
         * The IP addresses used for a core network.
         * </p>
         * 
         * @param cidr
         *        The IP addresses used for a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destinationIdentifier
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIdentifier(String destinationIdentifier);

        /**
         * <p>
         * The inside IP addresses used for core network change values.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for core network change values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The inside IP addresses used for core network change values.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for core network change values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);

        /**
         * <p>
         * The shared segments for a core network change value.
         * </p>
         * 
         * @param sharedSegments
         *        The shared segments for a core network change value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSegments(Collection<String> sharedSegments);

        /**
         * <p>
         * The shared segments for a core network change value.
         * </p>
         * 
         * @param sharedSegments
         *        The shared segments for a core network change value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSegments(String... sharedSegments);
    }

    static final class BuilderImpl implements Builder {
        private String segmentName;

        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private Long asn;

        private String cidr;

        private String destinationIdentifier;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private List<String> sharedSegments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChangeValues model) {
            segmentName(model.segmentName);
            edgeLocations(model.edgeLocations);
            asn(model.asn);
            cidr(model.cidr);
            destinationIdentifier(model.destinationIdentifier);
            insideCidrBlocks(model.insideCidrBlocks);
            sharedSegments(model.sharedSegments);
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        @Transient
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        @Transient
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder edgeLocations(String... edgeLocations) {
            edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final Long getAsn() {
            return asn;
        }

        public final void setAsn(Long asn) {
            this.asn = asn;
        }

        @Override
        @Transient
        public final Builder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getDestinationIdentifier() {
            return destinationIdentifier;
        }

        public final void setDestinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
        }

        @Override
        @Transient
        public final Builder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        @Transient
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final Collection<String> getSharedSegments() {
            if (sharedSegments instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedSegments;
        }

        public final void setSharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
        }

        @Override
        @Transient
        public final Builder sharedSegments(Collection<String> sharedSegments) {
            this.sharedSegments = ConstrainedStringListCopier.copy(sharedSegments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sharedSegments(String... sharedSegments) {
            sharedSegments(Arrays.asList(sharedSegments));
            return this;
        }

        @Override
        public CoreNetworkChangeValues build() {
            return new CoreNetworkChangeValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
