/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNetworkResourcesResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<GetNetworkResourcesResponse.Builder, GetNetworkResourcesResponse> {
    private static final SdkField<List<NetworkResource>> NETWORK_RESOURCES_FIELD = SdkField
            .<List<NetworkResource>> builder(MarshallingType.LIST)
            .memberName("NetworkResources")
            .getter(getter(GetNetworkResourcesResponse::networkResources))
            .setter(setter(Builder::networkResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetNetworkResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NetworkResource> networkResources;

    private final String nextToken;

    private GetNetworkResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.networkResources = builder.networkResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkResources() {
        return networkResources != null && !(networkResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkResources} method.
     * </p>
     * 
     * @return The network resources.
     */
    public final List<NetworkResource> networkResources() {
        return networkResources;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkResources() ? networkResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkResourcesResponse)) {
            return false;
        }
        GetNetworkResourcesResponse other = (GetNetworkResourcesResponse) obj;
        return hasNetworkResources() == other.hasNetworkResources()
                && Objects.equals(networkResources(), other.networkResources()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNetworkResourcesResponse")
                .add("NetworkResources", hasNetworkResources() ? networkResources() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkResources":
            return Optional.ofNullable(clazz.cast(networkResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkResourcesResponse, T> g) {
        return obj -> g.apply((GetNetworkResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNetworkResourcesResponse> {
        /**
         * <p>
         * The network resources.
         * </p>
         * 
         * @param networkResources
         *        The network resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkResources(Collection<NetworkResource> networkResources);

        /**
         * <p>
         * The network resources.
         * </p>
         * 
         * @param networkResources
         *        The network resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkResources(NetworkResource... networkResources);

        /**
         * <p>
         * The network resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkResource>.Builder} avoiding the need
         * to create one manually via {@link List<NetworkResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #networkResources(List<NetworkResource>)}.
         * 
         * @param networkResources
         *        a consumer that will call methods on {@link List<NetworkResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkResources(List<NetworkResource>)
         */
        Builder networkResources(Consumer<NetworkResource.Builder>... networkResources);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private List<NetworkResource> networkResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkResourcesResponse model) {
            super(model);
            networkResources(model.networkResources);
            nextToken(model.nextToken);
        }

        public final List<NetworkResource.Builder> getNetworkResources() {
            List<NetworkResource.Builder> result = NetworkResourceListCopier.copyToBuilder(this.networkResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkResources(Collection<NetworkResource.BuilderImpl> networkResources) {
            this.networkResources = NetworkResourceListCopier.copyFromBuilder(networkResources);
        }

        @Override
        @Transient
        public final Builder networkResources(Collection<NetworkResource> networkResources) {
            this.networkResources = NetworkResourceListCopier.copy(networkResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkResources(NetworkResource... networkResources) {
            networkResources(Arrays.asList(networkResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkResources(Consumer<NetworkResource.Builder>... networkResources) {
            networkResources(Stream.of(networkResources).map(c -> NetworkResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetNetworkResourcesResponse build() {
            return new GetNetworkResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
