/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateCustomerGatewayResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<AssociateCustomerGatewayResponse.Builder, AssociateCustomerGatewayResponse> {
    private static final SdkField<CustomerGatewayAssociation> CUSTOMER_GATEWAY_ASSOCIATION_FIELD = SdkField
            .<CustomerGatewayAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerGatewayAssociation")
            .getter(getter(AssociateCustomerGatewayResponse::customerGatewayAssociation))
            .setter(setter(Builder::customerGatewayAssociation))
            .constructor(CustomerGatewayAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOMER_GATEWAY_ASSOCIATION_FIELD));

    private final CustomerGatewayAssociation customerGatewayAssociation;

    private AssociateCustomerGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.customerGatewayAssociation = builder.customerGatewayAssociation;
    }

    /**
     * <p>
     * The customer gateway association.
     * </p>
     * 
     * @return The customer gateway association.
     */
    public final CustomerGatewayAssociation customerGatewayAssociation() {
        return customerGatewayAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCustomerGatewayResponse)) {
            return false;
        }
        AssociateCustomerGatewayResponse other = (AssociateCustomerGatewayResponse) obj;
        return Objects.equals(customerGatewayAssociation(), other.customerGatewayAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateCustomerGatewayResponse")
                .add("CustomerGatewayAssociation", customerGatewayAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGatewayAssociation":
            return Optional.ofNullable(clazz.cast(customerGatewayAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateCustomerGatewayResponse, T> g) {
        return obj -> g.apply((AssociateCustomerGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateCustomerGatewayResponse> {
        /**
         * <p>
         * The customer gateway association.
         * </p>
         * 
         * @param customerGatewayAssociation
         *        The customer gateway association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayAssociation(CustomerGatewayAssociation customerGatewayAssociation);

        /**
         * <p>
         * The customer gateway association.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerGatewayAssociation.Builder}
         * avoiding the need to create one manually via {@link CustomerGatewayAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerGatewayAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #customerGatewayAssociation(CustomerGatewayAssociation)}.
         * 
         * @param customerGatewayAssociation
         *        a consumer that will call methods on {@link CustomerGatewayAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerGatewayAssociation(CustomerGatewayAssociation)
         */
        default Builder customerGatewayAssociation(Consumer<CustomerGatewayAssociation.Builder> customerGatewayAssociation) {
            return customerGatewayAssociation(CustomerGatewayAssociation.builder().applyMutation(customerGatewayAssociation)
                    .build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private CustomerGatewayAssociation customerGatewayAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCustomerGatewayResponse model) {
            super(model);
            customerGatewayAssociation(model.customerGatewayAssociation);
        }

        public final CustomerGatewayAssociation.Builder getCustomerGatewayAssociation() {
            return customerGatewayAssociation != null ? customerGatewayAssociation.toBuilder() : null;
        }

        public final void setCustomerGatewayAssociation(CustomerGatewayAssociation.BuilderImpl customerGatewayAssociation) {
            this.customerGatewayAssociation = customerGatewayAssociation != null ? customerGatewayAssociation.build() : null;
        }

        @Override
        @Transient
        public final Builder customerGatewayAssociation(CustomerGatewayAssociation customerGatewayAssociation) {
            this.customerGatewayAssociation = customerGatewayAssociation;
            return this;
        }

        @Override
        public AssociateCustomerGatewayResponse build() {
            return new AssociateCustomerGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
