/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectPeerRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<CreateConnectPeerRequest.Builder, CreateConnectPeerRequest> {
    private static final SdkField<String> CONNECT_ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectAttachmentId").getter(getter(CreateConnectPeerRequest::connectAttachmentId))
            .setter(setter(Builder::connectAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachmentId").build())
            .build();

    private static final SdkField<String> CORE_NETWORK_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkAddress").getter(getter(CreateConnectPeerRequest::coreNetworkAddress))
            .setter(setter(Builder::coreNetworkAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAddress").build())
            .build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress").getter(getter(CreateConnectPeerRequest::peerAddress)).setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").build()).build();

    private static final SdkField<BgpOptions> BGP_OPTIONS_FIELD = SdkField.<BgpOptions> builder(MarshallingType.SDK_POJO)
            .memberName("BgpOptions").getter(getter(CreateConnectPeerRequest::bgpOptions)).setter(setter(Builder::bgpOptions))
            .constructor(BgpOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions").build()).build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(CreateConnectPeerRequest::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateConnectPeerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateConnectPeerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_ATTACHMENT_ID_FIELD,
            CORE_NETWORK_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, TAGS_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String connectAttachmentId;

    private final String coreNetworkAddress;

    private final String peerAddress;

    private final BgpOptions bgpOptions;

    private final List<String> insideCidrBlocks;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.connectAttachmentId = builder.connectAttachmentId;
        this.coreNetworkAddress = builder.coreNetworkAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the connection attachment.
     * </p>
     * 
     * @return The ID of the connection attachment.
     */
    public final String connectAttachmentId() {
        return connectAttachmentId;
    }

    /**
     * <p>
     * A Connect peer core network address.
     * </p>
     * 
     * @return A Connect peer core network address.
     */
    public final String coreNetworkAddress() {
        return coreNetworkAddress;
    }

    /**
     * <p>
     * The Connect peer address.
     * </p>
     * 
     * @return The Connect peer address.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The Connect peer BGP options.
     * </p>
     * 
     * @return The Connect peer BGP options.
     */
    public final BgpOptions bgpOptions() {
        return bgpOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inside IP addresses used for BGP peering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The inside IP addresses used for BGP peering.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the peer request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the peer request.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectPeerRequest)) {
            return false;
        }
        CreateConnectPeerRequest other = (CreateConnectPeerRequest) obj;
        return Objects.equals(connectAttachmentId(), other.connectAttachmentId())
                && Objects.equals(coreNetworkAddress(), other.coreNetworkAddress())
                && Objects.equals(peerAddress(), other.peerAddress()) && Objects.equals(bgpOptions(), other.bgpOptions())
                && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectPeerRequest").add("ConnectAttachmentId", connectAttachmentId())
                .add("CoreNetworkAddress", coreNetworkAddress()).add("PeerAddress", peerAddress())
                .add("BgpOptions", bgpOptions()).add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null)
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectAttachmentId":
            return Optional.ofNullable(clazz.cast(connectAttachmentId()));
        case "CoreNetworkAddress":
            return Optional.ofNullable(clazz.cast(coreNetworkAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "BgpOptions":
            return Optional.ofNullable(clazz.cast(bgpOptions()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectPeerRequest, T> g) {
        return obj -> g.apply((CreateConnectPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectPeerRequest> {
        /**
         * <p>
         * The ID of the connection attachment.
         * </p>
         * 
         * @param connectAttachmentId
         *        The ID of the connection attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectAttachmentId(String connectAttachmentId);

        /**
         * <p>
         * A Connect peer core network address.
         * </p>
         * 
         * @param coreNetworkAddress
         *        A Connect peer core network address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkAddress(String coreNetworkAddress);

        /**
         * <p>
         * The Connect peer address.
         * </p>
         * 
         * @param peerAddress
         *        The Connect peer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The Connect peer BGP options.
         * </p>
         * 
         * @param bgpOptions
         *        The Connect peer BGP options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpOptions(BgpOptions bgpOptions);

        /**
         * <p>
         * The Connect peer BGP options.
         * </p>
         * This is a convenience method that creates an instance of the {@link BgpOptions.Builder} avoiding the need to
         * create one manually via {@link BgpOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link BgpOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #bgpOptions(BgpOptions)}.
         * 
         * @param bgpOptions
         *        a consumer that will call methods on {@link BgpOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpOptions(BgpOptions)
         */
        default Builder bgpOptions(Consumer<BgpOptions.Builder> bgpOptions) {
            return bgpOptions(BgpOptions.builder().applyMutation(bgpOptions).build());
        }

        /**
         * <p>
         * The inside IP addresses used for BGP peering.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for BGP peering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The inside IP addresses used for BGP peering.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The inside IP addresses used for BGP peering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);

        /**
         * <p>
         * The tags associated with the peer request.
         * </p>
         * 
         * @param tags
         *        The tags associated with the peer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the peer request.
         * </p>
         * 
         * @param tags
         *        The tags associated with the peer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the peer request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String connectAttachmentId;

        private String coreNetworkAddress;

        private String peerAddress;

        private BgpOptions bgpOptions;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectPeerRequest model) {
            super(model);
            connectAttachmentId(model.connectAttachmentId);
            coreNetworkAddress(model.coreNetworkAddress);
            peerAddress(model.peerAddress);
            bgpOptions(model.bgpOptions);
            insideCidrBlocks(model.insideCidrBlocks);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getConnectAttachmentId() {
            return connectAttachmentId;
        }

        public final void setConnectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
        }

        @Override
        @Transient
        public final Builder connectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        public final String getCoreNetworkAddress() {
            return coreNetworkAddress;
        }

        public final void setCoreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
        }

        @Override
        @Transient
        public final Builder coreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        @Transient
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final BgpOptions.Builder getBgpOptions() {
            return bgpOptions != null ? bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(BgpOptions.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder bgpOptions(BgpOptions bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        @Transient
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectPeerRequest build() {
            return new CreateConnectPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
