/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcAttachmentRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<CreateVpcAttachmentRequest.Builder, CreateVpcAttachmentRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CreateVpcAttachmentRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> VPC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcArn")
            .getter(getter(CreateVpcAttachmentRequest::vpcArn)).setter(setter(Builder::vpcArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcArn").build()).build();

    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetArns")
            .getter(getter(CreateVpcAttachmentRequest::subnetArns))
            .setter(setter(Builder::subnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.<VpcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(CreateVpcAttachmentRequest::options)).setter(setter(Builder::options))
            .constructor(VpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateVpcAttachmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateVpcAttachmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            VPC_ARN_FIELD, SUBNET_ARNS_FIELD, OPTIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));

    private final String coreNetworkId;

    private final String vpcArn;

    private final List<String> subnetArns;

    private final VpcOptions options;

    private final List<Tag> tags;

    private final String clientToken;

    private CreateVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.vpcArn = builder.vpcArn;
        this.subnetArns = builder.subnetArns;
        this.options = builder.options;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of a core network for the VPC attachment.
     * </p>
     * 
     * @return The ID of a core network for the VPC attachment.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ARN of the VPC.
     * </p>
     * 
     * @return The ARN of the VPC.
     */
    public final String vpcArn() {
        return vpcArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetArns() {
        return subnetArns != null && !(subnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnet ARN of the VPC attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetArns} method.
     * </p>
     * 
     * @return The subnet ARN of the VPC attachment.
     */
    public final List<String> subnetArns() {
        return subnetArns;
    }

    /**
     * <p>
     * Options for the VPC attachment.
     * </p>
     * 
     * @return Options for the VPC attachment.
     */
    public final VpcOptions options() {
        return options;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value tags associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value tags associated with the request.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetArns() ? subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAttachmentRequest)) {
            return false;
        }
        CreateVpcAttachmentRequest other = (CreateVpcAttachmentRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(vpcArn(), other.vpcArn())
                && hasSubnetArns() == other.hasSubnetArns() && Objects.equals(subnetArns(), other.subnetArns())
                && Objects.equals(options(), other.options()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcAttachmentRequest").add("CoreNetworkId", coreNetworkId()).add("VpcArn", vpcArn())
                .add("SubnetArns", hasSubnetArns() ? subnetArns() : null).add("Options", options())
                .add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "VpcArn":
            return Optional.ofNullable(clazz.cast(vpcArn()));
        case "SubnetArns":
            return Optional.ofNullable(clazz.cast(subnetArns()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcAttachmentRequest, T> g) {
        return obj -> g.apply((CreateVpcAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcAttachmentRequest> {
        /**
         * <p>
         * The ID of a core network for the VPC attachment.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network for the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ARN of the VPC.
         * </p>
         * 
         * @param vpcArn
         *        The ARN of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcArn(String vpcArn);

        /**
         * <p>
         * The subnet ARN of the VPC attachment.
         * </p>
         * 
         * @param subnetArns
         *        The subnet ARN of the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(Collection<String> subnetArns);

        /**
         * <p>
         * The subnet ARN of the VPC attachment.
         * </p>
         * 
         * @param subnetArns
         *        The subnet ARN of the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(String... subnetArns);

        /**
         * <p>
         * Options for the VPC attachment.
         * </p>
         * 
         * @param options
         *        Options for the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpcOptions options);

        /**
         * <p>
         * Options for the VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOptions.Builder} avoiding the need to
         * create one manually via {@link VpcOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #options(VpcOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link VpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(VpcOptions)
         */
        default Builder options(Consumer<VpcOptions.Builder> options) {
            return options(VpcOptions.builder().applyMutation(options).build());
        }

        /**
         * <p>
         * The key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value tags associated with the request.
         * </p>
         * 
         * @param tags
         *        The key-value tags associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value tags associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private String vpcArn;

        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();

        private VpcOptions options;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAttachmentRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            vpcArn(model.vpcArn);
            subnetArns(model.subnetArns);
            options(model.options);
            tags(model.tags);
            clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getVpcArn() {
            return vpcArn;
        }

        public final void setVpcArn(String vpcArn) {
            this.vpcArn = vpcArn;
        }

        @Override
        @Transient
        public final Builder vpcArn(String vpcArn) {
            this.vpcArn = vpcArn;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
        }

        @Override
        @Transient
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = SubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetArns(String... subnetArns) {
            subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcAttachmentRequest build() {
            return new CreateVpcAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
