/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkRoute implements SdkPojo, Serializable, ToCopyableBuilder<NetworkRoute.Builder, NetworkRoute> {
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock").getter(getter(NetworkRoute::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").build())
            .build();

    private static final SdkField<List<NetworkRouteDestination>> DESTINATIONS_FIELD = SdkField
            .<List<NetworkRouteDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(NetworkRoute::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkRouteDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkRouteDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId").getter(getter(NetworkRoute::prefixListId)).setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(NetworkRoute::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(NetworkRoute::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CIDR_BLOCK_FIELD,
            DESTINATIONS_FIELD, PREFIX_LIST_ID_FIELD, STATE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationCidrBlock;

    private final List<NetworkRouteDestination> destinations;

    private final String prefixListId;

    private final String state;

    private final String type;

    private NetworkRoute(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinations = builder.destinations;
        this.prefixListId = builder.prefixListId;
        this.state = builder.state;
        this.type = builder.type;
    }

    /**
     * <p>
     * A unique identifier for the route, such as a CIDR block.
     * </p>
     * 
     * @return A unique identifier for the route, such as a CIDR block.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destinations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The destinations.
     */
    public final List<NetworkRouteDestination> destinations() {
        return destinations;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The route state. The possible values are <code>active</code> and <code>blackhole</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The route state. The possible values are <code>active</code> and <code>blackhole</code>.
     * @see RouteState
     */
    public final RouteState state() {
        return RouteState.fromValue(state);
    }

    /**
     * <p>
     * The route state. The possible values are <code>active</code> and <code>blackhole</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The route state. The possible values are <code>active</code> and <code>blackhole</code>.
     * @see RouteState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The route type. The possible values are <code>propagated</code> and <code>static</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The route type. The possible values are <code>propagated</code> and <code>static</code>.
     * @see RouteType
     */
    public final RouteType type() {
        return RouteType.fromValue(type);
    }

    /**
     * <p>
     * The route type. The possible values are <code>propagated</code> and <code>static</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The route type. The possible values are <code>propagated</code> and <code>static</code>.
     * @see RouteType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkRoute)) {
            return false;
        }
        NetworkRoute other = (NetworkRoute) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(prefixListId(), other.prefixListId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkRoute").add("DestinationCidrBlock", destinationCidrBlock())
                .add("Destinations", hasDestinations() ? destinations() : null).add("PrefixListId", prefixListId())
                .add("State", stateAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkRoute, T> g) {
        return obj -> g.apply((NetworkRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkRoute> {
        /**
         * <p>
         * A unique identifier for the route, such as a CIDR block.
         * </p>
         * 
         * @param destinationCidrBlock
         *        A unique identifier for the route, such as a CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The destinations.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<NetworkRouteDestination> destinations);

        /**
         * <p>
         * The destinations.
         * </p>
         * 
         * @param destinations
         *        The destinations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(NetworkRouteDestination... destinations);

        /**
         * <p>
         * The destinations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NetworkRouteDestination>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkRouteDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkRouteDestination>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<NetworkRouteDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<NetworkRouteDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<NetworkRouteDestination>)
         */
        Builder destinations(Consumer<NetworkRouteDestination.Builder>... destinations);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The route state. The possible values are <code>active</code> and <code>blackhole</code>.
         * </p>
         * 
         * @param state
         *        The route state. The possible values are <code>active</code> and <code>blackhole</code>.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The route state. The possible values are <code>active</code> and <code>blackhole</code>.
         * </p>
         * 
         * @param state
         *        The route state. The possible values are <code>active</code> and <code>blackhole</code>.
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The route type. The possible values are <code>propagated</code> and <code>static</code>.
         * </p>
         * 
         * @param type
         *        The route type. The possible values are <code>propagated</code> and <code>static</code>.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder type(String type);

        /**
         * <p>
         * The route type. The possible values are <code>propagated</code> and <code>static</code>.
         * </p>
         * 
         * @param type
         *        The route type. The possible values are <code>propagated</code> and <code>static</code>.
         * @see RouteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteType
         */
        Builder type(RouteType type);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private List<NetworkRouteDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private String prefixListId;

        private String state;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkRoute model) {
            destinationCidrBlock(model.destinationCidrBlock);
            destinations(model.destinations);
            prefixListId(model.prefixListId);
            state(model.state);
            type(model.type);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        @Transient
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final List<NetworkRouteDestination.Builder> getDestinations() {
            List<NetworkRouteDestination.Builder> result = NetworkRouteDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<NetworkRouteDestination.BuilderImpl> destinations) {
            this.destinations = NetworkRouteDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        @Transient
        public final Builder destinations(Collection<NetworkRouteDestination> destinations) {
            this.destinations = NetworkRouteDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(NetworkRouteDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(Consumer<NetworkRouteDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> NetworkRouteDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        @Transient
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(RouteState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(RouteType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public NetworkRoute build() {
            return new NetworkRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
