/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the telemetry information for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkTelemetry implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkTelemetry.Builder, NetworkTelemetry> {
    private static final SdkField<String> REGISTERED_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredGatewayArn").getter(getter(NetworkTelemetry::registeredGatewayArn))
            .setter(setter(Builder::registeredGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredGatewayArn").build())
            .build();

    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(NetworkTelemetry::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(NetworkTelemetry::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(NetworkTelemetry::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(NetworkTelemetry::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(NetworkTelemetry::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(NetworkTelemetry::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(NetworkTelemetry::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<ConnectionHealth> HEALTH_FIELD = SdkField.<ConnectionHealth> builder(MarshallingType.SDK_POJO)
            .memberName("Health").getter(getter(NetworkTelemetry::health)).setter(setter(Builder::health))
            .constructor(ConnectionHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Health").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTERED_GATEWAY_ARN_FIELD,
            CORE_NETWORK_ID_FIELD, AWS_REGION_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD,
            RESOURCE_ARN_FIELD, ADDRESS_FIELD, HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registeredGatewayArn;

    private final String coreNetworkId;

    private final String awsRegion;

    private final String accountId;

    private final String resourceType;

    private final String resourceId;

    private final String resourceArn;

    private final String address;

    private final ConnectionHealth health;

    private NetworkTelemetry(BuilderImpl builder) {
        this.registeredGatewayArn = builder.registeredGatewayArn;
        this.coreNetworkId = builder.coreNetworkId;
        this.awsRegion = builder.awsRegion;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.address = builder.address;
        this.health = builder.health;
    }

    /**
     * <p>
     * The ARN of the gateway.
     * </p>
     * 
     * @return The ARN of the gateway.
     */
    public final String registeredGatewayArn() {
        return registeredGatewayArn;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Web Services Region.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The address.
     * </p>
     * 
     * @return The address.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The connection health.
     * </p>
     * 
     * @return The connection health.
     */
    public final ConnectionHealth health() {
        return health;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registeredGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(health());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkTelemetry)) {
            return false;
        }
        NetworkTelemetry other = (NetworkTelemetry) obj;
        return Objects.equals(registeredGatewayArn(), other.registeredGatewayArn())
                && Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(address(), other.address()) && Objects.equals(health(), other.health());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkTelemetry").add("RegisteredGatewayArn", registeredGatewayArn())
                .add("CoreNetworkId", coreNetworkId()).add("AwsRegion", awsRegion()).add("AccountId", accountId())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId()).add("ResourceArn", resourceArn())
                .add("Address", address()).add("Health", health()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegisteredGatewayArn":
            return Optional.ofNullable(clazz.cast(registeredGatewayArn()));
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Health":
            return Optional.ofNullable(clazz.cast(health()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkTelemetry, T> g) {
        return obj -> g.apply((NetworkTelemetry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkTelemetry> {
        /**
         * <p>
         * The ARN of the gateway.
         * </p>
         * 
         * @param registeredGatewayArn
         *        The ARN of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredGatewayArn(String registeredGatewayArn);

        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The Amazon Web Services Region.
         * </p>
         * 
         * @param awsRegion
         *        The Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The address.
         * </p>
         * 
         * @param address
         *        The address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The connection health.
         * </p>
         * 
         * @param health
         *        The connection health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder health(ConnectionHealth health);

        /**
         * <p>
         * The connection health.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionHealth.Builder} avoiding the
         * need to create one manually via {@link ConnectionHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #health(ConnectionHealth)}.
         * 
         * @param health
         *        a consumer that will call methods on {@link ConnectionHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #health(ConnectionHealth)
         */
        default Builder health(Consumer<ConnectionHealth.Builder> health) {
            return health(ConnectionHealth.builder().applyMutation(health).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String registeredGatewayArn;

        private String coreNetworkId;

        private String awsRegion;

        private String accountId;

        private String resourceType;

        private String resourceId;

        private String resourceArn;

        private String address;

        private ConnectionHealth health;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkTelemetry model) {
            registeredGatewayArn(model.registeredGatewayArn);
            coreNetworkId(model.coreNetworkId);
            awsRegion(model.awsRegion);
            accountId(model.accountId);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceArn(model.resourceArn);
            address(model.address);
            health(model.health);
        }

        public final String getRegisteredGatewayArn() {
            return registeredGatewayArn;
        }

        public final void setRegisteredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
        }

        @Override
        @Transient
        public final Builder registeredGatewayArn(String registeredGatewayArn) {
            this.registeredGatewayArn = registeredGatewayArn;
            return this;
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        @Transient
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        @Transient
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        @Transient
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final ConnectionHealth.Builder getHealth() {
            return health != null ? health.toBuilder() : null;
        }

        public final void setHealth(ConnectionHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        @Transient
        public final Builder health(ConnectionHealth health) {
            this.health = health;
            return this;
        }

        @Override
        public NetworkTelemetry build() {
            return new NetworkTelemetry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
