/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRouteAnalysisRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<StartRouteAnalysisRequest.Builder, StartRouteAnalysisRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(StartRouteAnalysisRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<RouteAnalysisEndpointOptionsSpecification> SOURCE_FIELD = SdkField
            .<RouteAnalysisEndpointOptionsSpecification> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(StartRouteAnalysisRequest::source)).setter(setter(Builder::source))
            .constructor(RouteAnalysisEndpointOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<RouteAnalysisEndpointOptionsSpecification> DESTINATION_FIELD = SdkField
            .<RouteAnalysisEndpointOptionsSpecification> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(StartRouteAnalysisRequest::destination)).setter(setter(Builder::destination))
            .constructor(RouteAnalysisEndpointOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<Boolean> INCLUDE_RETURN_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeReturnPath").getter(getter(StartRouteAnalysisRequest::includeReturnPath))
            .setter(setter(Builder::includeReturnPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeReturnPath").build()).build();

    private static final SdkField<Boolean> USE_MIDDLEBOXES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseMiddleboxes").getter(getter(StartRouteAnalysisRequest::useMiddleboxes))
            .setter(setter(Builder::useMiddleboxes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseMiddleboxes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            SOURCE_FIELD, DESTINATION_FIELD, INCLUDE_RETURN_PATH_FIELD, USE_MIDDLEBOXES_FIELD));

    private final String globalNetworkId;

    private final RouteAnalysisEndpointOptionsSpecification source;

    private final RouteAnalysisEndpointOptionsSpecification destination;

    private final Boolean includeReturnPath;

    private final Boolean useMiddleboxes;

    private StartRouteAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.source = builder.source;
        this.destination = builder.destination;
        this.includeReturnPath = builder.includeReturnPath;
        this.useMiddleboxes = builder.useMiddleboxes;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The source from which traffic originates.
     * </p>
     * 
     * @return The source from which traffic originates.
     */
    public final RouteAnalysisEndpointOptionsSpecification source() {
        return source;
    }

    /**
     * <p>
     * The destination.
     * </p>
     * 
     * @return The destination.
     */
    public final RouteAnalysisEndpointOptionsSpecification destination() {
        return destination;
    }

    /**
     * <p>
     * Indicates whether to analyze the return path. The default is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to analyze the return path. The default is <code>false</code>.
     */
    public final Boolean includeReturnPath() {
        return includeReturnPath;
    }

    /**
     * <p>
     * Indicates whether to include the location of middlebox appliances in the route analysis. The default is
     * <code>false</code>.
     * </p>
     * 
     * @return Indicates whether to include the location of middlebox appliances in the route analysis. The default is
     *         <code>false</code>.
     */
    public final Boolean useMiddleboxes() {
        return useMiddleboxes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(includeReturnPath());
        hashCode = 31 * hashCode + Objects.hashCode(useMiddleboxes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRouteAnalysisRequest)) {
            return false;
        }
        StartRouteAnalysisRequest other = (StartRouteAnalysisRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(includeReturnPath(), other.includeReturnPath())
                && Objects.equals(useMiddleboxes(), other.useMiddleboxes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRouteAnalysisRequest").add("GlobalNetworkId", globalNetworkId()).add("Source", source())
                .add("Destination", destination()).add("IncludeReturnPath", includeReturnPath())
                .add("UseMiddleboxes", useMiddleboxes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "IncludeReturnPath":
            return Optional.ofNullable(clazz.cast(includeReturnPath()));
        case "UseMiddleboxes":
            return Optional.ofNullable(clazz.cast(useMiddleboxes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRouteAnalysisRequest, T> g) {
        return obj -> g.apply((StartRouteAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRouteAnalysisRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The source from which traffic originates.
         * </p>
         * 
         * @param source
         *        The source from which traffic originates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(RouteAnalysisEndpointOptionsSpecification source);

        /**
         * <p>
         * The source from which traffic originates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RouteAnalysisEndpointOptionsSpecification.Builder} avoiding the need to create one manually via
         * {@link RouteAnalysisEndpointOptionsSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisEndpointOptionsSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link #source(RouteAnalysisEndpointOptionsSpecification)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link RouteAnalysisEndpointOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(RouteAnalysisEndpointOptionsSpecification)
         */
        default Builder source(Consumer<RouteAnalysisEndpointOptionsSpecification.Builder> source) {
            return source(RouteAnalysisEndpointOptionsSpecification.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The destination.
         * </p>
         * 
         * @param destination
         *        The destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(RouteAnalysisEndpointOptionsSpecification destination);

        /**
         * <p>
         * The destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RouteAnalysisEndpointOptionsSpecification.Builder} avoiding the need to create one manually via
         * {@link RouteAnalysisEndpointOptionsSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteAnalysisEndpointOptionsSpecification.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #destination(RouteAnalysisEndpointOptionsSpecification)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link RouteAnalysisEndpointOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(RouteAnalysisEndpointOptionsSpecification)
         */
        default Builder destination(Consumer<RouteAnalysisEndpointOptionsSpecification.Builder> destination) {
            return destination(RouteAnalysisEndpointOptionsSpecification.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Indicates whether to analyze the return path. The default is <code>false</code>.
         * </p>
         * 
         * @param includeReturnPath
         *        Indicates whether to analyze the return path. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeReturnPath(Boolean includeReturnPath);

        /**
         * <p>
         * Indicates whether to include the location of middlebox appliances in the route analysis. The default is
         * <code>false</code>.
         * </p>
         * 
         * @param useMiddleboxes
         *        Indicates whether to include the location of middlebox appliances in the route analysis. The default
         *        is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useMiddleboxes(Boolean useMiddleboxes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private RouteAnalysisEndpointOptionsSpecification source;

        private RouteAnalysisEndpointOptionsSpecification destination;

        private Boolean includeReturnPath;

        private Boolean useMiddleboxes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRouteAnalysisRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            source(model.source);
            destination(model.destination);
            includeReturnPath(model.includeReturnPath);
            useMiddleboxes(model.useMiddleboxes);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final RouteAnalysisEndpointOptionsSpecification.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(RouteAnalysisEndpointOptionsSpecification.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(RouteAnalysisEndpointOptionsSpecification source) {
            this.source = source;
            return this;
        }

        public final RouteAnalysisEndpointOptionsSpecification.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(RouteAnalysisEndpointOptionsSpecification.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(RouteAnalysisEndpointOptionsSpecification destination) {
            this.destination = destination;
            return this;
        }

        public final Boolean getIncludeReturnPath() {
            return includeReturnPath;
        }

        public final void setIncludeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
        }

        @Override
        @Transient
        public final Builder includeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
            return this;
        }

        public final Boolean getUseMiddleboxes() {
            return useMiddleboxes;
        }

        public final void setUseMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
        }

        @Override
        @Transient
        public final Builder useMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRouteAnalysisRequest build() {
            return new StartRouteAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
