/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<UpdateDeviceRequest.Builder, UpdateDeviceRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(UpdateDeviceRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(UpdateDeviceRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceId").build()).build();

    private static final SdkField<AWSLocation> AWS_LOCATION_FIELD = SdkField.<AWSLocation> builder(MarshallingType.SDK_POJO)
            .memberName("AWSLocation").getter(getter(UpdateDeviceRequest::awsLocation)).setter(setter(Builder::awsLocation))
            .constructor(AWSLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSLocation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDeviceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateDeviceRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vendor")
            .getter(getter(UpdateDeviceRequest::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Model")
            .getter(getter(UpdateDeviceRequest::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(UpdateDeviceRequest::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(UpdateDeviceRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(UpdateDeviceRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            DEVICE_ID_FIELD, AWS_LOCATION_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, VENDOR_FIELD, MODEL_FIELD, SERIAL_NUMBER_FIELD,
            LOCATION_FIELD, SITE_ID_FIELD));

    private final String globalNetworkId;

    private final String deviceId;

    private final AWSLocation awsLocation;

    private final String description;

    private final String type;

    private final String vendor;

    private final String model;

    private final String serialNumber;

    private final Location location;

    private final String siteId;

    private UpdateDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.deviceId = builder.deviceId;
        this.awsLocation = builder.awsLocation;
        this.description = builder.description;
        this.type = builder.type;
        this.vendor = builder.vendor;
        this.model = builder.model;
        this.serialNumber = builder.serialNumber;
        this.location = builder.location;
        this.siteId = builder.siteId;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this
     * parameter.
     * </p>
     * 
     * @return The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit
     *         this parameter.
     */
    public final AWSLocation awsLocation() {
        return awsLocation;
    }

    /**
     * <p>
     * A description of the device.
     * </p>
     * <p>
     * Constraints: Maximum length of 256 characters.
     * </p>
     * 
     * @return A description of the device.</p>
     *         <p>
     *         Constraints: Maximum length of 256 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the device.
     * </p>
     * 
     * @return The type of the device.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The vendor of the device.
     * </p>
     * <p>
     * Constraints: Maximum length of 128 characters.
     * </p>
     * 
     * @return The vendor of the device.</p>
     *         <p>
     *         Constraints: Maximum length of 128 characters.
     */
    public final String vendor() {
        return vendor;
    }

    /**
     * <p>
     * The model of the device.
     * </p>
     * <p>
     * Constraints: Maximum length of 128 characters.
     * </p>
     * 
     * @return The model of the device.</p>
     *         <p>
     *         Constraints: Maximum length of 128 characters.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The serial number of the device.
     * </p>
     * <p>
     * Constraints: Maximum length of 128 characters.
     * </p>
     * 
     * @return The serial number of the device.</p>
     *         <p>
     *         Constraints: Maximum length of 128 characters.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * Returns the value of the Location property for this object.
     * 
     * @return The value of the Location property for this object.
     */
    public final Location location() {
        return location;
    }

    /**
     * <p>
     * The ID of the site.
     * </p>
     * 
     * @return The ID of the site.
     */
    public final String siteId() {
        return siteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceRequest)) {
            return false;
        }
        UpdateDeviceRequest other = (UpdateDeviceRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(awsLocation(), other.awsLocation()) && Objects.equals(description(), other.description())
                && Objects.equals(type(), other.type()) && Objects.equals(vendor(), other.vendor())
                && Objects.equals(model(), other.model()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(location(), other.location()) && Objects.equals(siteId(), other.siteId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeviceRequest").add("GlobalNetworkId", globalNetworkId()).add("DeviceId", deviceId())
                .add("AWSLocation", awsLocation()).add("Description", description()).add("Type", type()).add("Vendor", vendor())
                .add("Model", model()).add("SerialNumber", serialNumber())
                .add("Location", location() == null ? null : "*** Sensitive Data Redacted ***").add("SiteId", siteId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "AWSLocation":
            return Optional.ofNullable(clazz.cast(awsLocation()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "Model":
            return Optional.ofNullable(clazz.cast(model()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceRequest, T> g) {
        return obj -> g.apply((UpdateDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDeviceRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param deviceId
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this
         * parameter.
         * </p>
         * 
         * @param awsLocation
         *        The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit
         *        this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLocation(AWSLocation awsLocation);

        /**
         * <p>
         * The Amazon Web Services location of the device, if applicable. For an on-premises device, you can omit this
         * parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AWSLocation.Builder} avoiding the need to
         * create one manually via {@link AWSLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AWSLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #awsLocation(AWSLocation)}.
         * 
         * @param awsLocation
         *        a consumer that will call methods on {@link AWSLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLocation(AWSLocation)
         */
        default Builder awsLocation(Consumer<AWSLocation.Builder> awsLocation) {
            return awsLocation(AWSLocation.builder().applyMutation(awsLocation).build());
        }

        /**
         * <p>
         * A description of the device.
         * </p>
         * <p>
         * Constraints: Maximum length of 256 characters.
         * </p>
         * 
         * @param description
         *        A description of the device.</p>
         *        <p>
         *        Constraints: Maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the device.
         * </p>
         * 
         * @param type
         *        The type of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The vendor of the device.
         * </p>
         * <p>
         * Constraints: Maximum length of 128 characters.
         * </p>
         * 
         * @param vendor
         *        The vendor of the device.</p>
         *        <p>
         *        Constraints: Maximum length of 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * The model of the device.
         * </p>
         * <p>
         * Constraints: Maximum length of 128 characters.
         * </p>
         * 
         * @param model
         *        The model of the device.</p>
         *        <p>
         *        Constraints: Maximum length of 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The serial number of the device.
         * </p>
         * <p>
         * Constraints: Maximum length of 128 characters.
         * </p>
         * 
         * @param serialNumber
         *        The serial number of the device.</p>
         *        <p>
         *        Constraints: Maximum length of 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * Sets the value of the Location property for this object.
         *
         * @param location
         *        The new value for the Location property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * Sets the value of the Location property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The ID of the site.
         * </p>
         * 
         * @param siteId
         *        The ID of the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String deviceId;

        private AWSLocation awsLocation;

        private String description;

        private String type;

        private String vendor;

        private String model;

        private String serialNumber;

        private Location location;

        private String siteId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            deviceId(model.deviceId);
            awsLocation(model.awsLocation);
            description(model.description);
            type(model.type);
            vendor(model.vendor);
            model(model.model);
            serialNumber(model.serialNumber);
            location(model.location);
            siteId(model.siteId);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        @Transient
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final AWSLocation.Builder getAwsLocation() {
            return awsLocation != null ? awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AWSLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder awsLocation(AWSLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        @Transient
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        @Transient
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        @Transient
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        @Transient
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceRequest build() {
            return new UpdateDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
