/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcAttachmentRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<UpdateVpcAttachmentRequest.Builder, UpdateVpcAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(UpdateVpcAttachmentRequest::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("attachmentId").build()).build();

    private static final SdkField<List<String>> ADD_SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddSubnetArns")
            .getter(getter(UpdateVpcAttachmentRequest::addSubnetArns))
            .setter(setter(Builder::addSubnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveSubnetArns")
            .getter(getter(UpdateVpcAttachmentRequest::removeSubnetArns))
            .setter(setter(Builder::removeSubnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcOptions> OPTIONS_FIELD = SdkField.<VpcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(UpdateVpcAttachmentRequest::options)).setter(setter(Builder::options))
            .constructor(VpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            ADD_SUBNET_ARNS_FIELD, REMOVE_SUBNET_ARNS_FIELD, OPTIONS_FIELD));

    private final String attachmentId;

    private final List<String> addSubnetArns;

    private final List<String> removeSubnetArns;

    private final VpcOptions options;

    private UpdateVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.addSubnetArns = builder.addSubnetArns;
        this.removeSubnetArns = builder.removeSubnetArns;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddSubnetArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddSubnetArns() {
        return addSubnetArns != null && !(addSubnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds a subnet ARN to the VPC attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddSubnetArns} method.
     * </p>
     * 
     * @return Adds a subnet ARN to the VPC attachment.
     */
    public final List<String> addSubnetArns() {
        return addSubnetArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveSubnetArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveSubnetArns() {
        return removeSubnetArns != null && !(removeSubnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Removes a subnet ARN from the attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveSubnetArns} method.
     * </p>
     * 
     * @return Removes a subnet ARN from the attachment.
     */
    public final List<String> removeSubnetArns() {
        return removeSubnetArns;
    }

    /**
     * <p>
     * Additional options for updating the VPC attachment.
     * </p>
     * 
     * @return Additional options for updating the VPC attachment.
     */
    public final VpcOptions options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddSubnetArns() ? addSubnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveSubnetArns() ? removeSubnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcAttachmentRequest)) {
            return false;
        }
        UpdateVpcAttachmentRequest other = (UpdateVpcAttachmentRequest) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && hasAddSubnetArns() == other.hasAddSubnetArns()
                && Objects.equals(addSubnetArns(), other.addSubnetArns()) && hasRemoveSubnetArns() == other.hasRemoveSubnetArns()
                && Objects.equals(removeSubnetArns(), other.removeSubnetArns()) && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcAttachmentRequest").add("AttachmentId", attachmentId())
                .add("AddSubnetArns", hasAddSubnetArns() ? addSubnetArns() : null)
                .add("RemoveSubnetArns", hasRemoveSubnetArns() ? removeSubnetArns() : null).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "AddSubnetArns":
            return Optional.ofNullable(clazz.cast(addSubnetArns()));
        case "RemoveSubnetArns":
            return Optional.ofNullable(clazz.cast(removeSubnetArns()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateVpcAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcAttachmentRequest> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param attachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * Adds a subnet ARN to the VPC attachment.
         * </p>
         * 
         * @param addSubnetArns
         *        Adds a subnet ARN to the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetArns(Collection<String> addSubnetArns);

        /**
         * <p>
         * Adds a subnet ARN to the VPC attachment.
         * </p>
         * 
         * @param addSubnetArns
         *        Adds a subnet ARN to the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetArns(String... addSubnetArns);

        /**
         * <p>
         * Removes a subnet ARN from the attachment.
         * </p>
         * 
         * @param removeSubnetArns
         *        Removes a subnet ARN from the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetArns(Collection<String> removeSubnetArns);

        /**
         * <p>
         * Removes a subnet ARN from the attachment.
         * </p>
         * 
         * @param removeSubnetArns
         *        Removes a subnet ARN from the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetArns(String... removeSubnetArns);

        /**
         * <p>
         * Additional options for updating the VPC attachment.
         * </p>
         * 
         * @param options
         *        Additional options for updating the VPC attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpcOptions options);

        /**
         * <p>
         * Additional options for updating the VPC attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOptions.Builder} avoiding the need to
         * create one manually via {@link VpcOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #options(VpcOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link VpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(VpcOptions)
         */
        default Builder options(Consumer<VpcOptions.Builder> options) {
            return options(VpcOptions.builder().applyMutation(options).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String attachmentId;

        private List<String> addSubnetArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeSubnetArns = DefaultSdkAutoConstructList.getInstance();

        private VpcOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcAttachmentRequest model) {
            super(model);
            attachmentId(model.attachmentId);
            addSubnetArns(model.addSubnetArns);
            removeSubnetArns(model.removeSubnetArns);
            options(model.options);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        @Transient
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Collection<String> getAddSubnetArns() {
            if (addSubnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return addSubnetArns;
        }

        public final void setAddSubnetArns(Collection<String> addSubnetArns) {
            this.addSubnetArns = SubnetArnListCopier.copy(addSubnetArns);
        }

        @Override
        @Transient
        public final Builder addSubnetArns(Collection<String> addSubnetArns) {
            this.addSubnetArns = SubnetArnListCopier.copy(addSubnetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSubnetArns(String... addSubnetArns) {
            addSubnetArns(Arrays.asList(addSubnetArns));
            return this;
        }

        public final Collection<String> getRemoveSubnetArns() {
            if (removeSubnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return removeSubnetArns;
        }

        public final void setRemoveSubnetArns(Collection<String> removeSubnetArns) {
            this.removeSubnetArns = SubnetArnListCopier.copy(removeSubnetArns);
        }

        @Override
        @Transient
        public final Builder removeSubnetArns(Collection<String> removeSubnetArns) {
            this.removeSubnetArns = SubnetArnListCopier.copy(removeSubnetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSubnetArns(String... removeSubnetArns) {
            removeSubnetArns(Arrays.asList(removeSubnetArns));
            return this;
        }

        public final VpcOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(VpcOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(VpcOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcAttachmentRequest build() {
            return new UpdateVpcAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
