/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a core network policy. You can have only one LIVE Core Policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkPolicy.Builder, CoreNetworkPolicy> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(CoreNetworkPolicy::coreNetworkId)).setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId").build()).build();

    private static final SdkField<Integer> POLICY_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PolicyVersionId").getter(getter(CoreNetworkPolicy::policyVersionId))
            .setter(setter(Builder::policyVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersionId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(CoreNetworkPolicy::aliasAsString)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CoreNetworkPolicy::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(CoreNetworkPolicy::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> CHANGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetState").getter(getter(CoreNetworkPolicy::changeSetStateAsString))
            .setter(setter(Builder::changeSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetState").build()).build();

    private static final SdkField<List<CoreNetworkPolicyError>> POLICY_ERRORS_FIELD = SdkField
            .<List<CoreNetworkPolicyError>> builder(MarshallingType.LIST)
            .memberName("PolicyErrors")
            .getter(getter(CoreNetworkPolicy::policyErrors))
            .setter(setter(Builder::policyErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoreNetworkPolicyError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoreNetworkPolicyError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(CoreNetworkPolicy::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            POLICY_VERSION_ID_FIELD, ALIAS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CHANGE_SET_STATE_FIELD,
            POLICY_ERRORS_FIELD, POLICY_DOCUMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String coreNetworkId;

    private final Integer policyVersionId;

    private final String alias;

    private final String description;

    private final Instant createdAt;

    private final String changeSetState;

    private final List<CoreNetworkPolicyError> policyErrors;

    private final String policyDocument;

    private CoreNetworkPolicy(BuilderImpl builder) {
        this.coreNetworkId = builder.coreNetworkId;
        this.policyVersionId = builder.policyVersionId;
        this.alias = builder.alias;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.changeSetState = builder.changeSetState;
        this.policyErrors = builder.policyErrors;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ID of the policy version.
     * </p>
     * 
     * @return The ID of the policy version.
     */
    public final Integer policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return Whether a core network policy is the current LIVE policy or the most recently submitted policy.
     * @see CoreNetworkPolicyAlias
     */
    public final CoreNetworkPolicyAlias alias() {
        return CoreNetworkPolicyAlias.fromValue(alias);
    }

    /**
     * <p>
     * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alias} will return
     * {@link CoreNetworkPolicyAlias#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aliasAsString}.
     * </p>
     * 
     * @return Whether a core network policy is the current LIVE policy or the most recently submitted policy.
     * @see CoreNetworkPolicyAlias
     */
    public final String aliasAsString() {
        return alias;
    }

    /**
     * <p>
     * The description of a core network policy.
     * </p>
     * 
     * @return The description of a core network policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when a core network policy was created.
     * </p>
     * 
     * @return The timestamp when a core network policy was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The state of a core network policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetState}
     * will return {@link ChangeSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeSetStateAsString}.
     * </p>
     * 
     * @return The state of a core network policy.
     * @see ChangeSetState
     */
    public final ChangeSetState changeSetState() {
        return ChangeSetState.fromValue(changeSetState);
    }

    /**
     * <p>
     * The state of a core network policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changeSetState}
     * will return {@link ChangeSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #changeSetStateAsString}.
     * </p>
     * 
     * @return The state of a core network policy.
     * @see ChangeSetState
     */
    public final String changeSetStateAsString() {
        return changeSetState;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyErrors() {
        return policyErrors != null && !(policyErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes any errors in a core network policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyErrors} method.
     * </p>
     * 
     * @return Describes any errors in a core network policy.
     */
    public final List<CoreNetworkPolicyError> policyErrors() {
        return policyErrors;
    }

    /**
     * <p>
     * Describes a core network policy.
     * </p>
     * 
     * @return Describes a core network policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(changeSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyErrors() ? policyErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkPolicy)) {
            return false;
        }
        CoreNetworkPolicy other = (CoreNetworkPolicy) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(policyVersionId(), other.policyVersionId())
                && Objects.equals(aliasAsString(), other.aliasAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(changeSetStateAsString(), other.changeSetStateAsString())
                && hasPolicyErrors() == other.hasPolicyErrors() && Objects.equals(policyErrors(), other.policyErrors())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkPolicy").add("CoreNetworkId", coreNetworkId())
                .add("PolicyVersionId", policyVersionId()).add("Alias", aliasAsString()).add("Description", description())
                .add("CreatedAt", createdAt()).add("ChangeSetState", changeSetStateAsString())
                .add("PolicyErrors", hasPolicyErrors() ? policyErrors() : null).add("PolicyDocument", policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "PolicyVersionId":
            return Optional.ofNullable(clazz.cast(policyVersionId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(aliasAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ChangeSetState":
            return Optional.ofNullable(clazz.cast(changeSetStateAsString()));
        case "PolicyErrors":
            return Optional.ofNullable(clazz.cast(policyErrors()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkPolicy, T> g) {
        return obj -> g.apply((CoreNetworkPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkPolicy> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ID of the policy version.
         * </p>
         * 
         * @param policyVersionId
         *        The ID of the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(Integer policyVersionId);

        /**
         * <p>
         * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
         * </p>
         * 
         * @param alias
         *        Whether a core network policy is the current LIVE policy or the most recently submitted policy.
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(String alias);

        /**
         * <p>
         * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
         * </p>
         * 
         * @param alias
         *        Whether a core network policy is the current LIVE policy or the most recently submitted policy.
         * @see CoreNetworkPolicyAlias
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoreNetworkPolicyAlias
         */
        Builder alias(CoreNetworkPolicyAlias alias);

        /**
         * <p>
         * The description of a core network policy.
         * </p>
         * 
         * @param description
         *        The description of a core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when a core network policy was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when a core network policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The state of a core network policy.
         * </p>
         * 
         * @param changeSetState
         *        The state of a core network policy.
         * @see ChangeSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetState
         */
        Builder changeSetState(String changeSetState);

        /**
         * <p>
         * The state of a core network policy.
         * </p>
         * 
         * @param changeSetState
         *        The state of a core network policy.
         * @see ChangeSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSetState
         */
        Builder changeSetState(ChangeSetState changeSetState);

        /**
         * <p>
         * Describes any errors in a core network policy.
         * </p>
         * 
         * @param policyErrors
         *        Describes any errors in a core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyErrors(Collection<CoreNetworkPolicyError> policyErrors);

        /**
         * <p>
         * Describes any errors in a core network policy.
         * </p>
         * 
         * @param policyErrors
         *        Describes any errors in a core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyErrors(CoreNetworkPolicyError... policyErrors);

        /**
         * <p>
         * Describes any errors in a core network policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CoreNetworkPolicyError>.Builder}
         * avoiding the need to create one manually via {@link List<CoreNetworkPolicyError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CoreNetworkPolicyError>.Builder#build()} is called
         * immediately and its result is passed to {@link #policyErrors(List<CoreNetworkPolicyError>)}.
         * 
         * @param policyErrors
         *        a consumer that will call methods on {@link List<CoreNetworkPolicyError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyErrors(List<CoreNetworkPolicyError>)
         */
        Builder policyErrors(Consumer<CoreNetworkPolicyError.Builder>... policyErrors);

        /**
         * <p>
         * Describes a core network policy.
         * </p>
         * 
         * @param policyDocument
         *        Describes a core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);
    }

    static final class BuilderImpl implements Builder {
        private String coreNetworkId;

        private Integer policyVersionId;

        private String alias;

        private String description;

        private Instant createdAt;

        private String changeSetState;

        private List<CoreNetworkPolicyError> policyErrors = DefaultSdkAutoConstructList.getInstance();

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkPolicy model) {
            coreNetworkId(model.coreNetworkId);
            policyVersionId(model.policyVersionId);
            alias(model.alias);
            description(model.description);
            createdAt(model.createdAt);
            changeSetState(model.changeSetState);
            policyErrors(model.policyErrors);
            policyDocument(model.policyDocument);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final Integer getPolicyVersionId() {
            return policyVersionId;
        }

        public final void setPolicyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public final Builder alias(CoreNetworkPolicyAlias alias) {
            this.alias(alias == null ? null : alias.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getChangeSetState() {
            return changeSetState;
        }

        public final void setChangeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
        }

        @Override
        public final Builder changeSetState(String changeSetState) {
            this.changeSetState = changeSetState;
            return this;
        }

        @Override
        public final Builder changeSetState(ChangeSetState changeSetState) {
            this.changeSetState(changeSetState == null ? null : changeSetState.toString());
            return this;
        }

        public final List<CoreNetworkPolicyError.Builder> getPolicyErrors() {
            List<CoreNetworkPolicyError.Builder> result = CoreNetworkPolicyErrorListCopier.copyToBuilder(this.policyErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyErrors(Collection<CoreNetworkPolicyError.BuilderImpl> policyErrors) {
            this.policyErrors = CoreNetworkPolicyErrorListCopier.copyFromBuilder(policyErrors);
        }

        @Override
        public final Builder policyErrors(Collection<CoreNetworkPolicyError> policyErrors) {
            this.policyErrors = CoreNetworkPolicyErrorListCopier.copy(policyErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyErrors(CoreNetworkPolicyError... policyErrors) {
            policyErrors(Arrays.asList(policyErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyErrors(Consumer<CoreNetworkPolicyError.Builder>... policyErrors) {
            policyErrors(Stream.of(policyErrors).map(c -> CoreNetworkPolicyError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public CoreNetworkPolicy build() {
            return new CoreNetworkPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
