/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSiteRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<UpdateSiteRequest.Builder, UpdateSiteRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(UpdateSiteRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(UpdateSiteRequest::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("siteId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateSiteRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .memberName("Location").getter(getter(UpdateSiteRequest::location)).setter(setter(Builder::location))
            .constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            SITE_ID_FIELD, DESCRIPTION_FIELD, LOCATION_FIELD));

    private final String globalNetworkId;

    private final String siteId;

    private final String description;

    private final Location location;

    private UpdateSiteRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.siteId = builder.siteId;
        this.description = builder.description;
        this.location = builder.location;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The ID of your site.
     * </p>
     * 
     * @return The ID of your site.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * <p>
     * A description of your site.
     * </p>
     * <p>
     * Constraints: Maximum length of 256 characters.
     * </p>
     * 
     * @return A description of your site.</p>
     *         <p>
     *         Constraints: Maximum length of 256 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The site location:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Address</code>: The physical address of the site.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Latitude</code>: The latitude of the site.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Longitude</code>: The longitude of the site.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The site location:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Address</code>: The physical address of the site.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Latitude</code>: The latitude of the site.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Longitude</code>: The longitude of the site.
     *         </p>
     *         </li>
     */
    public final Location location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSiteRequest)) {
            return false;
        }
        UpdateSiteRequest other = (UpdateSiteRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId()) && Objects.equals(siteId(), other.siteId())
                && Objects.equals(description(), other.description()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSiteRequest").add("GlobalNetworkId", globalNetworkId()).add("SiteId", siteId())
                .add("Description", description()).add("Location", location() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSiteRequest, T> g) {
        return obj -> g.apply((UpdateSiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSiteRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The ID of your site.
         * </p>
         * 
         * @param siteId
         *        The ID of your site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * <p>
         * A description of your site.
         * </p>
         * <p>
         * Constraints: Maximum length of 256 characters.
         * </p>
         * 
         * @param description
         *        A description of your site.</p>
         *        <p>
         *        Constraints: Maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The site location:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Address</code>: The physical address of the site.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Latitude</code>: The latitude of the site.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Longitude</code>: The longitude of the site.
         * </p>
         * </li>
         * </ul>
         * 
         * @param location
         *        The site location:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Address</code>: The physical address of the site.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Latitude</code>: The latitude of the site.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Longitude</code>: The longitude of the site.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The site location:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Address</code>: The physical address of the site.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Latitude</code>: The latitude of the site.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Longitude</code>: The longitude of the site.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link Location.Builder} avoiding the need to
         * create one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String siteId;

        private String description;

        private Location location;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSiteRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            siteId(model.siteId);
            description(model.description);
            location(model.location);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSiteRequest build() {
            return new UpdateSiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
