/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSiteToSiteVpnAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<CreateSiteToSiteVpnAttachmentResponse.Builder, CreateSiteToSiteVpnAttachmentResponse> {
    private static final SdkField<SiteToSiteVpnAttachment> SITE_TO_SITE_VPN_ATTACHMENT_FIELD = SdkField
            .<SiteToSiteVpnAttachment> builder(MarshallingType.SDK_POJO).memberName("SiteToSiteVpnAttachment")
            .getter(getter(CreateSiteToSiteVpnAttachmentResponse::siteToSiteVpnAttachment))
            .setter(setter(Builder::siteToSiteVpnAttachment)).constructor(SiteToSiteVpnAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteToSiteVpnAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SITE_TO_SITE_VPN_ATTACHMENT_FIELD));

    private final SiteToSiteVpnAttachment siteToSiteVpnAttachment;

    private CreateSiteToSiteVpnAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.siteToSiteVpnAttachment = builder.siteToSiteVpnAttachment;
    }

    /**
     * <p>
     * Details about a site-to-site VPN attachment.
     * </p>
     * 
     * @return Details about a site-to-site VPN attachment.
     */
    public final SiteToSiteVpnAttachment siteToSiteVpnAttachment() {
        return siteToSiteVpnAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(siteToSiteVpnAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSiteToSiteVpnAttachmentResponse)) {
            return false;
        }
        CreateSiteToSiteVpnAttachmentResponse other = (CreateSiteToSiteVpnAttachmentResponse) obj;
        return Objects.equals(siteToSiteVpnAttachment(), other.siteToSiteVpnAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSiteToSiteVpnAttachmentResponse")
                .add("SiteToSiteVpnAttachment", siteToSiteVpnAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteToSiteVpnAttachment":
            return Optional.ofNullable(clazz.cast(siteToSiteVpnAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSiteToSiteVpnAttachmentResponse, T> g) {
        return obj -> g.apply((CreateSiteToSiteVpnAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSiteToSiteVpnAttachmentResponse> {
        /**
         * <p>
         * Details about a site-to-site VPN attachment.
         * </p>
         * 
         * @param siteToSiteVpnAttachment
         *        Details about a site-to-site VPN attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteToSiteVpnAttachment(SiteToSiteVpnAttachment siteToSiteVpnAttachment);

        /**
         * <p>
         * Details about a site-to-site VPN attachment.
         * </p>
         * This is a convenience method that creates an instance of the {@link SiteToSiteVpnAttachment.Builder} avoiding
         * the need to create one manually via {@link SiteToSiteVpnAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link SiteToSiteVpnAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #siteToSiteVpnAttachment(SiteToSiteVpnAttachment)}.
         * 
         * @param siteToSiteVpnAttachment
         *        a consumer that will call methods on {@link SiteToSiteVpnAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #siteToSiteVpnAttachment(SiteToSiteVpnAttachment)
         */
        default Builder siteToSiteVpnAttachment(Consumer<SiteToSiteVpnAttachment.Builder> siteToSiteVpnAttachment) {
            return siteToSiteVpnAttachment(SiteToSiteVpnAttachment.builder().applyMutation(siteToSiteVpnAttachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private SiteToSiteVpnAttachment siteToSiteVpnAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSiteToSiteVpnAttachmentResponse model) {
            super(model);
            siteToSiteVpnAttachment(model.siteToSiteVpnAttachment);
        }

        public final SiteToSiteVpnAttachment.Builder getSiteToSiteVpnAttachment() {
            return siteToSiteVpnAttachment != null ? siteToSiteVpnAttachment.toBuilder() : null;
        }

        public final void setSiteToSiteVpnAttachment(SiteToSiteVpnAttachment.BuilderImpl siteToSiteVpnAttachment) {
            this.siteToSiteVpnAttachment = siteToSiteVpnAttachment != null ? siteToSiteVpnAttachment.build() : null;
        }

        @Override
        public final Builder siteToSiteVpnAttachment(SiteToSiteVpnAttachment siteToSiteVpnAttachment) {
            this.siteToSiteVpnAttachment = siteToSiteVpnAttachment;
            return this;
        }

        @Override
        public CreateSiteToSiteVpnAttachmentResponse build() {
            return new CreateSiteToSiteVpnAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
