/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountStatus implements SdkPojo, Serializable, ToCopyableBuilder<AccountStatus.Builder, AccountStatus> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountStatus::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> SLR_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SLRDeploymentStatus").getter(getter(AccountStatus::slrDeploymentStatus))
            .setter(setter(Builder::slrDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SLRDeploymentStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SLR_DEPLOYMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String slrDeploymentStatus;

    private AccountStatus(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.slrDeploymentStatus = builder.slrDeploymentStatus;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the SLRDeploymentStatus property for this object.
     * 
     * @return The value of the SLRDeploymentStatus property for this object.
     */
    public final String slrDeploymentStatus() {
        return slrDeploymentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(slrDeploymentStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountStatus)) {
            return false;
        }
        AccountStatus other = (AccountStatus) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(slrDeploymentStatus(), other.slrDeploymentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountStatus").add("AccountId", accountId()).add("SLRDeploymentStatus", slrDeploymentStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "SLRDeploymentStatus":
            return Optional.ofNullable(clazz.cast(slrDeploymentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountStatus, T> g) {
        return obj -> g.apply((AccountStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountStatus> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the SLRDeploymentStatus property for this object.
         *
         * @param slrDeploymentStatus
         *        The new value for the SLRDeploymentStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slrDeploymentStatus(String slrDeploymentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String slrDeploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountStatus model) {
            accountId(model.accountId);
            slrDeploymentStatus(model.slrDeploymentStatus);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSlrDeploymentStatus() {
            return slrDeploymentStatus;
        }

        public final void setSlrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
        }

        @Override
        public final Builder slrDeploymentStatus(String slrDeploymentStatus) {
            this.slrDeploymentStatus = slrDeploymentStatus;
            return this;
        }

        @Override
        public AccountStatus build() {
            return new AccountStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
