/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details describing a core network change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoreNetworkChange implements SdkPojo, Serializable,
        ToCopyableBuilder<CoreNetworkChange.Builder, CoreNetworkChange> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CoreNetworkChange::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(CoreNetworkChange::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(CoreNetworkChange::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<CoreNetworkChangeValues> PREVIOUS_VALUES_FIELD = SdkField
            .<CoreNetworkChangeValues> builder(MarshallingType.SDK_POJO).memberName("PreviousValues")
            .getter(getter(CoreNetworkChange::previousValues)).setter(setter(Builder::previousValues))
            .constructor(CoreNetworkChangeValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValues").build()).build();

    private static final SdkField<CoreNetworkChangeValues> NEW_VALUES_FIELD = SdkField
            .<CoreNetworkChangeValues> builder(MarshallingType.SDK_POJO).memberName("NewValues")
            .getter(getter(CoreNetworkChange::newValues)).setter(setter(Builder::newValues))
            .constructor(CoreNetworkChangeValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD,
            IDENTIFIER_FIELD, PREVIOUS_VALUES_FIELD, NEW_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String action;

    private final String identifier;

    private final CoreNetworkChangeValues previousValues;

    private final CoreNetworkChangeValues newValues;

    private CoreNetworkChange(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
        this.identifier = builder.identifier;
        this.previousValues = builder.previousValues;
        this.newValues = builder.newValues;
    }

    /**
     * <p>
     * The type of change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of change.
     * @see ChangeType
     */
    public final ChangeType type() {
        return ChangeType.fromValue(type);
    }

    /**
     * <p>
     * The type of change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of change.
     * @see ChangeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The action to take for a core network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take for a core network.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take for a core network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take for a core network.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The resource identifier.
     * </p>
     * 
     * @return The resource identifier.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The previous values for a core network.
     * </p>
     * 
     * @return The previous values for a core network.
     */
    public final CoreNetworkChangeValues previousValues() {
        return previousValues;
    }

    /**
     * <p>
     * The new value for a core network
     * </p>
     * 
     * @return The new value for a core network
     */
    public final CoreNetworkChangeValues newValues() {
        return newValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(previousValues());
        hashCode = 31 * hashCode + Objects.hashCode(newValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkChange)) {
            return false;
        }
        CoreNetworkChange other = (CoreNetworkChange) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(previousValues(), other.previousValues())
                && Objects.equals(newValues(), other.newValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoreNetworkChange").add("Type", typeAsString()).add("Action", actionAsString())
                .add("Identifier", identifier()).add("PreviousValues", previousValues()).add("NewValues", newValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "PreviousValues":
            return Optional.ofNullable(clazz.cast(previousValues()));
        case "NewValues":
            return Optional.ofNullable(clazz.cast(newValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkChange, T> g) {
        return obj -> g.apply((CoreNetworkChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoreNetworkChange> {
        /**
         * <p>
         * The type of change.
         * </p>
         * 
         * @param type
         *        The type of change.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of change.
         * </p>
         * 
         * @param type
         *        The type of change.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder type(ChangeType type);

        /**
         * <p>
         * The action to take for a core network.
         * </p>
         * 
         * @param action
         *        The action to take for a core network.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take for a core network.
         * </p>
         * 
         * @param action
         *        The action to take for a core network.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * The resource identifier.
         * </p>
         * 
         * @param identifier
         *        The resource identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The previous values for a core network.
         * </p>
         * 
         * @param previousValues
         *        The previous values for a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousValues(CoreNetworkChangeValues previousValues);

        /**
         * <p>
         * The previous values for a core network.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetworkChangeValues.Builder} avoiding
         * the need to create one manually via {@link CoreNetworkChangeValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoreNetworkChangeValues.Builder#build()} is called immediately
         * and its result is passed to {@link #previousValues(CoreNetworkChangeValues)}.
         * 
         * @param previousValues
         *        a consumer that will call methods on {@link CoreNetworkChangeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousValues(CoreNetworkChangeValues)
         */
        default Builder previousValues(Consumer<CoreNetworkChangeValues.Builder> previousValues) {
            return previousValues(CoreNetworkChangeValues.builder().applyMutation(previousValues).build());
        }

        /**
         * <p>
         * The new value for a core network
         * </p>
         * 
         * @param newValues
         *        The new value for a core network
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValues(CoreNetworkChangeValues newValues);

        /**
         * <p>
         * The new value for a core network
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetworkChangeValues.Builder} avoiding
         * the need to create one manually via {@link CoreNetworkChangeValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoreNetworkChangeValues.Builder#build()} is called immediately
         * and its result is passed to {@link #newValues(CoreNetworkChangeValues)}.
         * 
         * @param newValues
         *        a consumer that will call methods on {@link CoreNetworkChangeValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newValues(CoreNetworkChangeValues)
         */
        default Builder newValues(Consumer<CoreNetworkChangeValues.Builder> newValues) {
            return newValues(CoreNetworkChangeValues.builder().applyMutation(newValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String action;

        private String identifier;

        private CoreNetworkChangeValues previousValues;

        private CoreNetworkChangeValues newValues;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkChange model) {
            type(model.type);
            action(model.action);
            identifier(model.identifier);
            previousValues(model.previousValues);
            newValues(model.newValues);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final CoreNetworkChangeValues.Builder getPreviousValues() {
            return previousValues != null ? previousValues.toBuilder() : null;
        }

        public final void setPreviousValues(CoreNetworkChangeValues.BuilderImpl previousValues) {
            this.previousValues = previousValues != null ? previousValues.build() : null;
        }

        @Override
        public final Builder previousValues(CoreNetworkChangeValues previousValues) {
            this.previousValues = previousValues;
            return this;
        }

        public final CoreNetworkChangeValues.Builder getNewValues() {
            return newValues != null ? newValues.toBuilder() : null;
        }

        public final void setNewValues(CoreNetworkChangeValues.BuilderImpl newValues) {
            this.newValues = newValues != null ? newValues.build() : null;
        }

        @Override
        public final Builder newValues(CoreNetworkChangeValues newValues) {
            this.newValues = newValues;
            return this;
        }

        @Override
        public CoreNetworkChange build() {
            return new CoreNetworkChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
