/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<AcceptAttachmentResponse.Builder, AcceptAttachmentResponse> {
    private static final SdkField<Attachment> ATTACHMENT_FIELD = SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment").getter(getter(AcceptAttachmentResponse::attachment)).setter(setter(Builder::attachment))
            .constructor(Attachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD));

    private final Attachment attachment;

    private AcceptAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
    }

    /**
     * <p>
     * The response to the attachment request.
     * </p>
     * 
     * @return The response to the attachment request.
     */
    public final Attachment attachment() {
        return attachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptAttachmentResponse)) {
            return false;
        }
        AcceptAttachmentResponse other = (AcceptAttachmentResponse) obj;
        return Objects.equals(attachment(), other.attachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptAttachmentResponse").add("Attachment", attachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptAttachmentResponse, T> g) {
        return obj -> g.apply((AcceptAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, AcceptAttachmentResponse> {
        /**
         * <p>
         * The response to the attachment request.
         * </p>
         * 
         * @param attachment
         *        The response to the attachment request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(Attachment attachment);

        /**
         * <p>
         * The response to the attachment request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attachment.Builder} avoiding the need to
         * create one manually via {@link Attachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attachment.Builder#build()} is called immediately and its result
         * is passed to {@link #attachment(Attachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(Attachment)
         */
        default Builder attachment(Consumer<Attachment.Builder> attachment) {
            return attachment(Attachment.builder().applyMutation(attachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private Attachment attachment;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptAttachmentResponse model) {
            super(model);
            attachment(model.attachment);
        }

        public final Attachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(Attachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public AcceptAttachmentResponse build() {
            return new AcceptAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
